(* ::Package:: *)

(* ::Title:: *)
(*Integrands of the form x^m (a+b x)^n*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m*)


(* ::Subsection::Closed:: *)
(*Integrands of the form a*)


{0, x, 1, 0}
{1, x, 1, x}
{5, x, 1, 5*x}
{-2, x, 1, -2*x}
{-3/2, x, 1, -3/2*x}
{Pi, x, 1, Pi*x}
{a, x, 1, a*x}
{3*a, x, 1, 3*a*x}
{Pi/Sqrt[16 - E^2], x, 1, (Pi*x)/Sqrt[16 - E^2]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m*)


{x^m, x, 1, x^(1 + m)/(1 + m)}

{x^100, x, 1, x^101/101}
{x^3, x, 1, x^4/4}
{x^2, x, 1, x^3/3}
{x^1, x, 1, x^2/2}
{x^0, x, 1, x}
{1/x^1, x, 1, Log[x]}
{1/x^2, x, 1, -(1/x)}
{1/x^3, x, 1, -(1/(2*x^2))}
{1/x^4, x, 1, -(1/(3*x^3))}
{1/x^100, x, 1, -1/(99*x^99)}


{1/(a*x^n + b*x^n), x, 3, x^(1 - n)/((a + b)*(1 - n))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2)*)


{x^(5/2), x, 1, 2*x^(7/2)/7}
{x^(3/2), x, 1, 2*x^(5/2)/5}
{x^(1/2), x, 1, 2*x^(3/2)/3}
{1/x^(1/2), x, 1, 2*Sqrt[x]}
{1/x^(3/2), x, 1, -2/Sqrt[x]}
{1/x^(5/2), x, 1, -2/(3*x^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3)*)


{x^(5/3), x, 1, (3*x^(8/3))/8}
{x^(4/3), x, 1, (3*x^(7/3))/7}
{x^(2/3), x, 1, (3/5)*x^(5/3)}
{x^(1/3), x, 1, (3/4)*x^(4/3)}
{1/x^(1/3), x, 1, (3*x^(2/3))/2}
{1/x^(2/3), x, 1, 3*x^(1/3)}
{1/x^(4/3), x, 1, -(3/x^(1/3))}
{1/x^(5/3), x, 1, -(3/(2*x^(2/3)))}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a+b x)^n*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x)^n*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^m*(a + b*x), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(2 + m))/(2 + m)}

{x^3*(a + b*x), x, 2, (a*x^4)/4 + (b*x^5)/5}
{x^2*(a + b*x), x, 2, (a*x^3)/3 + (b*x^4)/4}
{x^1*(a + b*x), x, 2, (a*x^2)/2 + (b*x^3)/3}
{x^0*(a + b*x), x, 1, a*x + (b*x^2)/2}
{(a + b*x)/x^1, x, 2, b*x + a*Log[x]}
{(a + b*x)/x^2, x, 2, -(a/x) + b*Log[x]}
{(a + b*x)/x^3, x, 2, -(a/(2*x^2)) - b/x}
{(a + b*x)/x^4, x, 2, -(a/(3*x^3)) - b/(2*x^2)}
{(a + b*x)/x^5, x, 2, -(a/(4*x^4)) - b/(3*x^3)}


{x^m*(a + b*x)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + (b^2*x^(3 + m))/(3 + m)}

{x^3*(a + b*x)^2, x, 2, (a^2*x^4)/4 + (2/5)*a*b*x^5 + (b^2*x^6)/6}
{x^2*(a + b*x)^2, x, 2, (a^2*x^3)/3 + (1/2)*a*b*x^4 + (b^2*x^5)/5}
{x^1*(a + b*x)^2, x, 2, (a^2*x^2)/2 + (2/3)*a*b*x^3 + (b^2*x^4)/4}
{x^0*(a + b*x)^2, x, 1, (a + b*x)^3/(3*b)}
{(a + b*x)^2/x^1, x, 2, 2*a*b*x + (b^2*x^2)/2 + a^2*Log[x]}
{(a + b*x)^2/x^2, x, 2, -(a^2/x) + b^2*x + 2*a*b*Log[x]}
{(a + b*x)^2/x^3, x, 2, -(a^2/(2*x^2)) - (2*a*b)/x + b^2*Log[x]}
{(a + b*x)^2/x^4, x, 1, -((a + b*x)^3/(3*a*x^3))}
{(a + b*x)^2/x^5, x, 2, -(a^2/(4*x^4)) - (2*a*b)/(3*x^3) - b^2/(2*x^2)}
{(a + b*x)^2/x^6, x, 2, -(a^2/(5*x^5)) - (a*b)/(2*x^4) - b^2/(3*x^3)}
{(a + b*x)^2/x^7, x, 2, -(a^2/(6*x^6)) - (2*a*b)/(5*x^5) - b^2/(4*x^4)}
{(a + b*x)^2/x^8, x, 2, -(a^2/(7*x^7)) - (a*b)/(3*x^6) - b^2/(5*x^5)}


{x^m*(a + b*x)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(2 + m))/(2 + m) + (3*a*b^2*x^(3 + m))/(3 + m) + (b^3*x^(4 + m))/(4 + m)}

{x^3*(a + b*x)^3, x, 2, (a^3*x^4)/4 + (3/5)*a^2*b*x^5 + (1/2)*a*b^2*x^6 + (b^3*x^7)/7}
{x^2*(a + b*x)^3, x, 2, (a^3*x^3)/3 + (3/4)*a^2*b*x^4 + (3/5)*a*b^2*x^5 + (b^3*x^6)/6}
{x^1*(a + b*x)^3, x, 2, -((a*(a + b*x)^4)/(4*b^2)) + (a + b*x)^5/(5*b^2)}
{x^0*(a + b*x)^3, x, 1, (a + b*x)^4/(4*b)}
{(a + b*x)^3/x^1, x, 2, 3*a^2*b*x + (3/2)*a*b^2*x^2 + (b^3*x^3)/3 + a^3*Log[x]}
{(a + b*x)^3/x^2, x, 2, -(a^3/x) + 3*a*b^2*x + (b^3*x^2)/2 + 3*a^2*b*Log[x]}
{(a + b*x)^3/x^3, x, 2, -a^3/(2*x^2) - (3*a^2*b)/x + b^3*x + 3*a*b^2*Log[x]}
{(a + b*x)^3/x^4, x, 2, -(a^3/(3*x^3)) - (3*a^2*b)/(2*x^2) - (3*a*b^2)/x + b^3*Log[x]}
{(a + b*x)^3/x^5, x, 1, -((a + b*x)^4/(4*a*x^4))}
{(a + b*x)^3/x^6, x, 2, -(a^3/(5*x^5)) - (3*a^2*b)/(4*x^4) - (a*b^2)/x^3 - b^3/(2*x^2)}
{(a + b*x)^3/x^7, x, 2, -(a^3/(6*x^6)) - (3*a^2*b)/(5*x^5) - (3*a*b^2)/(4*x^4) - b^3/(3*x^3)}
{(a + b*x)^3/x^8, x, 2, -(a^3/(7*x^7)) - (a^2*b)/(2*x^6) - (3*a*b^2)/(5*x^5) - b^3/(4*x^4)}


{x^m*(a + b*x)^7, x, 2, (a^7*x^(1 + m))/(1 + m) + (7*a^6*b*x^(2 + m))/(2 + m) + (21*a^5*b^2*x^(3 + m))/(3 + m) + (35*a^4*b^3*x^(4 + m))/(4 + m) + (35*a^3*b^4*x^(5 + m))/(5 + m) + (21*a^2*b^5*x^(6 + m))/(6 + m) + (7*a*b^6*x^(7 + m))/(7 + m) + (b^7*x^(8 + m))/(8 + m)}

{x^7*(a + b*x)^7, x, 2, (a^7*x^8)/8 + (7*a^6*b*x^9)/9 + (21*a^5*b^2*x^10)/10 + (35*a^4*b^3*x^11)/11 + (35*a^3*b^4*x^12)/12 + (21*a^2*b^5*x^13)/13 + (a*b^6*x^14)/2 + (b^7*x^15)/15}
{x^6*(a + b*x)^7, x, 2, (a^7*x^7)/7 + (7*a^6*b*x^8)/8 + (7*a^5*b^2*x^9)/3 + (7*a^4*b^3*x^10)/2 + (35*a^3*b^4*x^11)/11 + (7*a^2*b^5*x^12)/4 + (7*a*b^6*x^13)/13 + (b^7*x^14)/14}
{x^5*(a + b*x)^7, x, 2, (a^7*x^6)/6 + a^6*b*x^7 + (21*a^5*b^2*x^8)/8 + (35*a^4*b^3*x^9)/9 + (7*a^3*b^4*x^10)/2 + (21*a^2*b^5*x^11)/11 + (7*a*b^6*x^12)/12 + (b^7*x^13)/13}

{x^4*(a + b*x)^7, x, 2, (a^4*(a + b*x)^8)/(8*b^5) - (4*a^3*(a + b*x)^9)/(9*b^5) + (3*a^2*(a + b*x)^10)/(5*b^5) - (4*a*(a + b*x)^11)/(11*b^5) + (a + b*x)^12/(12*b^5)}
{x^3*(a + b*x)^7, x, 2, -((a^3*(a + b*x)^8)/(8*b^4)) + (a^2*(a + b*x)^9)/(3*b^4) - (3*a*(a + b*x)^10)/(10*b^4) + (a + b*x)^11/(11*b^4)}
{x^2*(a + b*x)^7, x, 2, (a^2*(a + b*x)^8)/(8*b^3) - (2*a*(a + b*x)^9)/(9*b^3) + (a + b*x)^10/(10*b^3)}
{x^1*(a + b*x)^7, x, 2, -((a*(a + b*x)^8)/(8*b^2)) + (a + b*x)^9/(9*b^2)}
{x^0*(a + b*x)^7, x, 1, (a + b*x)^8/(8*b)}

{(a + b*x)^7/x^1, x, 2, 7*a^6*b*x + (21*a^5*b^2*x^2)/2 + (35*a^4*b^3*x^3)/3 + (35*a^3*b^4*x^4)/4 + (21*a^2*b^5*x^5)/5 + (7*a*b^6*x^6)/6 + (b^7*x^7)/7 + a^7*Log[x]}
{(a + b*x)^7/x^2, x, 2, -(a^7/x) + 21*a^5*b^2*x + (35*a^4*b^3*x^2)/2 + (35*a^3*b^4*x^3)/3 + (21*a^2*b^5*x^4)/4 + (7*a*b^6*x^5)/5 + (b^7*x^6)/6 + 7*a^6*b*Log[x]}
{(a + b*x)^7/x^3, x, 2, -a^7/(2*x^2) - (7*a^6*b)/x + 35*a^4*b^3*x + (35*a^3*b^4*x^2)/2 + 7*a^2*b^5*x^3 + (7*a*b^6*x^4)/4 + (b^7*x^5)/5 + 21*a^5*b^2*Log[x]}
{(a + b*x)^7/x^4, x, 2, -(a^7/(3*x^3)) - (7*a^6*b)/(2*x^2) - (21*a^5*b^2)/x + 35*a^3*b^4*x + (21/2)*a^2*b^5*x^2 + (7/3)*a*b^6*x^3 + (b^7*x^4)/4 + 35*a^4*b^3*Log[x]}
{(a + b*x)^7/x^5, x, 2, -(a^7/(4*x^4)) - (7*a^6*b)/(3*x^3) - (21*a^5*b^2)/(2*x^2) - (35*a^4*b^3)/x + 21*a^2*b^5*x + (7/2)*a*b^6*x^2 + (b^7*x^3)/3 + 35*a^3*b^4*Log[x]}
{(a + b*x)^7/x^6, x, 2, -(a^7/(5*x^5)) - (7*a^6*b)/(4*x^4) - (7*a^5*b^2)/x^3 - (35*a^4*b^3)/(2*x^2) - (35*a^3*b^4)/x + 7*a*b^6*x + (b^7*x^2)/2 + 21*a^2*b^5*Log[x]}
{(a + b*x)^7/x^7, x, 2, -(a^7/(6*x^6)) - (7*a^6*b)/(5*x^5) - (21*a^5*b^2)/(4*x^4) - (35*a^4*b^3)/(3*x^3) - (35*a^3*b^4)/(2*x^2) - (21*a^2*b^5)/x + b^7*x + 7*a*b^6*Log[x]}
{(a + b*x)^7/x^8, x, 2, -(a^7/(7*x^7)) - (7*a^6*b)/(6*x^6) - (21*a^5*b^2)/(5*x^5) - (35*a^4*b^3)/(4*x^4) - (35*a^3*b^4)/(3*x^3) - (21*a^2*b^5)/(2*x^2) - (7*a*b^6)/x + b^7*Log[x]}

{(a + b*x)^7/x^9, x, 1, -(a + b*x)^8/(8*a*x^8)}
{(a + b*x)^7/x^10, x, 2, -((a + b*x)^8/(9*a*x^9)) + (b*(a + b*x)^8)/(72*a^2*x^8)}
{(a + b*x)^7/x^11, x, 3, -((a + b*x)^8/(10*a*x^10)) + (b*(a + b*x)^8)/(45*a^2*x^9) - (b^2*(a + b*x)^8)/(360*a^3*x^8)}
{(a + b*x)^7/x^12, x, 4, -((a + b*x)^8/(11*a*x^11)) + (3*b*(a + b*x)^8)/(110*a^2*x^10) - (b^2*(a + b*x)^8)/(165*a^3*x^9) + (b^3*(a + b*x)^8)/(1320*a^4*x^8)}

{(a + b*x)^7/x^13, x, 2, -(a^7/(12*x^12)) - (7*a^6*b)/(11*x^11) - (21*a^5*b^2)/(10*x^10) - (35*a^4*b^3)/(9*x^9) - (35*a^3*b^4)/(8*x^8) - (3*a^2*b^5)/x^7 - (7*a*b^6)/(6*x^6) - b^7/(5*x^5)}
{(a + b*x)^7/x^14, x, 2, -(a^7/(13*x^13)) - (7*a^6*b)/(12*x^12) - (21*a^5*b^2)/(11*x^11) - (7*a^4*b^3)/(2*x^10) - (35*a^3*b^4)/(9*x^9) - (21*a^2*b^5)/(8*x^8) - (a*b^6)/x^7 - b^7/(6*x^6)}
{(a + b*x)^7/x^15, x, 2, -(a^7/(14*x^14)) - (7*a^6*b)/(13*x^13) - (7*a^5*b^2)/(4*x^12) - (35*a^4*b^3)/(11*x^11) - (7*a^3*b^4)/(2*x^10) - (7*a^2*b^5)/(3*x^9) - (7*a*b^6)/(8*x^8) - b^7/(7*x^7)}
{(a + b*x)^7/x^16, x, 2, -(a^7/(15*x^15)) - (a^6*b)/(2*x^14) - (21*a^5*b^2)/(13*x^13) - (35*a^4*b^3)/(12*x^12) - (35*a^3*b^4)/(11*x^11) - (21*a^2*b^5)/(10*x^10) - (7*a*b^6)/(9*x^9) - b^7/(8*x^8)}


{x^m*(a + b*x)^10, x, 2, (a^10*x^(1 + m))/(1 + m) + (10*a^9*b*x^(2 + m))/(2 + m) + (45*a^8*b^2*x^(3 + m))/(3 + m) + (120*a^7*b^3*x^(4 + m))/(4 + m) + (210*a^6*b^4*x^(5 + m))/(5 + m) + (252*a^5*b^5*x^(6 + m))/(6 + m) + (210*a^4*b^6*x^(7 + m))/(7 + m) + (120*a^3*b^7*x^(8 + m))/(8 + m) + (45*a^2*b^8*x^(9 + m))/(9 + m) + (10*a*b^9*x^(10 + m))/(10 + m) + (b^10*x^(11 + m))/(11 + m)}

{x^9*(a + b*x)^10, x, 2, (a^10*x^10)/10 + (10/11)*a^9*b*x^11 + (15/4)*a^8*b^2*x^12 + (120/13)*a^7*b^3*x^13 + 15*a^6*b^4*x^14 + (84/5)*a^5*b^5*x^15 + (105/8)*a^4*b^6*x^16 + (120/17)*a^3*b^7*x^17 + (5/2)*a^2*b^8*x^18 + (10/19)*a*b^9*x^19 + (b^10*x^20)/20}
{x^8*(a + b*x)^10, x, 2, (a^10*x^9)/9 + a^9*b*x^10 + (45/11)*a^8*b^2*x^11 + 10*a^7*b^3*x^12 + (210/13)*a^6*b^4*x^13 + 18*a^5*b^5*x^14 + 14*a^4*b^6*x^15 + (15/2)*a^3*b^7*x^16 + (45/17)*a^2*b^8*x^17 + (5/9)*a*b^9*x^18 + (b^10*x^19)/19}
{x^7*(a + b*x)^10, x, 2, (a^10*x^8)/8 + (10/9)*a^9*b*x^9 + (9/2)*a^8*b^2*x^10 + (120/11)*a^7*b^3*x^11 + (35/2)*a^6*b^4*x^12 + (252/13)*a^5*b^5*x^13 + 15*a^4*b^6*x^14 + 8*a^3*b^7*x^15 + (45/16)*a^2*b^8*x^16 + (10/17)*a*b^9*x^17 + (b^10*x^18)/18}

{x^6*(a + b*x)^10, x, 2, (a^6*(a + b*x)^11)/(11*b^7) - (a^5*(a + b*x)^12)/(2*b^7) + (15*a^4*(a + b*x)^13)/(13*b^7) - (10*a^3*(a + b*x)^14)/(7*b^7) + (a^2*(a + b*x)^15)/b^7 - (3*a*(a + b*x)^16)/(8*b^7) + (a + b*x)^17/(17*b^7)}
{x^5*(a + b*x)^10, x, 2, -((a^5*(a + b*x)^11)/(11*b^6)) + (5*a^4*(a + b*x)^12)/(12*b^6) - (10*a^3*(a + b*x)^13)/(13*b^6) + (5*a^2*(a + b*x)^14)/(7*b^6) - (a*(a + b*x)^15)/(3*b^6) + (a + b*x)^16/(16*b^6)}
{x^4*(a + b*x)^10, x, 2, (a^4*(a + b*x)^11)/(11*b^5) - (a^3*(a + b*x)^12)/(3*b^5) + (6*a^2*(a + b*x)^13)/(13*b^5) - (2*a*(a + b*x)^14)/(7*b^5) + (a + b*x)^15/(15*b^5)}
{x^3*(a + b*x)^10, x, 2, -((a^3*(a + b*x)^11)/(11*b^4)) + (a^2*(a + b*x)^12)/(4*b^4) - (3*a*(a + b*x)^13)/(13*b^4) + (a + b*x)^14/(14*b^4)}
{x^2*(a + b*x)^10, x, 2, (a^2*(a + b*x)^11)/(11*b^3) - (a*(a + b*x)^12)/(6*b^3) + (a + b*x)^13/(13*b^3)}
{x^1*(a + b*x)^10, x, 2, -((a*(a + b*x)^11)/(11*b^2)) + (a + b*x)^12/(12*b^2)}
{x^0*(a + b*x)^10, x, 1, (a + b*x)^11/(11*b)}

{(a + b*x)^10/x^1, x, 2, 10*a^9*b*x + (45/2)*a^8*b^2*x^2 + 40*a^7*b^3*x^3 + (105/2)*a^6*b^4*x^4 + (252/5)*a^5*b^5*x^5 + 35*a^4*b^6*x^6 + (120/7)*a^3*b^7*x^7 + (45/8)*a^2*b^8*x^8 + (10/9)*a*b^9*x^9 + (b^10*x^10)/10 + a^10*Log[x]}
{(a + b*x)^10/x^2, x, 2, -(a^10/x) + 45*a^8*b^2*x + 60*a^7*b^3*x^2 + 70*a^6*b^4*x^3 + 63*a^5*b^5*x^4 + 42*a^4*b^6*x^5 + 20*a^3*b^7*x^6 + (45/7)*a^2*b^8*x^7 + (5/4)*a*b^9*x^8 + (b^10*x^9)/9 + 10*a^9*b*Log[x]}
{(a + b*x)^10/x^3, x, 2, -(a^10/(2*x^2)) - (10*a^9*b)/x + 120*a^7*b^3*x + 105*a^6*b^4*x^2 + 84*a^5*b^5*x^3 + (105/2)*a^4*b^6*x^4 + 24*a^3*b^7*x^5 + (15/2)*a^2*b^8*x^6 + (10/7)*a*b^9*x^7 + (b^10*x^8)/8 + 45*a^8*b^2*Log[x]}
{(a + b*x)^10/x^4, x, 2, -(a^10/(3*x^3)) - (5*a^9*b)/x^2 - (45*a^8*b^2)/x + 210*a^6*b^4*x + 126*a^5*b^5*x^2 + 70*a^4*b^6*x^3 + 30*a^3*b^7*x^4 + 9*a^2*b^8*x^5 + (5/3)*a*b^9*x^6 + (b^10*x^7)/7 + 120*a^7*b^3*Log[x]}
{(a + b*x)^10/x^5, x, 2, -(a^10/(4*x^4)) - (10*a^9*b)/(3*x^3) - (45*a^8*b^2)/(2*x^2) - (120*a^7*b^3)/x + 252*a^5*b^5*x + 105*a^4*b^6*x^2 + 40*a^3*b^7*x^3 + (45/4)*a^2*b^8*x^4 + 2*a*b^9*x^5 + (b^10*x^6)/6 + 210*a^6*b^4*Log[x]}
{(a + b*x)^10/x^6, x, 2, -(a^10/(5*x^5)) - (5*a^9*b)/(2*x^4) - (15*a^8*b^2)/x^3 - (60*a^7*b^3)/x^2 - (210*a^6*b^4)/x + 210*a^4*b^6*x + 60*a^3*b^7*x^2 + 15*a^2*b^8*x^3 + (5/2)*a*b^9*x^4 + (b^10*x^5)/5 + 252*a^5*b^5*Log[x]}
{(a + b*x)^10/x^7, x, 2, -(a^10/(6*x^6)) - (2*a^9*b)/x^5 - (45*a^8*b^2)/(4*x^4) - (40*a^7*b^3)/x^3 - (105*a^6*b^4)/x^2 - (252*a^5*b^5)/x + 120*a^3*b^7*x + (45/2)*a^2*b^8*x^2 + (10/3)*a*b^9*x^3 + (b^10*x^4)/4 + 210*a^4*b^6*Log[x]}
{(a + b*x)^10/x^8, x, 2, -(a^10/(7*x^7)) - (5*a^9*b)/(3*x^6) - (9*a^8*b^2)/x^5 - (30*a^7*b^3)/x^4 - (70*a^6*b^4)/x^3 - (126*a^5*b^5)/x^2 - (210*a^4*b^6)/x + 45*a^2*b^8*x + 5*a*b^9*x^2 + (b^10*x^3)/3 + 120*a^3*b^7*Log[x]}
{(a + b*x)^10/x^9, x, 2, -(a^10/(8*x^8)) - (10*a^9*b)/(7*x^7) - (15*a^8*b^2)/(2*x^6) - (24*a^7*b^3)/x^5 - (105*a^6*b^4)/(2*x^4) - (84*a^5*b^5)/x^3 - (105*a^4*b^6)/x^2 - (120*a^3*b^7)/x + 10*a*b^9*x + (b^10*x^2)/2 + 45*a^2*b^8*Log[x]}
{(a + b*x)^10/x^10, x, 2, -(a^10/(9*x^9)) - (5*a^9*b)/(4*x^8) - (45*a^8*b^2)/(7*x^7) - (20*a^7*b^3)/x^6 - (42*a^6*b^4)/x^5 - (63*a^5*b^5)/x^4 - (70*a^4*b^6)/x^3 - (60*a^3*b^7)/x^2 - (45*a^2*b^8)/x + b^10*x + 10*a*b^9*Log[x]}
{(a + b*x)^10/x^11, x, 2, -(a^10/(10*x^10)) - (10*a^9*b)/(9*x^9) - (45*a^8*b^2)/(8*x^8) - (120*a^7*b^3)/(7*x^7) - (35*a^6*b^4)/x^6 - (252*a^5*b^5)/(5*x^5) - (105*a^4*b^6)/(2*x^4) - (40*a^3*b^7)/x^3 - (45*a^2*b^8)/(2*x^2) - (10*a*b^9)/x + b^10*Log[x]}

{(a + b*x)^10/x^12, x, 1, -((a + b*x)^11/(11*a*x^11))}
{(a + b*x)^10/x^13, x, 2, -((a + b*x)^11/(12*a*x^12)) + (b*(a + b*x)^11)/(132*a^2*x^11)}
{(a + b*x)^10/x^14, x, 3, -((a + b*x)^11/(13*a*x^13)) + (b*(a + b*x)^11)/(78*a^2*x^12) - (b^2*(a + b*x)^11)/(858*a^3*x^11)}
{(a + b*x)^10/x^15, x, 4, -((a + b*x)^11/(14*a*x^14)) + (3*b*(a + b*x)^11)/(182*a^2*x^13) - (b^2*(a + b*x)^11)/(364*a^3*x^12) + (b^3*(a + b*x)^11)/(4004*a^4*x^11)}
{(a + b*x)^10/x^16, x, 5, -((a + b*x)^11/(15*a*x^15)) + (2*b*(a + b*x)^11)/(105*a^2*x^14) - (2*b^2*(a + b*x)^11)/(455*a^3*x^13) + (b^3*(a + b*x)^11)/(1365*a^4*x^12) - (b^4*(a + b*x)^11)/(15015*a^5*x^11)}
{(a + b*x)^10/x^17, x, 6, -((a + b*x)^11/(16*a*x^16)) + (b*(a + b*x)^11)/(48*a^2*x^15) - (b^2*(a + b*x)^11)/(168*a^3*x^14) + (b^3*(a + b*x)^11)/(728*a^4*x^13) - (b^4*(a + b*x)^11)/(4368*a^5*x^12) + (b^5*(a + b*x)^11)/(48048*a^6*x^11)}

{(a + b*x)^10/x^18, x, 2, -(a^10/(17*x^17)) - (5*a^9*b)/(8*x^16) - (3*a^8*b^2)/x^15 - (60*a^7*b^3)/(7*x^14) - (210*a^6*b^4)/(13*x^13) - (21*a^5*b^5)/x^12 - (210*a^4*b^6)/(11*x^11) - (12*a^3*b^7)/x^10 - (5*a^2*b^8)/x^9 - (5*a*b^9)/(4*x^8) - b^10/(7*x^7)}
{(a + b*x)^10/x^19, x, 2, -(a^10/(18*x^18)) - (10*a^9*b)/(17*x^17) - (45*a^8*b^2)/(16*x^16) - (8*a^7*b^3)/x^15 - (15*a^6*b^4)/x^14 - (252*a^5*b^5)/(13*x^13) - (35*a^4*b^6)/(2*x^12) - (120*a^3*b^7)/(11*x^11) - (9*a^2*b^8)/(2*x^10) - (10*a*b^9)/(9*x^9) - b^10/(8*x^8)}
{(a + b*x)^10/x^20, x, 2, -(a^10/(19*x^19)) - (5*a^9*b)/(9*x^18) - (45*a^8*b^2)/(17*x^17) - (15*a^7*b^3)/(2*x^16) - (14*a^6*b^4)/x^15 - (18*a^5*b^5)/x^14 - (210*a^4*b^6)/(13*x^13) - (10*a^3*b^7)/x^12 - (45*a^2*b^8)/(11*x^11) - (a*b^9)/x^10 - b^10/(9*x^9)}


(*
{(a + b*x)^20/x^32, x, 11, -((a + b*x)^21/(31*a*x^31)) + (b*(a + b*x)^21)/(93*a^2*x^30) - (3*b^2*(a + b*x)^21)/(899*a^3*x^29) + (6*b^3*(a + b*x)^21)/(6293*a^4*x^28) - (2*b^4*(a + b*x)^21)/(8091*a^5*x^27) + (2*b^5*(a + b*x)^21)/(35061*a^6*x^26) - (2*b^6*(a + b*x)^21)/(175305*a^7*x^25) + (b^7*(a + b*x)^21)/(525915*a^8*x^24) - (b^8*(a + b*x)^21)/(4032015*a^9*x^23) + (b^9*(a + b*x)^21)/(44352165*a^10*x^22) - (b^10*(a + b*x)^21)/(931395465*a^11*x^21)}
{(a + b*x)^20/x^33, x, 12, -((a + b*x)^21/(32*a*x^32)) + (11*b*(a + b*x)^21)/(992*a^2*x^31) - (11*b^2*(a + b*x)^21)/(2976*a^3*x^30) + (33*b^3*(a + b*x)^21)/(28768*a^4*x^29) - (33*b^4*(a + b*x)^21)/(100688*a^5*x^28) + (11*b^5*(a + b*x)^21)/(129456*a^6*x^27) - (11*b^6*(a + b*x)^21)/(560976*a^7*x^26) + (11*b^7*(a + b*x)^21)/(2804880*a^8*x^25) - (11*b^8*(a + b*x)^21)/(16829280*a^9*x^24) + (11*b^9*(a + b*x)^21)/(129024480*a^10*x^23) - (b^10*(a + b*x)^21)/(129024480*a^11*x^22) + (b^11*(a + b*x)^21)/(2709514080*a^12*x^21)}
{(a + b*x)^20/x^34, x, 13, -((a + b*x)^21/(33*a*x^33)) + (b*(a + b*x)^21)/(88*a^2*x^32) - (b^2*(a + b*x)^21)/(248*a^3*x^31) + (b^3*(a + b*x)^21)/(744*a^4*x^30) - (3*b^4*(a + b*x)^21)/(7192*a^5*x^29) + (3*b^5*(a + b*x)^21)/(25172*a^6*x^28) - (b^6*(a + b*x)^21)/(32364*a^7*x^27) + (b^7*(a + b*x)^21)/(140244*a^8*x^26) - (b^8*(a + b*x)^21)/(701220*a^9*x^25) + (b^9*(a + b*x)^21)/(4207320*a^10*x^24) - (b^10*(a + b*x)^21)/(32256120*a^11*x^23) + (b^11*(a + b*x)^21)/(354817320*a^12*x^22) - (b^12*(a + b*x)^21)/(7451163720*a^13*x^21)}

{(a + b*x)^20/x^35, x, 2, -(a^20/(34*x^34)) - (20*a^19*b)/(33*x^33) - (95*a^18*b^2)/(16*x^32) - (1140*a^17*b^3)/(31*x^31) - (323*a^16*b^4)/(2*x^30) - (15504*a^15*b^5)/(29*x^29) - (9690*a^14*b^6)/(7*x^28) - (25840*a^13*b^7)/(9*x^27) - (4845*a^12*b^8)/x^26 - (33592*a^11*b^9)/(5*x^25) - (46189*a^10*b^10)/(6*x^24) - (167960*a^9*b^11)/(23*x^23) - (62985*a^8*b^12)/(11*x^22) - (25840*a^7*b^13)/(7*x^21) - (1938*a^6*b^14)/x^20 - (816*a^5*b^15)/x^19 - (1615*a^4*b^16)/(6*x^18) - (1140*a^3*b^17)/(17*x^17) - (95*a^2*b^18)/(8*x^16) - (4*a*b^19)/(3*x^15) - b^20/(14*x^14)}
{(a + b*x)^20/x^36, x, 2, -(a^20/(35*x^35)) - (10*a^19*b)/(17*x^34) - (190*a^18*b^2)/(33*x^33) - (285*a^17*b^3)/(8*x^32) - (4845*a^16*b^4)/(31*x^31) - (2584*a^15*b^5)/(5*x^30) - (38760*a^14*b^6)/(29*x^29) - (19380*a^13*b^7)/(7*x^28) - (41990*a^12*b^8)/(9*x^27) - (6460*a^11*b^9)/x^26 - (184756*a^10*b^10)/(25*x^25) - (20995*a^9*b^11)/(3*x^24) - (125970*a^8*b^12)/(23*x^23) - (38760*a^7*b^13)/(11*x^22) - (12920*a^6*b^14)/(7*x^21) - (3876*a^5*b^15)/(5*x^20) - (255*a^4*b^16)/x^19 - (190*a^3*b^17)/(3*x^18) - (190*a^2*b^18)/(17*x^17) - (5*a*b^19)/(4*x^16) - b^20/(15*x^15)}
{(a + b*x)^20/x^37, x, 2, -(a^20/(36*x^36)) - (4*a^19*b)/(7*x^35) - (95*a^18*b^2)/(17*x^34) - (380*a^17*b^3)/(11*x^33) - (4845*a^16*b^4)/(32*x^32) - (15504*a^15*b^5)/(31*x^31) - (1292*a^14*b^6)/x^30 - (77520*a^13*b^7)/(29*x^29) - (62985*a^12*b^8)/(14*x^28) - (167960*a^11*b^9)/(27*x^27) - (7106*a^10*b^10)/x^26 - (33592*a^9*b^11)/(5*x^25) - (20995*a^8*b^12)/(4*x^24) - (77520*a^7*b^13)/(23*x^23) - (19380*a^6*b^14)/(11*x^22) - (5168*a^5*b^15)/(7*x^21) - (969*a^4*b^16)/(4*x^20) - (60*a^3*b^17)/x^19 - (95*a^2*b^18)/(9*x^18) - (20*a*b^19)/(17*x^17) - b^20/(16*x^16)}
*)


{c*(a + b*x), x, 1, (c*(a + b*x)^2)/(2*b)}
{((c + d)*(a + b*x))/e, x, 1, ((c + d)*(a + b*x)^2)/(2*b*e)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^m/(a + b*x), x, 1, (x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(a*(1 + m))}

{x^5/(a + b*x), x, 2, (a^4*x)/b^5 - (a^3*x^2)/(2*b^4) + (a^2*x^3)/(3*b^3) - (a*x^4)/(4*b^2) + x^5/(5*b) - (a^5*Log[a + b*x])/b^6}
{x^4/(a + b*x), x, 2, -((a^3*x)/b^4) + (a^2*x^2)/(2*b^3) - (a*x^3)/(3*b^2) + x^4/(4*b) + (a^4*Log[a + b*x])/b^5}
{x^3/(a + b*x), x, 2, (a^2*x)/b^3 - (a*x^2)/(2*b^2) + x^3/(3*b) - (a^3*Log[a + b*x])/b^4}
{x^2/(a + b*x), x, 2, -((a*x)/b^2) + x^2/(2*b) + (a^2*Log[a + b*x])/b^3}
{x^1/(a + b*x), x, 2, x/b - (a*Log[a + b*x])/b^2}
{x^0/(a + b*x), x, 1, Log[a + b*x]/b}
{1/(x^1*(a + b*x)), x, 2, Log[x]/a - Log[a + b*x]/a}
{1/(x^2*(a + b*x)), x, 2, -(1/(a*x)) - (b*Log[x])/a^2 + (b*Log[a + b*x])/a^2}
{1/(x^3*(a + b*x)), x, 2, -(1/(2*a*x^2)) + b/(a^2*x) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x])/a^3}
{1/(x^4*(a + b*x)), x, 2, -(1/(3*a*x^3)) + b/(2*a^2*x^2) - b^2/(a^3*x) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x])/a^4}
{1/(x^5*(a + b*x)), x, 2, -(1/(4*a*x^4)) + b/(3*a^2*x^3) - b^2/(2*a^3*x^2) + b^3/(a^4*x) + (b^4*Log[x])/a^5 - (b^4*Log[a + b*x])/a^5}


{x^m/(a + b*x)^2, x, 2, x^(1 + m)/(a*(a + b*x)) - (m*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(a^2*(1 + m))}

{x^6/(a + b*x)^2, x, 2, (5*a^4*x)/b^6 - (2*a^3*x^2)/b^5 + (a^2*x^3)/b^4 - (a*x^4)/(2*b^3) + x^5/(5*b^2) - a^6/(b^7*(a + b*x)) - (6*a^5*Log[a + b*x])/b^7}
{x^5/(a + b*x)^2, x, 2, -((4*a^3*x)/b^5) + (3*a^2*x^2)/(2*b^4) - (2*a*x^3)/(3*b^3) + x^4/(4*b^2) + a^5/(b^6*(a + b*x)) + (5*a^4*Log[a + b*x])/b^6}
{x^4/(a + b*x)^2, x, 2, (3*a^2*x)/b^4 - (a*x^2)/b^3 + x^3/(3*b^2) - a^4/(b^5*(a + b*x)) - (4*a^3*Log[a + b*x])/b^5}
{x^3/(a + b*x)^2, x, 2, -((2*a*x)/b^3) + x^2/(2*b^2) + a^3/(b^4*(a + b*x)) + (3*a^2*Log[a + b*x])/b^4}
{x^2/(a + b*x)^2, x, 2, x/b^2 - a^2/(b^3*(a + b*x)) - (2*a*Log[a + b*x])/b^3}
{x^1/(a + b*x)^2, x, 2, a/(b^2*(a + b*x)) + Log[a + b*x]/b^2}
{x^0/(a + b*x)^2, x, 1, -(1/(b*(a + b*x)))}
{1/(x^1*(a + b*x)^2), x, 2, 1/(a*(a + b*x)) + Log[x]/a^2 - Log[a + b*x]/a^2}
{1/(x^2*(a + b*x)^2), x, 2, -(1/(a^2*x)) - b/(a^2*(a + b*x)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x])/a^3}
{1/(x^3*(a + b*x)^2), x, 2, -(1/(2*a^2*x^2)) + (2*b)/(a^3*x) + b^2/(a^3*(a + b*x)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x])/a^4}
{1/(x^4*(a + b*x)^2), x, 2, -(1/(3*a^2*x^3)) + b/(a^3*x^2) - (3*b^2)/(a^4*x) - b^3/(a^4*(a + b*x)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x])/a^5}
{1/(x^5*(a + b*x)^2), x, 2, -(1/(4*a^2*x^4)) + (2*b)/(3*a^3*x^3) - (3*b^2)/(2*a^4*x^2) + (4*b^3)/(a^5*x) + b^4/(a^5*(a + b*x)) + (5*b^4*Log[x])/a^6 - (5*b^4*Log[a + b*x])/a^6}


{x^m/(a + b*x)^3, x, 3, x^(1 + m)/(2*a*(a + b*x)^2) + ((1 - m)*x^(1 + m))/(2*a^2*(a + b*x)) - ((1 - m)*m*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(2*a^3*(1 + m))}

{x^7/(a + b*x)^3, x, 2, (15*a^4*x)/b^7 - (5*a^3*x^2)/b^6 + (2*a^2*x^3)/b^5 - (3*a*x^4)/(4*b^4) + x^5/(5*b^3) + a^7/(2*b^8*(a + b*x)^2) - (7*a^6)/(b^8*(a + b*x)) - (21*a^5*Log[a + b*x])/b^8}
{x^6/(a + b*x)^3, x, 2, -((10*a^3*x)/b^6) + (3*a^2*x^2)/b^5 - (a*x^3)/b^4 + x^4/(4*b^3) - a^6/(2*b^7*(a + b*x)^2) + (6*a^5)/(b^7*(a + b*x)) + (15*a^4*Log[a + b*x])/b^7}
{x^5/(a + b*x)^3, x, 2, (6*a^2*x)/b^5 - (3*a*x^2)/(2*b^4) + x^3/(3*b^3) + a^5/(2*b^6*(a + b*x)^2) - (5*a^4)/(b^6*(a + b*x)) - (10*a^3*Log[a + b*x])/b^6}
{x^4/(a + b*x)^3, x, 2, -((3*a*x)/b^4) + x^2/(2*b^3) - a^4/(2*b^5*(a + b*x)^2) + (4*a^3)/(b^5*(a + b*x)) + (6*a^2*Log[a + b*x])/b^5}
{x^3/(a + b*x)^3, x, 2, x/b^3 + a^3/(2*b^4*(a + b*x)^2) - (3*a^2)/(b^4*(a + b*x)) - (3*a*Log[a + b*x])/b^4}
{x^2/(a + b*x)^3, x, 2, -(a^2/(2*b^3*(a + b*x)^2)) + (2*a)/(b^3*(a + b*x)) + Log[a + b*x]/b^3}
{x^1/(a + b*x)^3, x, 1, x^2/(2*a*(a + b*x)^2)}
{x^0/(a + b*x)^3, x, 1, -1/(2*b*(a + b*x)^2)}
{1/(x^1*(a + b*x)^3), x, 2, 1/(2*a*(a + b*x)^2) + 1/(a^2*(a + b*x)) + Log[x]/a^3 - Log[a + b*x]/a^3}
{1/(x^2*(a + b*x)^3), x, 2, -(1/(a^3*x)) - b/(2*a^2*(a + b*x)^2) - (2*b)/(a^3*(a + b*x)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x])/a^4}
{1/(x^3*(a + b*x)^3), x, 2, -(1/(2*a^3*x^2)) + (3*b)/(a^4*x) + b^2/(2*a^3*(a + b*x)^2) + (3*b^2)/(a^4*(a + b*x)) + (6*b^2*Log[x])/a^5 - (6*b^2*Log[a + b*x])/a^5}
{1/(x^4*(a + b*x)^3), x, 2, -(1/(3*a^3*x^3)) + (3*b)/(2*a^4*x^2) - (6*b^2)/(a^5*x) - b^3/(2*a^4*(a + b*x)^2) - (4*b^3)/(a^5*(a + b*x)) - (10*b^3*Log[x])/a^6 + (10*b^3*Log[a + b*x])/a^6}
{1/(x^5*(a + b*x)^3), x, 2, -(1/(4*a^3*x^4)) + b/(a^4*x^3) - (3*b^2)/(a^5*x^2) + (10*b^3)/(a^6*x) + b^4/(2*a^5*(a + b*x)^2) + (5*b^4)/(a^6*(a + b*x)) + (15*b^4*Log[x])/a^7 - (15*b^4*Log[a + b*x])/a^7}


{x^8/(a + b*x)^4, x, 2, (35*a^4*x)/b^8 - (10*a^3*x^2)/b^7 + (10*a^2*x^3)/(3*b^6) - (a*x^4)/b^5 + x^5/(5*b^4) - a^8/(3*b^9*(a + b*x)^3) + (4*a^7)/(b^9*(a + b*x)^2) - (28*a^6)/(b^9*(a + b*x)) - (56*a^5*Log[a + b*x])/b^9}
{x^7/(a + b*x)^4, x, 2, -((20*a^3*x)/b^7) + (5*a^2*x^2)/b^6 - (4*a*x^3)/(3*b^5) + x^4/(4*b^4) + a^7/(3*b^8*(a + b*x)^3) - (7*a^6)/(2*b^8*(a + b*x)^2) + (21*a^5)/(b^8*(a + b*x)) + (35*a^4*Log[a + b*x])/b^8}
{x^6/(a + b*x)^4, x, 2, (10*a^2*x)/b^6 - (2*a*x^2)/b^5 + x^3/(3*b^4) - a^6/(3*b^7*(a + b*x)^3) + (3*a^5)/(b^7*(a + b*x)^2) - (15*a^4)/(b^7*(a + b*x)) - (20*a^3*Log[a + b*x])/b^7}
{x^5/(a + b*x)^4, x, 2, -((4*a*x)/b^5) + x^2/(2*b^4) + a^5/(3*b^6*(a + b*x)^3) - (5*a^4)/(2*b^6*(a + b*x)^2) + (10*a^3)/(b^6*(a + b*x)) + (10*a^2*Log[a + b*x])/b^6}
{x^4/(a + b*x)^4, x, 2, x/b^4 - a^4/(3*b^5*(a + b*x)^3) + (2*a^3)/(b^5*(a + b*x)^2) - (6*a^2)/(b^5*(a + b*x)) - (4*a*Log[a + b*x])/b^5}
{x^3/(a + b*x)^4, x, 2, a^3/(3*b^4*(a + b*x)^3) - (3*a^2)/(2*b^4*(a + b*x)^2) + (3*a)/(b^4*(a + b*x)) + Log[a + b*x]/b^4}
{x^2/(a + b*x)^4, x, 1, x^3/(3*a*(a + b*x)^3)}
{x^1/(a + b*x)^4, x, 2, a/(3*b^2*(a + b*x)^3) - 1/(2*b^2*(a + b*x)^2)}
{x^0/(a + b*x)^4, x, 1, -(1/(3*b*(a + b*x)^3))}
{1/(x^1*(a + b*x)^4), x, 2, 1/(3*a*(a + b*x)^3) + 1/(2*a^2*(a + b*x)^2) + 1/(a^3*(a + b*x)) + Log[x]/a^4 - Log[a + b*x]/a^4}
{1/(x^2*(a + b*x)^4), x, 2, -(1/(a^4*x)) - b/(3*a^2*(a + b*x)^3) - b/(a^3*(a + b*x)^2) - (3*b)/(a^4*(a + b*x)) - (4*b*Log[x])/a^5 + (4*b*Log[a + b*x])/a^5}
{1/(x^3*(a + b*x)^4), x, 2, -(1/(2*a^4*x^2)) + (4*b)/(a^5*x) + b^2/(3*a^3*(a + b*x)^3) + (3*b^2)/(2*a^4*(a + b*x)^2) + (6*b^2)/(a^5*(a + b*x)) + (10*b^2*Log[x])/a^6 - (10*b^2*Log[a + b*x])/a^6}
{1/(x^4*(a + b*x)^4), x, 2, -(1/(3*a^4*x^3)) + (2*b)/(a^5*x^2) - (10*b^2)/(a^6*x) - b^3/(3*a^4*(a + b*x)^3) - (2*b^3)/(a^5*(a + b*x)^2) - (10*b^3)/(a^6*(a + b*x)) - (20*b^3*Log[x])/a^7 + (20*b^3*Log[a + b*x])/a^7}
{1/(x^5*(a + b*x)^4), x, 2, -(1/(4*a^4*x^4)) + (4*b)/(3*a^5*x^3) - (5*b^2)/(a^6*x^2) + (20*b^3)/(a^7*x) + b^4/(3*a^5*(a + b*x)^3) + (5*b^4)/(2*a^6*(a + b*x)^2) + (15*b^4)/(a^7*(a + b*x)) + (35*b^4*Log[x])/a^8 - (35*b^4*Log[a + b*x])/a^8}


{x^10/(a + b*x)^7, x, 2, -((84*a^3*x)/b^10) + (14*a^2*x^2)/b^9 - (7*a*x^3)/(3*b^8) + x^4/(4*b^7) - a^10/(6*b^11*(a + b*x)^6) + (2*a^9)/(b^11*(a + b*x)^5) - (45*a^8)/(4*b^11*(a + b*x)^4) + (40*a^7)/(b^11*(a + b*x)^3) - (105*a^6)/(b^11*(a + b*x)^2) + (252*a^5)/(b^11*(a + b*x)) + (210*a^4*Log[a + b*x])/b^11}
{x^9/(a + b*x)^7, x, 2, (28*a^2*x)/b^9 - (7*a*x^2)/(2*b^8) + x^3/(3*b^7) + a^9/(6*b^10*(a + b*x)^6) - (9*a^8)/(5*b^10*(a + b*x)^5) + (9*a^7)/(b^10*(a + b*x)^4) - (28*a^6)/(b^10*(a + b*x)^3) + (63*a^5)/(b^10*(a + b*x)^2) - (126*a^4)/(b^10*(a + b*x)) - (84*a^3*Log[a + b*x])/b^10}
{x^8/(a + b*x)^7, x, 2, -((7*a*x)/b^8) + x^2/(2*b^7) - a^8/(6*b^9*(a + b*x)^6) + (8*a^7)/(5*b^9*(a + b*x)^5) - (7*a^6)/(b^9*(a + b*x)^4) + (56*a^5)/(3*b^9*(a + b*x)^3) - (35*a^4)/(b^9*(a + b*x)^2) + (56*a^3)/(b^9*(a + b*x)) + (28*a^2*Log[a + b*x])/b^9}
{x^7/(a + b*x)^7, x, 2, x/b^7 + a^7/(6*b^8*(a + b*x)^6) - (7*a^6)/(5*b^8*(a + b*x)^5) + (21*a^5)/(4*b^8*(a + b*x)^4) - (35*a^4)/(3*b^8*(a + b*x)^3) + (35*a^3)/(2*b^8*(a + b*x)^2) - (21*a^2)/(b^8*(a + b*x)) - (7*a*Log[a + b*x])/b^8}
{x^6/(a + b*x)^7, x, 2, -(a^6/(6*b^7*(a + b*x)^6)) + (6*a^5)/(5*b^7*(a + b*x)^5) - (15*a^4)/(4*b^7*(a + b*x)^4) + (20*a^3)/(3*b^7*(a + b*x)^3) - (15*a^2)/(2*b^7*(a + b*x)^2) + (6*a)/(b^7*(a + b*x)) + Log[a + b*x]/b^7}
{x^5/(a + b*x)^7, x, 1, x^6/(6*a*(a + b*x)^6)}
{x^4/(a + b*x)^7, x, 2, x^5/(6*a*(a + b*x)^6) + x^5/(30*a^2*(a + b*x)^5)}
{x^3/(a + b*x)^7, x, 2, x^4/(6*a*(a + b*x)^6) + x^4/(15*a^2*(a + b*x)^5) + x^4/(60*a^3*(a + b*x)^4), a^3/(6*b^4*(a + b*x)^6) - (3*a^2)/(5*b^4*(a + b*x)^5) + (3*a)/(4*b^4*(a + b*x)^4) - 1/(3*b^4*(a + b*x)^3)}
{x^2/(a + b*x)^7, x, 2, -(a^2/(6*b^3*(a + b*x)^6)) + (2*a)/(5*b^3*(a + b*x)^5) - 1/(4*b^3*(a + b*x)^4)}
{x^1/(a + b*x)^7, x, 2, a/(6*b^2*(a + b*x)^6) - 1/(5*b^2*(a + b*x)^5)}
{x^0/(a + b*x)^7, x, 1, -1/(6*b*(a + b*x)^6)}
{1/(x^1*(a + b*x)^7), x, 2, 1/(6*a*(a + b*x)^6) + 1/(5*a^2*(a + b*x)^5) + 1/(4*a^3*(a + b*x)^4) + 1/(3*a^4*(a + b*x)^3) + 1/(2*a^5*(a + b*x)^2) + 1/(a^6*(a + b*x)) + Log[x]/a^7 - Log[a + b*x]/a^7}
{1/(x^2*(a + b*x)^7), x, 2, -(1/(a^7*x)) - b/(6*a^2*(a + b*x)^6) - (2*b)/(5*a^3*(a + b*x)^5) - (3*b)/(4*a^4*(a + b*x)^4) - (4*b)/(3*a^5*(a + b*x)^3) - (5*b)/(2*a^6*(a + b*x)^2) - (6*b)/(a^7*(a + b*x)) - (7*b*Log[x])/a^8 + (7*b*Log[a + b*x])/a^8}
{1/(x^3*(a + b*x)^7), x, 2, -(1/(2*a^7*x^2)) + (7*b)/(a^8*x) + b^2/(6*a^3*(a + b*x)^6) + (3*b^2)/(5*a^4*(a + b*x)^5) + (3*b^2)/(2*a^5*(a + b*x)^4) + (10*b^2)/(3*a^6*(a + b*x)^3) + (15*b^2)/(2*a^7*(a + b*x)^2) + (21*b^2)/(a^8*(a + b*x)) + (28*b^2*Log[x])/a^9 - (28*b^2*Log[a + b*x])/a^9}
{1/(x^4*(a + b*x)^7), x, 2, -(1/(3*a^7*x^3)) + (7*b)/(2*a^8*x^2) - (28*b^2)/(a^9*x) - b^3/(6*a^4*(a + b*x)^6) - (4*b^3)/(5*a^5*(a + b*x)^5) - (5*b^3)/(2*a^6*(a + b*x)^4) - (20*b^3)/(3*a^7*(a + b*x)^3) - (35*b^3)/(2*a^8*(a + b*x)^2) - (56*b^3)/(a^9*(a + b*x)) - (84*b^3*Log[x])/a^10 + (84*b^3*Log[a + b*x])/a^10}


{x^12/(a + b*x)^10, x, 2, (55*a^2*x)/b^12 - (5*a*x^2)/b^11 + x^3/(3*b^10) - a^12/(9*b^13*(a + b*x)^9) + (3*a^11)/(2*b^13*(a + b*x)^8) - (66*a^10)/(7*b^13*(a + b*x)^7) + (110*a^9)/(3*b^13*(a + b*x)^6) - (99*a^8)/(b^13*(a + b*x)^5) + (198*a^7)/(b^13*(a + b*x)^4) - (308*a^6)/(b^13*(a + b*x)^3) + (396*a^5)/(b^13*(a + b*x)^2) - (495*a^4)/(b^13*(a + b*x)) - (220*a^3*Log[a + b*x])/b^13}
{x^11/(a + b*x)^10, x, 2, -((10*a*x)/b^11) + x^2/(2*b^10) + a^11/(9*b^12*(a + b*x)^9) - (11*a^10)/(8*b^12*(a + b*x)^8) + (55*a^9)/(7*b^12*(a + b*x)^7) - (55*a^8)/(2*b^12*(a + b*x)^6) + (66*a^7)/(b^12*(a + b*x)^5) - (231*a^6)/(2*b^12*(a + b*x)^4) + (154*a^5)/(b^12*(a + b*x)^3) - (165*a^4)/(b^12*(a + b*x)^2) + (165*a^3)/(b^12*(a + b*x)) + (55*a^2*Log[a + b*x])/b^12}
{x^10/(a + b*x)^10, x, 2, x/b^10 - a^10/(9*b^11*(a + b*x)^9) + (5*a^9)/(4*b^11*(a + b*x)^8) - (45*a^8)/(7*b^11*(a + b*x)^7) + (20*a^7)/(b^11*(a + b*x)^6) - (42*a^6)/(b^11*(a + b*x)^5) + (63*a^5)/(b^11*(a + b*x)^4) - (70*a^4)/(b^11*(a + b*x)^3) + (60*a^3)/(b^11*(a + b*x)^2) - (45*a^2)/(b^11*(a + b*x)) - (10*a*Log[a + b*x])/b^11}
{x^9/(a + b*x)^10, x, 2, a^9/(9*b^10*(a + b*x)^9) - (9*a^8)/(8*b^10*(a + b*x)^8) + (36*a^7)/(7*b^10*(a + b*x)^7) - (14*a^6)/(b^10*(a + b*x)^6) + (126*a^5)/(5*b^10*(a + b*x)^5) - (63*a^4)/(2*b^10*(a + b*x)^4) + (28*a^3)/(b^10*(a + b*x)^3) - (18*a^2)/(b^10*(a + b*x)^2) + (9*a)/(b^10*(a + b*x)) + Log[a + b*x]/b^10}
{x^8/(a + b*x)^10, x, 1, x^9/(9*a*(a + b*x)^9)}
{x^7/(a + b*x)^10, x, 2, x^8/(9*a*(a + b*x)^9) + x^8/(72*a^2*(a + b*x)^8)}
{x^6/(a + b*x)^10, x, 3, x^7/(9*a*(a + b*x)^9) + x^7/(36*a^2*(a + b*x)^8) + x^7/(252*a^3*(a + b*x)^7)}
{x^5/(a + b*x)^10, x, 4, x^6/(9*a*(a + b*x)^9) + x^6/(24*a^2*(a + b*x)^8) + x^6/(84*a^3*(a + b*x)^7) + x^6/(504*a^4*(a + b*x)^6)}
{x^4/(a + b*x)^10, x, 2, -(a^4/(9*b^5*(a + b*x)^9)) + a^3/(2*b^5*(a + b*x)^8) - (6*a^2)/(7*b^5*(a + b*x)^7) + (2*a)/(3*b^5*(a + b*x)^6) - 1/(5*b^5*(a + b*x)^5)}
{x^3/(a + b*x)^10, x, 2, a^3/(9*b^4*(a + b*x)^9) - (3*a^2)/(8*b^4*(a + b*x)^8) + (3*a)/(7*b^4*(a + b*x)^7) - 1/(6*b^4*(a + b*x)^6)}
{x^2/(a + b*x)^10, x, 2, -(a^2/(9*b^3*(a + b*x)^9)) + a/(4*b^3*(a + b*x)^8) - 1/(7*b^3*(a + b*x)^7)}
{x^1/(a + b*x)^10, x, 2, a/(9*b^2*(a + b*x)^9) - 1/(8*b^2*(a + b*x)^8)}
{x^0/(a + b*x)^10, x, 1, -(1/(9*b*(a + b*x)^9))}
{1/(x^1*(a + b*x)^10), x, 2, 1/(9*a*(a + b*x)^9) + 1/(8*a^2*(a + b*x)^8) + 1/(7*a^3*(a + b*x)^7) + 1/(6*a^4*(a + b*x)^6) + 1/(5*a^5*(a + b*x)^5) + 1/(4*a^6*(a + b*x)^4) + 1/(3*a^7*(a + b*x)^3) + 1/(2*a^8*(a + b*x)^2) + 1/(a^9*(a + b*x)) + Log[x]/a^10 - Log[a + b*x]/a^10}
{1/(x^2*(a + b*x)^10), x, 2, -(1/(a^10*x)) - b/(9*a^2*(a + b*x)^9) - b/(4*a^3*(a + b*x)^8) - (3*b)/(7*a^4*(a + b*x)^7) - (2*b)/(3*a^5*(a + b*x)^6) - b/(a^6*(a + b*x)^5) - (3*b)/(2*a^7*(a + b*x)^4) - (7*b)/(3*a^8*(a + b*x)^3) - (4*b)/(a^9*(a + b*x)^2) - (9*b)/(a^10*(a + b*x)) - (10*b*Log[x])/a^11 + (10*b*Log[a + b*x])/a^11}
{1/(x^3*(a + b*x)^10), x, 2, -(1/(2*a^10*x^2)) + (10*b)/(a^11*x) + b^2/(9*a^3*(a + b*x)^9) + (3*b^2)/(8*a^4*(a + b*x)^8) + (6*b^2)/(7*a^5*(a + b*x)^7) + (5*b^2)/(3*a^6*(a + b*x)^6) + (3*b^2)/(a^7*(a + b*x)^5) + (21*b^2)/(4*a^8*(a + b*x)^4) + (28*b^2)/(3*a^9*(a + b*x)^3) + (18*b^2)/(a^10*(a + b*x)^2) + (45*b^2)/(a^11*(a + b*x)) + (55*b^2*Log[x])/a^12 - (55*b^2*Log[a + b*x])/a^12}
{1/(x^4*(a + b*x)^10), x, 2, -(1/(3*a^10*x^3)) + (5*b)/(a^11*x^2) - (55*b^2)/(a^12*x) - b^3/(9*a^4*(a + b*x)^9) - b^3/(2*a^5*(a + b*x)^8) - (10*b^3)/(7*a^6*(a + b*x)^7) - (10*b^3)/(3*a^7*(a + b*x)^6) - (7*b^3)/(a^8*(a + b*x)^5) - (14*b^3)/(a^9*(a + b*x)^4) - (28*b^3)/(a^10*(a + b*x)^3) - (60*b^3)/(a^11*(a + b*x)^2) - (165*b^3)/(a^12*(a + b*x)) - (220*b^3*Log[x])/a^13 + (220*b^3*Log[a + b*x])/a^13}


{(a + b*x)^12/x^10, x, 2, -(a^12/(9*x^9)) - (3*a^11*b)/(2*x^8) - (66*a^10*b^2)/(7*x^7) - (110*a^9*b^3)/(3*x^6) - (99*a^8*b^4)/x^5 - (198*a^7*b^5)/x^4 - (308*a^6*b^6)/x^3 - (396*a^5*b^7)/x^2 - (495*a^4*b^8)/x + 66*a^2*b^10*x + 6*a*b^11*x^2 + (b^12*x^3)/3 + 220*a^3*b^9*Log[x]}
{(a + b*x)^11/x^10, x, 2, -(a^11/(9*x^9)) - (11*a^10*b)/(8*x^8) - (55*a^9*b^2)/(7*x^7) - (55*a^8*b^3)/(2*x^6) - (66*a^7*b^4)/x^5 - (231*a^6*b^5)/(2*x^4) - (154*a^5*b^6)/x^3 - (165*a^4*b^7)/x^2 - (165*a^3*b^8)/x + 11*a*b^10*x + (b^11*x^2)/2 + 55*a^2*b^9*Log[x]}
{(a + b*x)^10/x^10, x, 2, -(a^10/(9*x^9)) - (5*a^9*b)/(4*x^8) - (45*a^8*b^2)/(7*x^7) - (20*a^7*b^3)/x^6 - (42*a^6*b^4)/x^5 - (63*a^5*b^5)/x^4 - (70*a^4*b^6)/x^3 - (60*a^3*b^7)/x^2 - (45*a^2*b^8)/x + b^10*x + 10*a*b^9*Log[x]}
{(a + b*x)^9/x^10, x, 2, -(a^9/(9*x^9)) - (9*a^8*b)/(8*x^8) - (36*a^7*b^2)/(7*x^7) - (14*a^6*b^3)/x^6 - (126*a^5*b^4)/(5*x^5) - (63*a^4*b^5)/(2*x^4) - (28*a^3*b^6)/x^3 - (18*a^2*b^7)/x^2 - (9*a*b^8)/x + b^9*Log[x]}
{(a + b*x)^8/x^10, x, 1, -((a + b*x)^9/(9*a*x^9))}
{(a + b*x)^7/x^10, x, 2, -((a + b*x)^8/(9*a*x^9)) + (b*(a + b*x)^8)/(72*a^2*x^8)}
{(a + b*x)^6/x^10, x, 3, -((a + b*x)^7/(9*a*x^9)) + (b*(a + b*x)^7)/(36*a^2*x^8) - (b^2*(a + b*x)^7)/(252*a^3*x^7)}
{(a + b*x)^5/x^10, x, 2, -(a^5/(9*x^9)) - (5*a^4*b)/(8*x^8) - (10*a^3*b^2)/(7*x^7) - (5*a^2*b^3)/(3*x^6) - (a*b^4)/x^5 - b^5/(4*x^4)}
{(a + b*x)^4/x^10, x, 2, -(a^4/(9*x^9)) - (a^3*b)/(2*x^8) - (6*a^2*b^2)/(7*x^7) - (2*a*b^3)/(3*x^6) - b^4/(5*x^5)}
{(a + b*x)^3/x^10, x, 2, -(a^3/(9*x^9)) - (3*a^2*b)/(8*x^8) - (3*a*b^2)/(7*x^7) - b^3/(6*x^6)}
{(a + b*x)^2/x^10, x, 2, -(a^2/(9*x^9)) - (a*b)/(4*x^8) - b^2/(7*x^7)}
{(a + b*x)^1/x^10, x, 2, -(a/(9*x^9)) - b/(8*x^8)}
{(a + b*x)^0/x^10, x, 1, -(1/(9*x^9))}
{1/((a + b*x)^1*x^10), x, 2, -(1/(9*a*x^9)) + b/(8*a^2*x^8) - b^2/(7*a^3*x^7) + b^3/(6*a^4*x^6) - b^4/(5*a^5*x^5) + b^5/(4*a^6*x^4) - b^6/(3*a^7*x^3) + b^7/(2*a^8*x^2) - b^8/(a^9*x) - (b^9*Log[x])/a^10 + (b^9*Log[a + b*x])/a^10}
{1/((a + b*x)^2*x^10), x, 2, -(1/(9*a^2*x^9)) + b/(4*a^3*x^8) - (3*b^2)/(7*a^4*x^7) + (2*b^3)/(3*a^5*x^6) - b^4/(a^6*x^5) + (3*b^5)/(2*a^7*x^4) - (7*b^6)/(3*a^8*x^3) + (4*b^7)/(a^9*x^2) - (9*b^8)/(a^10*x) - b^9/(a^10*(a + b*x)) - (10*b^9*Log[x])/a^11 + (10*b^9*Log[a + b*x])/a^11}
{1/((a + b*x)^3*x^10), x, 2, -(1/(9*a^3*x^9)) + (3*b)/(8*a^4*x^8) - (6*b^2)/(7*a^5*x^7) + (5*b^3)/(3*a^6*x^6) - (3*b^4)/(a^7*x^5) + (21*b^5)/(4*a^8*x^4) - (28*b^6)/(3*a^9*x^3) + (18*b^7)/(a^10*x^2) - (45*b^8)/(a^11*x) - b^9/(2*a^10*(a + b*x)^2) - (10*b^9)/(a^11*(a + b*x)) - (55*b^9*Log[x])/a^12 + (55*b^9*Log[a + b*x])/a^12}


{1/(x^1*(2 + 3*x)), x, 2, Log[x]/2 - (1/2)*Log[2 + 3*x]}
{1/(x^1*(4 + 6*x)), x, 2, Log[x]/4 - (1/4)*Log[2 + 3*x]}
{1/(x^2*(4 + 6*x)), x, 2, -(1/(4*x)) - (3*Log[x])/8 + (3/8)*Log[2 + 3*x]}
{1/(x^3*(4 + 6*x)), x, 2, -(1/(8*x^2)) + 3/(8*x) + (9*Log[x])/16 - (9/16)*Log[2 + 3*x]}
{1/(x^4*(4 + 6*x)), x, 2, -(1/(12*x^3)) + 3/(16*x^2) - 9/(16*x) - (27*Log[x])/32 + (27/32)*Log[2 + 3*x]}
{1/(x^5*(4 + 6*x)), x, 2, -(1/(16*x^4)) + 1/(8*x^3) - 9/(32*x^2) + 27/(32*x) + (81*Log[x])/64 - (81/64)*Log[2 + 3*x]}


{1/(x^1*(4 + 6*x)^2), x, 2, 1/(8*(2 + 3*x)) + Log[x]/16 - (1/16)*Log[2 + 3*x]}
{1/(x^2*(4 + 6*x)^2), x, 2, -(1/(16*x)) - 3/(16*(2 + 3*x)) - (3*Log[x])/16 + (3/16)*Log[2 + 3*x]}
{1/(x^3*(4 + 6*x)^2), x, 2, -(1/(32*x^2)) + 3/(16*x) + 9/(32*(2 + 3*x)) + (27*Log[x])/64 - (27/64)*Log[2 + 3*x]}
{1/(x^4*(4 + 6*x)^2), x, 2, -(1/(48*x^3)) + 3/(32*x^2) - 27/(64*x) - 27/(64*(2 + 3*x)) - (27*Log[x])/32 + (27/32)*Log[2 + 3*x]}
{1/(x^5*(4 + 6*x)^2), x, 2, -(1/(64*x^4)) + 1/(16*x^3) - 27/(128*x^2) + 27/(32*x) + 81/(128*(2 + 3*x)) + (405*Log[x])/256 - (405/256)*Log[2 + 3*x]}


{1/(x^1*(4 + 6*x)^3), x, 2, 1/(32*(2 + 3*x)^2) + 1/(32*(2 + 3*x)) + Log[x]/64 - (1/64)*Log[2 + 3*x]}
{1/(x^2*(4 + 6*x)^3), x, 2, -(1/(64*x)) - 3/(64*(2 + 3*x)^2) - 3/(32*(2 + 3*x)) - (9*Log[x])/128 + (9/128)*Log[2 + 3*x]}
{1/(x^3*(4 + 6*x)^3), x, 2, -(1/(128*x^2)) + 9/(128*x) + 9/(128*(2 + 3*x)^2) + 27/(128*(2 + 3*x)) + (27*Log[x])/128 - (27/128)*Log[2 + 3*x]}
{1/(x^4*(4 + 6*x)^3), x, 2, -(1/(192*x^3)) + 9/(256*x^2) - 27/(128*x) - 27/(256*(2 + 3*x)^2) - 27/(64*(2 + 3*x)) - (135*Log[x])/256 + (135/256)*Log[2 + 3*x]}
{1/(x^5*(4 + 6*x)^3), x, 2, -(1/(256*x^4)) + 3/(128*x^3) - 27/(256*x^2) + 135/(256*x) + 81/(512*(2 + 3*x)^2) + 405/(512*(2 + 3*x)) + (1215*Log[x])/1024 - (1215*Log[2 + 3*x])/1024}


(* Factor content out of denominator before including in Log? *)
{1/(2 + 2*x), x, 1, (1/2)*Log[1 + x]}
{1/(4 - 6*x), x, 1, (-(1/6))*Log[2 - 3*x]}
{1/(a + Sqrt[a]*x), x, 1, Log[Sqrt[a] + x]/Sqrt[a]}
{1/(a + Sqrt[-a]*x), x, 1, Log[Sqrt[-a] - x]/Sqrt[-a]}
{1/(a^2 + Sqrt[-a]*x), x, 1, Log[(-a)^(3/2) + x]/Sqrt[-a]}
{1/(a^3 + Sqrt[-a]*x), x, 1, Log[(-a)^(5/2) - x]/Sqrt[-a]}
{1/(1/a + Sqrt[-a]*x), x, 1, Log[1 - (-a)^(3/2)*x]/Sqrt[-a]}
{1/(1/a^2 + Sqrt[-a]*x), x, 1, Log[1 + (-a)^(5/2)*x]/Sqrt[-a]}

(* Integrands of the form 1/(x^m*(a+b*x)) where m>0 is an integer and a^2=1 *)
{1/(x*(1 + b*x)), x, 2, Log[x] - Log[1 + b*x]}
{1/(x*(-1 + b*x)), x, 2, -Log[x] + Log[1 - b*x]}
{1/(x^2*(1 + b*x)), x, 2, -(1/x) - b*Log[x] + b*Log[1 + b*x]}
{1/(x^2*(-1 + b*x)), x, 2, 1/x - b*Log[x] + b*Log[1 - b*x]}

(* The b*Log[x] terms cannot cancel if ArcTanh[1+2*b*x] is returned instead of Logs! *)
{b/x + 1/(x^2*(1 + b*x)), x, 3, -(1/x) + b*Log[1 + b*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x)^(n/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^m*Sqrt[a + b*x], x, 2, (2*x^(1 + m)*Sqrt[a + b*x])/(3 + 2*m) + (2*a*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b*(3 + 2*m)))}

{x^3*Sqrt[a + b*x], x, 2, -((2*a^3*(a + b*x)^(3/2))/(3*b^4)) + (6*a^2*(a + b*x)^(5/2))/(5*b^4) - (6*a*(a + b*x)^(7/2))/(7*b^4) + (2*(a + b*x)^(9/2))/(9*b^4)}
{x^2*Sqrt[a + b*x], x, 2, (2*a^2*(a + b*x)^(3/2))/(3*b^3) - (4*a*(a + b*x)^(5/2))/(5*b^3) + (2*(a + b*x)^(7/2))/(7*b^3)}
{x^1*Sqrt[a + b*x], x, 2, -((2*a*(a + b*x)^(3/2))/(3*b^2)) + (2*(a + b*x)^(5/2))/(5*b^2)}
{x^0*Sqrt[a + b*x], x, 1, (2*(a + b*x)^(3/2))/(3*b)}
{Sqrt[a + b*x]/x^1, x, 2, 2*Sqrt[a + b*x] - 2*Sqrt[a]*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{Sqrt[a + b*x]/x^2, x, 2, -(Sqrt[a + b*x]/x) - (b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/Sqrt[a]}
{Sqrt[a + b*x]/x^3, x, 3, -(Sqrt[a + b*x]/(2*x^2)) - (b*Sqrt[a + b*x])/(4*a*x) + (b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(4*a^(3/2))}
{Sqrt[a + b*x]/x^4, x, 4, -(Sqrt[a + b*x]/(3*x^3)) - (b*Sqrt[a + b*x])/(12*a*x^2) + (b^2*Sqrt[a + b*x])/(8*a^2*x) - (b^3*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(8*a^(5/2))}


{x^m*(a + b*x)^(3/2), x, 3, (6*a*x^(1 + m)*Sqrt[a + b*x])/(15 + 16*m + 4*m^2) + (2*x^(1 + m)*(a + b*x)^(3/2))/(5 + 2*m) + (6*a^2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b*(15 + 16*m + 4*m^2)))}

{x^3*(a + b*x)^(3/2), x, 2, -((2*a^3*(a + b*x)^(5/2))/(5*b^4)) + (6*a^2*(a + b*x)^(7/2))/(7*b^4) - (2*a*(a + b*x)^(9/2))/(3*b^4) + (2*(a + b*x)^(11/2))/(11*b^4)}
{x^2*(a + b*x)^(3/2), x, 2, (2*a^2*(a + b*x)^(5/2))/(5*b^3) - (4*a*(a + b*x)^(7/2))/(7*b^3) + (2*(a + b*x)^(9/2))/(9*b^3)}
{x^1*(a + b*x)^(3/2), x, 2, -((2*a*(a + b*x)^(5/2))/(5*b^2)) + (2*(a + b*x)^(7/2))/(7*b^2)}
{x^0*(a + b*x)^(3/2), x, 1, (2*(a + b*x)^(5/2))/(5*b)}
{(a + b*x)^(3/2)/x^1, x, 3, 2*a*Sqrt[a + b*x] + (2/3)*(a + b*x)^(3/2) - 2*a^(3/2)*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(3/2)/x^2, x, 3, 3*b*Sqrt[a + b*x] - (a + b*x)^(3/2)/x - 3*Sqrt[a]*b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(3/2)/x^3, x, 3, -((3*b*Sqrt[a + b*x])/(4*x)) - (a + b*x)^(3/2)/(2*x^2) - (3*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(4*Sqrt[a])}
{(a + b*x)^(3/2)/x^4, x, 4, -((b*Sqrt[a + b*x])/(4*x^2)) - (b^2*Sqrt[a + b*x])/(8*a*x) - (a + b*x)^(3/2)/(3*x^3) + (b^3*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(8*a^(3/2))}


{x^m*(a + b*x)^(5/2), x, 4, (30*a^2*x^(1 + m)*Sqrt[a + b*x])/((7 + 2*m)*(15 + 16*m + 4*m^2)) + (10*a*x^(1 + m)*(a + b*x)^(3/2))/(35 + 24*m + 4*m^2) + (2*x^(1 + m)*(a + b*x)^(5/2))/(7 + 2*m) + (30*a^3*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b*(7 + 2*m)*(15 + 16*m + 4*m^2)))}

{x^3*(a + b*x)^(5/2), x, 2, -((2*a^3*(a + b*x)^(7/2))/(7*b^4)) + (2*a^2*(a + b*x)^(9/2))/(3*b^4) - (6*a*(a + b*x)^(11/2))/(11*b^4) + (2*(a + b*x)^(13/2))/(13*b^4)}
{x^2*(a + b*x)^(5/2), x, 2, (2*a^2*(a + b*x)^(7/2))/(7*b^3) - (4*a*(a + b*x)^(9/2))/(9*b^3) + (2*(a + b*x)^(11/2))/(11*b^3)}
{x^1*(a + b*x)^(5/2), x, 2, -((2*a*(a + b*x)^(7/2))/(7*b^2)) + (2*(a + b*x)^(9/2))/(9*b^2)}
{x^0*(a + b*x)^(5/2), x, 1, (2*(a + b*x)^(7/2))/(7*b)}
{(a + b*x)^(5/2)/x^1, x, 4, 2*a^2*Sqrt[a + b*x] + (2/3)*a*(a + b*x)^(3/2) + (2/5)*(a + b*x)^(5/2) - 2*a^(5/2)*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(5/2)/x^2, x, 4, 5*a*b*Sqrt[a + b*x] + (5/3)*b*(a + b*x)^(3/2) - (a + b*x)^(5/2)/x - 5*a^(3/2)*b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(5/2)/x^3, x, 4, (15/4)*b^2*Sqrt[a + b*x] - (5*b*(a + b*x)^(3/2))/(4*x) - (a + b*x)^(5/2)/(2*x^2) - (15/4)*Sqrt[a]*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(5/2)/x^4, x, 4, -((5*b^2*Sqrt[a + b*x])/(8*x)) - (5*b*(a + b*x)^(3/2))/(12*x^2) - (a + b*x)^(5/2)/(3*x^3) - (5*b^3*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(8*Sqrt[a])}
{(a + b*x)^(5/2)/x^5, x, 5, -((5*b^2*Sqrt[a + b*x])/(32*x^2)) - (5*b^3*Sqrt[a + b*x])/(64*a*x) - (5*b*(a + b*x)^(3/2))/(24*x^3) - (a + b*x)^(5/2)/(4*x^4) + (5*b^4*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(64*a^(3/2))}


{x^7*(a + b*x)^(9/2), x, 2, -((2*a^7*(a + b*x)^(11/2))/(11*b^8)) + (14*a^6*(a + b*x)^(13/2))/(13*b^8) - (14*a^5*(a + b*x)^(15/2))/(5*b^8) + (70*a^4*(a + b*x)^(17/2))/(17*b^8) - (70*a^3*(a + b*x)^(19/2))/(19*b^8) + (2*a^2*(a + b*x)^(21/2))/b^8 - (14*a*(a + b*x)^(23/2))/(23*b^8) + (2*(a + b*x)^(25/2))/(25*b^8)}
{x^6*(a + b*x)^(9/2), x, 2, (2*a^6*(a + b*x)^(11/2))/(11*b^7) - (12*a^5*(a + b*x)^(13/2))/(13*b^7) + (2*a^4*(a + b*x)^(15/2))/b^7 - (40*a^3*(a + b*x)^(17/2))/(17*b^7) + (30*a^2*(a + b*x)^(19/2))/(19*b^7) - (4*a*(a + b*x)^(21/2))/(7*b^7) + (2*(a + b*x)^(23/2))/(23*b^7)}
{x^5*(a + b*x)^(9/2), x, 2, -((2*a^5*(a + b*x)^(11/2))/(11*b^6)) + (10*a^4*(a + b*x)^(13/2))/(13*b^6) - (4*a^3*(a + b*x)^(15/2))/(3*b^6) + (20*a^2*(a + b*x)^(17/2))/(17*b^6) - (10*a*(a + b*x)^(19/2))/(19*b^6) + (2*(a + b*x)^(21/2))/(21*b^6)}
{x^4*(a + b*x)^(9/2), x, 2, (2*a^4*(a + b*x)^(11/2))/(11*b^5) - (8*a^3*(a + b*x)^(13/2))/(13*b^5) + (4*a^2*(a + b*x)^(15/2))/(5*b^5) - (8*a*(a + b*x)^(17/2))/(17*b^5) + (2*(a + b*x)^(19/2))/(19*b^5)}
{x^3*(a + b*x)^(9/2), x, 2, -((2*a^3*(a + b*x)^(11/2))/(11*b^4)) + (6*a^2*(a + b*x)^(13/2))/(13*b^4) - (2*a*(a + b*x)^(15/2))/(5*b^4) + (2*(a + b*x)^(17/2))/(17*b^4)}
{x^2*(a + b*x)^(9/2), x, 2, (2*a^2*(a + b*x)^(11/2))/(11*b^3) - (4*a*(a + b*x)^(13/2))/(13*b^3) + (2*(a + b*x)^(15/2))/(15*b^3)}
{x^1*(a + b*x)^(9/2), x, 2, -((2*a*(a + b*x)^(11/2))/(11*b^2)) + (2*(a + b*x)^(13/2))/(13*b^2)}
{x^0*(a + b*x)^(9/2), x, 1, (2*(a + b*x)^(11/2))/(11*b)}
{(a + b*x)^(9/2)/x^1, x, 6, 2*a^4*Sqrt[a + b*x] + (2/3)*a^3*(a + b*x)^(3/2) + (2/5)*a^2*(a + b*x)^(5/2) + (2/7)*a*(a + b*x)^(7/2) + (2/9)*(a + b*x)^(9/2) - 2*a^(9/2)*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(9/2)/x^2, x, 6, 9*a^3*b*Sqrt[a + b*x] + 3*a^2*b*(a + b*x)^(3/2) + (9/5)*a*b*(a + b*x)^(5/2) + (9/7)*b*(a + b*x)^(7/2) - (a + b*x)^(9/2)/x - 9*a^(7/2)*b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(9/2)/x^3, x, 6, (63/4)*a^2*b^2*Sqrt[a + b*x] + (21/4)*a*b^2*(a + b*x)^(3/2) + (63/20)*b^2*(a + b*x)^(5/2) - (9*b*(a + b*x)^(7/2))/(4*x) - (a + b*x)^(9/2)/(2*x^2) - (63/4)*a^(5/2)*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(9/2)/x^4, x, 6, (105/8)*a*b^3*Sqrt[a + b*x] + (35/8)*b^3*(a + b*x)^(3/2) - (21*b^2*(a + b*x)^(5/2))/(8*x) - (3*b*(a + b*x)^(7/2))/(4*x^2) - (a + b*x)^(9/2)/(3*x^3) - (105/8)*a^(3/2)*b^3*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(9/2)/x^5, x, 6, (315/64)*b^4*Sqrt[a + b*x] - (105*b^3*(a + b*x)^(3/2))/(64*x) - (21*b^2*(a + b*x)^(5/2))/(32*x^2) - (3*b*(a + b*x)^(7/2))/(8*x^3) - (a + b*x)^(9/2)/(4*x^4) - (315/64)*Sqrt[a]*b^4*ArcTanh[Sqrt[a + b*x]/Sqrt[a]]}
{(a + b*x)^(9/2)/x^6, x, 6, -((63*b^4*Sqrt[a + b*x])/(128*x)) - (21*b^3*(a + b*x)^(3/2))/(64*x^2) - (21*b^2*(a + b*x)^(5/2))/(80*x^3) - (9*b*(a + b*x)^(7/2))/(40*x^4) - (a + b*x)^(9/2)/(5*x^5) - (63*b^5*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(128*Sqrt[a])}
{(a + b*x)^(9/2)/x^7, x, 7, -((21*b^4*Sqrt[a + b*x])/(256*x^2)) - (21*b^5*Sqrt[a + b*x])/(512*a*x) - (7*b^3*(a + b*x)^(3/2))/(64*x^3) - (21*b^2*(a + b*x)^(5/2))/(160*x^4) - (3*b*(a + b*x)^(7/2))/(20*x^5) - (a + b*x)^(9/2)/(6*x^6) + (21*b^6*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(512*a^(3/2))}
{(a + b*x)^(9/2)/x^8, x, 8, -((3*b^4*Sqrt[a + b*x])/(128*x^3)) - (3*b^5*Sqrt[a + b*x])/(512*a*x^2) + (9*b^6*Sqrt[a + b*x])/(1024*a^2*x) - (3*b^3*(a + b*x)^(3/2))/(64*x^4) - (3*b^2*(a + b*x)^(5/2))/(40*x^5) - (3*b*(a + b*x)^(7/2))/(28*x^6) - (a + b*x)^(9/2)/(7*x^7) - (9*b^7*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(1024*a^(5/2))}


{Sqrt[-a + b*x]/x, x, 2, 2*Sqrt[-a + b*x] - 2*Sqrt[a]*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}
{Sqrt[-a + b*x]/x^2, x, 2, -(Sqrt[-a + b*x]/x) + (b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/Sqrt[a]}
{Sqrt[-a + b*x]/x^3, x, 3, -(Sqrt[-a + b*x]/(2*x^2)) + (b*Sqrt[-a + b*x])/(4*a*x) + (b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/(4*a^(3/2))}


{(-a + b*x)^(3/2)/x, x, 3, -2*a*Sqrt[-a + b*x] + (2/3)*(-a + b*x)^(3/2) + 2*a^(3/2)*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}
{(-a + b*x)^(3/2)/x^2, x, 3, 3*b*Sqrt[-a + b*x] - (-a + b*x)^(3/2)/x - 3*Sqrt[a]*b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}
{(-a + b*x)^(3/2)/x^3, x, 3, -((3*b*Sqrt[-a + b*x])/(4*x)) - (-a + b*x)^(3/2)/(2*x^2) + (3*b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/(4*Sqrt[a])}


{(-a + b*x)^(5/2)/x, x, 4, 2*a^2*Sqrt[-a + b*x] - (2/3)*a*(-a + b*x)^(3/2) + (2/5)*(-a + b*x)^(5/2) - 2*a^(5/2)*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}
{(-a + b*x)^(5/2)/x^2, x, 4, -5*a*b*Sqrt[-a + b*x] + (5/3)*b*(-a + b*x)^(3/2) - (-a + b*x)^(5/2)/x + 5*a^(3/2)*b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}
{(-a + b*x)^(5/2)/x^3, x, 4, (15/4)*b^2*Sqrt[-a + b*x] - (5*b*(-a + b*x)^(3/2))/(4*x) - (-a + b*x)^(5/2)/(2*x^2) - (15/4)*Sqrt[a]*b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]]}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^m/Sqrt[a + b*x], x, 1, (2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*b)}

{x^4/Sqrt[a + b*x], x, 2, (2*a^4*Sqrt[a + b*x])/b^5 - (8*a^3*(a + b*x)^(3/2))/(3*b^5) + (12*a^2*(a + b*x)^(5/2))/(5*b^5) - (8*a*(a + b*x)^(7/2))/(7*b^5) + (2*(a + b*x)^(9/2))/(9*b^5)}
{x^3/Sqrt[a + b*x], x, 2, -((2*a^3*Sqrt[a + b*x])/b^4) + (2*a^2*(a + b*x)^(3/2))/b^4 - (6*a*(a + b*x)^(5/2))/(5*b^4) + (2*(a + b*x)^(7/2))/(7*b^4)}
{x^2/Sqrt[a + b*x], x, 2, (2*a^2*Sqrt[a + b*x])/b^3 - (4*a*(a + b*x)^(3/2))/(3*b^3) + (2*(a + b*x)^(5/2))/(5*b^3)}
{x^1/Sqrt[a + b*x], x, 2, -((2*a*Sqrt[a + b*x])/b^2) + (2*(a + b*x)^(3/2))/(3*b^2)}
{x^0/Sqrt[a + b*x], x, 1, (2*Sqrt[a + b*x])/b}
{1/(x^1*Sqrt[a + b*x]), x, 1, (-2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/Sqrt[a]}
{1/(x^2*Sqrt[a + b*x]), x, 2, -(Sqrt[a + b*x]/(a*x)) + (b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/a^(3/2)}
{1/(x^3*Sqrt[a + b*x]), x, 3, -(Sqrt[a + b*x]/(2*a*x^2)) + (3*b*Sqrt[a + b*x])/(4*a^2*x) - (3*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(4*a^(5/2))}
{1/(x^4*Sqrt[a + b*x]), x, 4, -(Sqrt[a + b*x]/(3*a*x^3)) + (5*b*Sqrt[a + b*x])/(12*a^2*x^2) - (5*b^2*Sqrt[a + b*x])/(8*a^3*x) + (5*b^3*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(8*a^(7/2))}


{x^m/(a + b*x)^(3/2), x, 2, (2*x^(1 + m))/(a*Sqrt[a + b*x]) - (2*(1 + 2*m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(a*b))}

{x^4/(a + b*x)^(3/2), x, 2, -((2*a^4)/(b^5*Sqrt[a + b*x])) - (8*a^3*Sqrt[a + b*x])/b^5 + (4*a^2*(a + b*x)^(3/2))/b^5 - (8*a*(a + b*x)^(5/2))/(5*b^5) + (2*(a + b*x)^(7/2))/(7*b^5)}
{x^3/(a + b*x)^(3/2), x, 2, (2*a^3)/(b^4*Sqrt[a + b*x]) + (6*a^2*Sqrt[a + b*x])/b^4 - (2*a*(a + b*x)^(3/2))/b^4 + (2*(a + b*x)^(5/2))/(5*b^4)}
{x^2/(a + b*x)^(3/2), x, 2, -((2*a^2)/(b^3*Sqrt[a + b*x])) - (4*a*Sqrt[a + b*x])/b^3 + (2*(a + b*x)^(3/2))/(3*b^3)}
{x^1/(a + b*x)^(3/2), x, 2, (2*a)/(b^2*Sqrt[a + b*x]) + (2*Sqrt[a + b*x])/b^2}
{x^0/(a + b*x)^(3/2), x, 1, -(2/(b*Sqrt[a + b*x]))}
{1/(x^1*(a + b*x)^(3/2)), x, 2, 2/(a*Sqrt[a + b*x]) - (2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/a^(3/2)}
{1/(x^2*(a + b*x)^(3/2)), x, 3, 2/(a*x*Sqrt[a + b*x]) - (3*Sqrt[a + b*x])/(a^2*x) + (3*b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/a^(5/2)}
{1/(x^3*(a + b*x)^(3/2)), x, 4, 2/(a*x^2*Sqrt[a + b*x]) - (5*Sqrt[a + b*x])/(2*a^2*x^2) + (15*b*Sqrt[a + b*x])/(4*a^3*x) - (15*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(4*a^(7/2))}


{x^m/(a + b*x)^(5/2), x, 3, (2*x^(1 + m))/(3*a*(a + b*x)^(3/2)) + (2*(1 - 2*m)*x^(1 + m))/(3*a^2*Sqrt[a + b*x]) - (2*(1 - 2*m)*(1 + 2*m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(3*a^2*b))}

{x^4/(a + b*x)^(5/2), x, 2, -((2*a^4)/(3*b^5*(a + b*x)^(3/2))) + (8*a^3)/(b^5*Sqrt[a + b*x]) + (12*a^2*Sqrt[a + b*x])/b^5 - (8*a*(a + b*x)^(3/2))/(3*b^5) + (2*(a + b*x)^(5/2))/(5*b^5)}
{x^3/(a + b*x)^(5/2), x, 2, (2*a^3)/(3*b^4*(a + b*x)^(3/2)) - (6*a^2)/(b^4*Sqrt[a + b*x]) - (6*a*Sqrt[a + b*x])/b^4 + (2*(a + b*x)^(3/2))/(3*b^4)}
{x^2/(a + b*x)^(5/2), x, 2, -((2*a^2)/(3*b^3*(a + b*x)^(3/2))) + (4*a)/(b^3*Sqrt[a + b*x]) + (2*Sqrt[a + b*x])/b^3}
{x^1/(a + b*x)^(5/2), x, 2, (2*a)/(3*b^2*(a + b*x)^(3/2)) - 2/(b^2*Sqrt[a + b*x])}
{x^0/(a + b*x)^(5/2), x, 1, -(2/(3*b*(a + b*x)^(3/2)))}
{1/(x^1*(a + b*x)^(5/2)), x, 3, 2/(3*a*(a + b*x)^(3/2)) + 2/(a^2*Sqrt[a + b*x]) - (2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/a^(5/2)}
{1/(x^2*(a + b*x)^(5/2)), x, 4, 2/(3*a*x*(a + b*x)^(3/2)) + 10/(3*a^2*x*Sqrt[a + b*x]) - (5*Sqrt[a + b*x])/(a^3*x) + (5*b*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/a^(7/2)}
{1/(x^3*(a + b*x)^(5/2)), x, 5, 2/(3*a*x^2*(a + b*x)^(3/2)) + 14/(3*a^2*x^2*Sqrt[a + b*x]) - (35*Sqrt[a + b*x])/(6*a^3*x^2) + (35*b*Sqrt[a + b*x])/(4*a^4*x) - (35*b^2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/(4*a^(9/2))}


{1/(x^1*Sqrt[-a + b*x]), x, 1, (2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/Sqrt[a]}
{1/(x^2*Sqrt[-a + b*x]), x, 2, Sqrt[-a + b*x]/(a*x) + (b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/a^(3/2)}
{1/(x^3*Sqrt[-a + b*x]), x, 3, Sqrt[-a + b*x]/(2*a*x^2) + (3*b*Sqrt[-a + b*x])/(4*a^2*x) + (3*b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/(4*a^(5/2))}


{1/(x^1*(-a + b*x)^(3/2)), x, 2, -2/(a*Sqrt[-a + b*x]) - (2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/a^(3/2)}
{1/(x^2*(-a + b*x)^(3/2)), x, 3, -(2/(a*x*Sqrt[-a + b*x])) - (3*Sqrt[-a + b*x])/(a^2*x) - (3*b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/a^(5/2)}
{1/(x^3*(-a + b*x)^(3/2)), x, 4, -(2/(a*x^2*Sqrt[-a + b*x])) - (5*Sqrt[-a + b*x])/(2*a^2*x^2) - (15*b*Sqrt[-a + b*x])/(4*a^3*x) - (15*b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/(4*a^(7/2))}


{1/(x^1*(-a + b*x)^(5/2)), x, 3, -(2/(3*a*(-a + b*x)^(3/2))) + 2/(a^2*Sqrt[-a + b*x]) + (2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/a^(5/2)}
{1/(x^2*(-a + b*x)^(5/2)), x, 4, -(2/(3*a*x*(-a + b*x)^(3/2))) + 10/(3*a^2*x*Sqrt[-a + b*x]) + (5*Sqrt[-a + b*x])/(a^3*x) + (5*b*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/a^(7/2)}
{1/(x^3*(-a + b*x)^(5/2)), x, 5, -(2/(3*a*x^2*(-a + b*x)^(3/2))) + 14/(3*a^2*x^2*Sqrt[-a + b*x]) + (35*Sqrt[-a + b*x])/(6*a^3*x^2) + (35*b*Sqrt[-a + b*x])/(4*a^4*x) + (35*b^2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/(4*a^(9/2))}


{x^(3 + m)/Sqrt[a + b*x], x, 4, (8*a^2*(2 + m)*(3 + m)*x^(1 + m)*Sqrt[a + b*x])/(b^3*(3 + 2*m)*(5 + 2*m)*(7 + 2*m)) - (4*a*(3 + m)*x^(2 + m)*Sqrt[a + b*x])/(b^2*(5 + 2*m)*(7 + 2*m)) + (2*x^(3 + m)*Sqrt[a + b*x])/(b*(7 + 2*m)) - (16*a^3*(1 + m)*(2 + m)*(3 + m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b^4*(3 + 2*m)*(5 + 2*m)*(7 + 2*m)))}
{x^(2 + m)/Sqrt[a + b*x], x, 3, -((4*a*(2 + m)*x^(1 + m)*Sqrt[a + b*x])/(b^2*(3 + 2*m)*(5 + 2*m))) + (2*x^(2 + m)*Sqrt[a + b*x])/(b*(5 + 2*m)) + (8*a^2*(1 + m)*(2 + m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b^3*(3 + 2*m)*(5 + 2*m)))}
{x^(1 + m)/Sqrt[a + b*x], x, 2, (2*x^(1 + m)*Sqrt[a + b*x])/(b*(3 + 2*m)) - (4*a*(1 + m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(b^2*(3 + 2*m)))}
{x^(0 + m)/Sqrt[a + b*x], x, 1, (2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*b)}
{x^(-1 + m)/Sqrt[a + b*x], x, 2, (x^m*Sqrt[a + b*x])/(a*m) - ((1 + 2*m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(a*m))}
{x^(-2 + m)/Sqrt[a + b*x], x, 3, -((x^(-1 + m)*Sqrt[a + b*x])/(a*(1 - m))) - (b*(1 - 2*m)*x^m*Sqrt[a + b*x])/(2*a^2*(1 - m)*m) + (b*(1 - 2*m)*(1 + 2*m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(2*a^2*(1 - m)*m))}
{x^(-3 + m)/Sqrt[a + b*x], x, 4, -((x^(-2 + m)*Sqrt[a + b*x])/(a*(2 - m))) + (b*(3 - 2*m)*x^(-1 + m)*Sqrt[a + b*x])/(2*a^2*(1 - m)*(2 - m)) + (b^2*(1 - 2*m)*(3 - 2*m)*x^m*Sqrt[a + b*x])/(4*a^3*(1 - m)*(2 - m)*m) - (b^2*(1 - 2*m)*(3 - 2*m)*(1 + 2*m)*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, (a + b*x)/a])/((-((b*x)/a))^m*(4*a^3*(1 - m)*(2 - m)*m))}


{(x^(-1 + m)*(2*a*m + b*(-1 + 2*m)*x))/(2*(a + b*x)^(3/2)), x, 2, x^m/Sqrt[a + b*x]}
{-((b*x^m)/(2*(a + b*x)^(3/2))) + (m*x^(-1 + m))/Sqrt[a + b*x], x, 5, x^m/Sqrt[a + b*x], -((b*x^(1 + m))/(a*Sqrt[a + b*x])) + (x^m*Sqrt[a + b*x])/a}


{x^((1 - n)/2 + (1/2)*(-3 + n))/Sqrt[a + b*x], x, 2, -((2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/Sqrt[a])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x)^(n/3)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^3*(a + b*x)^(1/3), x, 2, (-3*a^3*(a + b*x)^(4/3))/(4*b^4) + (9*a^2*(a + b*x)^(7/3))/(7*b^4) - (9*a*(a + b*x)^(10/3))/(10*b^4) + (3*(a + b*x)^(13/3))/(13*b^4)}
{x^2*(a + b*x)^(1/3), x, 2, (3*a^2*(a + b*x)^(4/3))/(4*b^3) - (6*a*(a + b*x)^(7/3))/(7*b^3) + (3*(a + b*x)^(10/3))/(10*b^3)}
{x*(a + b*x)^(1/3), x, 2, (-3*a*(a + b*x)^(4/3))/(4*b^2) + (3*(a + b*x)^(7/3))/(7*b^2)}
{(a + b*x)^(1/3), x, 1, (3*(a + b*x)^(4/3))/(4*b)}
{(a + b*x)^(1/3)/x, x, 7, 3*(a + b*x)^(1/3) - Sqrt[3]*a^(1/3)*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))] + a^(1/3)*Log[a^(1/3) - (a + b*x)^(1/3)] - (a^(1/3)*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/2}
{(a + b*x)^(1/3)/x^2, x, 7, -((a + b*x)^(1/3)/x) - (b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)) + (b*Log[a^(1/3) - (a + b*x)^(1/3)])/(3*a^(2/3)) - (b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(6*a^(2/3))}
{(a + b*x)^(1/3)/x^3, x, 8, -(a + b*x)^(1/3)/(2*x^2) - (b*(a + b*x)^(1/3))/(6*a*x) + (b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)) - (b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(5/3)) + (b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(18*a^(5/3))}


{x^3*(a + b*x)^(2/3), x, 2, (-3*a^3*(a + b*x)^(5/3))/(5*b^4) + (9*a^2*(a + b*x)^(8/3))/(8*b^4) - (9*a*(a + b*x)^(11/3))/(11*b^4) + (3*(a + b*x)^(14/3))/(14*b^4)}
{x^2*(a + b*x)^(2/3), x, 2, (3*a^2*(a + b*x)^(5/3))/(5*b^3) - (3*a*(a + b*x)^(8/3))/(4*b^3) + (3*(a + b*x)^(11/3))/(11*b^3)}
{x*(a + b*x)^(2/3), x, 2, (-3*a*(a + b*x)^(5/3))/(5*b^2) + (3*(a + b*x)^(8/3))/(8*b^2)}
{(a + b*x)^(2/3), x, 1, (3*(a + b*x)^(5/3))/(5*b)}
{(a + b*x)^(2/3)/x, x, 7, (3*(a + b*x)^(2/3))/2 + Sqrt[3]*a^(2/3)*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))] + a^(2/3)*Log[a^(1/3) - (a + b*x)^(1/3)] - (a^(2/3)*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/2}
{(a + b*x)^(2/3)/x^2, x, 7, -((a + b*x)^(2/3)/x) + (2*b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)) + (2*b*Log[a^(1/3) - (a + b*x)^(1/3)])/(3*a^(1/3)) - (b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(3*a^(1/3))}
{(a + b*x)^(2/3)/x^3, x, 8, -(a + b*x)^(2/3)/(2*x^2) - (b*(a + b*x)^(2/3))/(3*a*x) - (b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(4/3)) - (b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(4/3)) + (b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(18*a^(4/3))}


{x^3*(a + b*x)^(4/3), x, 2, (-3*a^3*(a + b*x)^(7/3))/(7*b^4) + (9*a^2*(a + b*x)^(10/3))/(10*b^4) - (9*a*(a + b*x)^(13/3))/(13*b^4) + (3*(a + b*x)^(16/3))/(16*b^4)}
{x^2*(a + b*x)^(4/3), x, 2, (3*a^2*(a + b*x)^(7/3))/(7*b^3) - (3*a*(a + b*x)^(10/3))/(5*b^3) + (3*(a + b*x)^(13/3))/(13*b^3)}
{x*(a + b*x)^(4/3), x, 2, (-3*a*(a + b*x)^(7/3))/(7*b^2) + (3*(a + b*x)^(10/3))/(10*b^2)}
{(a + b*x)^(4/3), x, 1, (3*(a + b*x)^(7/3))/(7*b)}
{(a + b*x)^(4/3)/x, x, 8, 3*a*(a + b*x)^(1/3) + (3*(a + b*x)^(4/3))/4 - Sqrt[3]*a^(4/3)*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))] + a^(4/3)*Log[a^(1/3) - (a + b*x)^(1/3)] - (a^(4/3)*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/2}
{(a + b*x)^(4/3)/x^2, x, 8, 4*b*(a + b*x)^(1/3) - (a + b*x)^(4/3)/x - (4*a^(1/3)*b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/Sqrt[3] + (4*a^(1/3)*b*Log[a^(1/3) - (a + b*x)^(1/3)])/3 - (2*a^(1/3)*b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/3}
{(a + b*x)^(4/3)/x^3, x, 8, (-2*b*(a + b*x)^(1/3))/(3*x) - (a + b*x)^(4/3)/(2*x^2) - (2*b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(2/3)) + (2*b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(2/3)) - (b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(9*a^(2/3))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^3/(a + b*x)^(1/3), x, 2, (-3*a^3*(a + b*x)^(2/3))/(2*b^4) + (9*a^2*(a + b*x)^(5/3))/(5*b^4) - (9*a*(a + b*x)^(8/3))/(8*b^4) + (3*(a + b*x)^(11/3))/(11*b^4)}
{x^2/(a + b*x)^(1/3), x, 2, (3*a^2*(a + b*x)^(2/3))/(2*b^3) - (6*a*(a + b*x)^(5/3))/(5*b^3) + (3*(a + b*x)^(8/3))/(8*b^3)}
{x/(a + b*x)^(1/3), x, 2, (-3*a*(a + b*x)^(2/3))/(2*b^2) + (3*(a + b*x)^(5/3))/(5*b^2)}
{(a + b*x)^(-1/3), x, 1, (3*(a + b*x)^(2/3))/(2*b)}
{1/(x*(a + b*x)^(1/3)), x, 6, (Sqrt[3]*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/a^(1/3) + Log[a^(1/3) - (a + b*x)^(1/3)]/a^(1/3) - Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)]/(2*a^(1/3))}
{1/(x^2*(a + b*x)^(1/3)), x, 7, -((a + b*x)^(2/3)/(a*x)) - (b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) - (b*Log[a^(1/3) - (a + b*x)^(1/3)])/(3*a^(4/3)) + (b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(6*a^(4/3))}
{1/(x^3*(a + b*x)^(1/3)), x, 8, -(a + b*x)^(2/3)/(2*a*x^2) + (2*b*(a + b*x)^(2/3))/(3*a^2*x) + (2*b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) + (2*b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(7/3)) - (b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(9*a^(7/3))}

{x^3/(-a + b*x)^(1/3), x, 2, (3*a^3*(-a + b*x)^(2/3))/(2*b^4) + (9*a^2*(-a + b*x)^(5/3))/(5*b^4) + (9*a*(-a + b*x)^(8/3))/(8*b^4) + (3*(-a + b*x)^(11/3))/(11*b^4)}
{x^2/(-a + b*x)^(1/3), x, 2, (3*a^2*(-a + b*x)^(2/3))/(2*b^3) + (6*a*(-a + b*x)^(5/3))/(5*b^3) + (3*(-a + b*x)^(8/3))/(8*b^3)}
{x/(-a + b*x)^(1/3), x, 2, (3*a*(-a + b*x)^(2/3))/(2*b^2) + (3*(-a + b*x)^(5/3))/(5*b^2)}
{(-a + b*x)^(-1/3), x, 1, (3*(-a + b*x)^(2/3))/(2*b)}
{1/(x*(-a + b*x)^(1/3)), x, 6, -((Sqrt[3]*ArcTan[(a^(1/3) - 2*(-a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/a^(1/3)) - Log[a^(1/3) + (-a + b*x)^(1/3)]/a^(1/3) + Log[a^(2/3) - a^(1/3)*(-a + b*x)^(1/3) + (-a + b*x)^(2/3)]/(2*a^(1/3))}
{1/(x^2*(-a + b*x)^(1/3)), x, 7, (-a + b*x)^(2/3)/(a*x) - (b*ArcTan[(a^(1/3) - 2*(-a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) - (b*Log[a^(1/3) + (-a + b*x)^(1/3)])/(3*a^(4/3)) + (b*Log[a^(2/3) - a^(1/3)*(-a + b*x)^(1/3) + (-a + b*x)^(2/3)])/(6*a^(4/3))}
{1/(x^3*(-a + b*x)^(1/3)), x, 8, (-a + b*x)^(2/3)/(2*a*x^2) + (2*b*(-a + b*x)^(2/3))/(3*a^2*x) - (2*b^2*ArcTan[(a^(1/3) - 2*(-a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) - (2*b^2*Log[a^(1/3) + (-a + b*x)^(1/3)])/(9*a^(7/3)) + (b^2*Log[a^(2/3) - a^(1/3)*(-a + b*x)^(1/3) + (-a + b*x)^(2/3)])/(9*a^(7/3))}


{x^3/(a + b*x)^(2/3), x, 2, (-3*a^3*(a + b*x)^(1/3))/b^4 + (9*a^2*(a + b*x)^(4/3))/(4*b^4) - (9*a*(a + b*x)^(7/3))/(7*b^4) + (3*(a + b*x)^(10/3))/(10*b^4)}
{x^2/(a + b*x)^(2/3), x, 2, (3*a^2*(a + b*x)^(1/3))/b^3 - (3*a*(a + b*x)^(4/3))/(2*b^3) + (3*(a + b*x)^(7/3))/(7*b^3)}
{x/(a + b*x)^(2/3), x, 2, (-3*a*(a + b*x)^(1/3))/b^2 + (3*(a + b*x)^(4/3))/(4*b^2)}
{(a + b*x)^(-2/3), x, 1, (3*(a + b*x)^(1/3))/b}
{1/(x*(a + b*x)^(2/3)), x, 6, -((Sqrt[3]*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/a^(2/3)) + Log[a^(1/3) - (a + b*x)^(1/3)]/a^(2/3) - Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)]/(2*a^(2/3))}
{1/(x^2*(a + b*x)^(2/3)), x, 7, -((a + b*x)^(1/3)/(a*x)) + (2*b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)) - (2*b*Log[a^(1/3) - (a + b*x)^(1/3)])/(3*a^(5/3)) + (b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(3*a^(5/3))}
{1/(x^3*(a + b*x)^(2/3)), x, 8, -(a + b*x)^(1/3)/(2*a*x^2) + (5*b*(a + b*x)^(1/3))/(6*a^2*x) - (5*b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)) + (5*b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(8/3)) - (5*b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(18*a^(8/3))}


{x^3/(a + b*x)^(4/3), x, 2, (3*a^3)/(b^4*(a + b*x)^(1/3)) + (9*a^2*(a + b*x)^(2/3))/(2*b^4) - (9*a*(a + b*x)^(5/3))/(5*b^4) + (3*(a + b*x)^(8/3))/(8*b^4)}
{x^2/(a + b*x)^(4/3), x, 2, (-3*a^2)/(b^3*(a + b*x)^(1/3)) - (3*a*(a + b*x)^(2/3))/b^3 + (3*(a + b*x)^(5/3))/(5*b^3)}
{x/(a + b*x)^(4/3), x, 2, (3*a)/(b^2*(a + b*x)^(1/3)) + (3*(a + b*x)^(2/3))/(2*b^2)}
{(a + b*x)^(-4/3), x, 1, -3/(b*(a + b*x)^(1/3))}
{1/(x*(a + b*x)^(4/3)), x, 7, 3/(a*(a + b*x)^(1/3)) + (Sqrt[3]*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/a^(4/3) + Log[a^(1/3) - (a + b*x)^(1/3)]/a^(4/3) - Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)]/(2*a^(4/3))}
{1/(x^2*(a + b*x)^(4/3)), x, 8, 3/(a*x*(a + b*x)^(1/3)) - (4*(a + b*x)^(2/3))/(a^2*x) - (4*b*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(7/3)) - (4*b*Log[a^(1/3) - (a + b*x)^(1/3)])/(3*a^(7/3)) + (2*b*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(3*a^(7/3))}
{1/(x^3*(a + b*x)^(4/3)), x, 9, 3/(a*x^2*(a + b*x)^(1/3)) - (7*(a + b*x)^(2/3))/(2*a^2*x^2) + (14*b*(a + b*x)^(2/3))/(3*a^3*x) + (14*b^2*ArcTan[(a^(1/3) + 2*(a + b*x)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(10/3)) + (14*b^2*Log[a^(1/3) - (a + b*x)^(1/3)])/(9*a^(10/3)) - (7*b^2*Log[a^(2/3) + a^(1/3)*(a + b*x)^(1/3) + (a + b*x)^(2/3)])/(9*a^(10/3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x)^n*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^m*(a + b*x), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(2 + m))/(2 + m)}

{x^(5/2)*(a + b*x), x, 2, (2/7)*a*x^(7/2) + (2/9)*b*x^(9/2)}
{x^(3/2)*(a + b*x), x, 2, (2/5)*a*x^(5/2) + (2/7)*b*x^(7/2)}
{Sqrt[x]*(a + b*x), x, 2, (2/3)*a*x^(3/2) + (2/5)*b*x^(5/2)}
{(a + b*x)/Sqrt[x], x, 2, 2*a*Sqrt[x] + (2/3)*b*x^(3/2)}
{(a + b*x)/x^(3/2), x, 2, -((2*a)/Sqrt[x]) + 2*b*Sqrt[x]}
{(a + b*x)/x^(5/2), x, 2, -((2*a)/(3*x^(3/2))) - (2*b)/Sqrt[x]}


{x^m*(a + b*x)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + (b^2*x^(3 + m))/(3 + m)}

{x^(5/2)*(a + b*x)^2, x, 2, (2/7)*a^2*x^(7/2) + (4/9)*a*b*x^(9/2) + (2/11)*b^2*x^(11/2)}
{x^(3/2)*(a + b*x)^2, x, 2, (2/5)*a^2*x^(5/2) + (4/7)*a*b*x^(7/2) + (2/9)*b^2*x^(9/2)}
{Sqrt[x]*(a + b*x)^2, x, 2, (2/3)*a^2*x^(3/2) + (4/5)*a*b*x^(5/2) + (2/7)*b^2*x^(7/2)}
{(a + b*x)^2/Sqrt[x], x, 2, 2*a^2*Sqrt[x] + (4/3)*a*b*x^(3/2) + (2/5)*b^2*x^(5/2)}
{(a + b*x)^2/x^(3/2), x, 2, -((2*a^2)/Sqrt[x]) + 4*a*b*Sqrt[x] + (2/3)*b^2*x^(3/2)}
{(a + b*x)^2/x^(5/2), x, 2, -((2*a^2)/(3*x^(3/2))) - (4*a*b)/Sqrt[x] + 2*b^2*Sqrt[x]}


{x^m*(a + b*x)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(2 + m))/(2 + m) + (3*a*b^2*x^(3 + m))/(3 + m) + (b^3*x^(4 + m))/(4 + m)}

{x^(5/2)*(a + b*x)^3, x, 2, (2/7)*a^3*x^(7/2) + (2/3)*a^2*b*x^(9/2) + (6/11)*a*b^2*x^(11/2) + (2/13)*b^3*x^(13/2)}
{x^(3/2)*(a + b*x)^3, x, 2, (2/5)*a^3*x^(5/2) + (6/7)*a^2*b*x^(7/2) + (2/3)*a*b^2*x^(9/2) + (2/11)*b^3*x^(11/2)}
{Sqrt[x]*(a + b*x)^3, x, 2, (2/3)*a^3*x^(3/2) + (6/5)*a^2*b*x^(5/2) + (6/7)*a*b^2*x^(7/2) + (2/9)*b^3*x^(9/2)}
{(a + b*x)^3/Sqrt[x], x, 2, 2*a^3*Sqrt[x] + 2*a^2*b*x^(3/2) + (6/5)*a*b^2*x^(5/2) + (2/7)*b^3*x^(7/2)}
{(a + b*x)^3/x^(3/2), x, 2, -((2*a^3)/Sqrt[x]) + 6*a^2*b*Sqrt[x] + 2*a*b^2*x^(3/2) + (2/5)*b^3*x^(5/2)}
{(a + b*x)^3/x^(5/2), x, 2, -((2*a^3)/(3*x^(3/2))) - (6*a^2*b)/Sqrt[x] + 6*a*b^2*Sqrt[x] + (2/3)*b^3*x^(3/2)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^(5/2)/(a + b*x), x, 4, (2*a^2*Sqrt[x])/b^3 - (2*a*x^(3/2))/(3*b^2) + (2*x^(5/2))/(5*b) - (2*a^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(7/2)}
{x^(3/2)/(a + b*x), x, 3, -((2*a*Sqrt[x])/b^2) + (2*x^(3/2))/(3*b) + (2*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(5/2)}
{Sqrt[x]/(a + b*x), x, 2, (2*Sqrt[x])/b - (2*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(3/2)}
{1/(Sqrt[x]*(a + b*x)), x, 1, (2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(Sqrt[a]*Sqrt[b])}
{1/(x^(3/2)*(a + b*x)), x, 2, -2/(a*Sqrt[x]) - (2*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(3/2)}
{1/(x^(5/2)*(a + b*x)), x, 3, -(2/(3*a*x^(3/2))) + (2*b)/(a^2*Sqrt[x]) + (2*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(5/2)}
{1/(x^(7/2)*(a + b*x)), x, 4, -(2/(5*a*x^(5/2))) + (2*b)/(3*a^2*x^(3/2)) - (2*b^2)/(a^3*Sqrt[x]) - (2*b^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(7/2)}


{x^(5/2)/(a + b*x)^2, x, 4, -((5*a*Sqrt[x])/b^3) + (5*x^(3/2))/(3*b^2) - x^(5/2)/(b*(a + b*x)) + (5*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(7/2)}
{x^(3/2)/(a + b*x)^2, x, 3, (3*Sqrt[x])/b^2 - x^(3/2)/(b*(a + b*x)) - (3*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(5/2)}
{Sqrt[x]/(a + b*x)^2, x, 2, -(Sqrt[x]/(b*(a + b*x))) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(Sqrt[a]*b^(3/2))}
{1/(Sqrt[x]*(a + b*x)^2), x, 2, Sqrt[x]/(a*(a + b*x)) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(a^(3/2)*Sqrt[b])}
{1/(x^(3/2)*(a + b*x)^2), x, 3, -(3/(a^2*Sqrt[x])) + 1/(a*Sqrt[x]*(a + b*x)) - (3*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(5/2)}
{1/(x^(5/2)*(a + b*x)^2), x, 4, -(5/(3*a^2*x^(3/2))) + (5*b)/(a^3*Sqrt[x]) + 1/(a*x^(3/2)*(a + b*x)) + (5*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(7/2)}


{x^(7/2)/(a + b*x)^3, x, 5, -((35*a*Sqrt[x])/(4*b^4)) + (35*x^(3/2))/(12*b^3) - x^(7/2)/(2*b*(a + b*x)^2) - (7*x^(5/2))/(4*b^2*(a + b*x)) + (35*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(9/2))}
{x^(5/2)/(a + b*x)^3, x, 4, (15*Sqrt[x])/(4*b^3) - x^(5/2)/(2*b*(a + b*x)^2) - (5*x^(3/2))/(4*b^2*(a + b*x)) - (15*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(7/2))}
{x^(3/2)/(a + b*x)^3, x, 3, -(x^(3/2)/(2*b*(a + b*x)^2)) - (3*Sqrt[x])/(4*b^2*(a + b*x)) + (3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*Sqrt[a]*b^(5/2))}
{Sqrt[x]/(a + b*x)^3, x, 3, -(Sqrt[x]/(2*b*(a + b*x)^2)) + Sqrt[x]/(4*a*b*(a + b*x)) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(4*a^(3/2)*b^(3/2))}
{1/(Sqrt[x]*(a + b*x)^3), x, 3, Sqrt[x]/(2*a*(a + b*x)^2) + (3*Sqrt[x])/(4*a^2*(a + b*x)) + (3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(5/2)*Sqrt[b])}
{1/(x^(3/2)*(a + b*x)^3), x, 4, -(15/(4*a^3*Sqrt[x])) + 1/(2*a*Sqrt[x]*(a + b*x)^2) + 5/(4*a^2*Sqrt[x]*(a + b*x)) - (15*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(7/2))}
{1/(x^(5/2)*(a + b*x)^3), x, 5, -(35/(12*a^3*x^(3/2))) + (35*b)/(4*a^4*Sqrt[x]) + 1/(2*a*x^(3/2)*(a + b*x)^2) + 7/(4*a^2*x^(3/2)*(a + b*x)) + (35*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(9/2))}


{x^(5/2)/(-a + b*x), x, 4, (2*a^2*Sqrt[x])/b^3 + (2*a*x^(3/2))/(3*b^2) + (2*x^(5/2))/(5*b) - (2*a^(5/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(7/2)}
{x^(3/2)/(-a + b*x), x, 3, (2*a*Sqrt[x])/b^2 + (2*x^(3/2))/(3*b) - (2*a^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(5/2)}
{Sqrt[x]/(-a + b*x), x, 2, (2*Sqrt[x])/b - (2*Sqrt[a]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(3/2)}
{1/(Sqrt[x]*(-a + b*x)), x, 1, (-2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(Sqrt[a]*Sqrt[b])}
{1/(x^(3/2)*(-a + b*x)), x, 2, 2/(a*Sqrt[x]) - (2*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(3/2)}
{1/(x^(5/2)*(-a + b*x)), x, 3, 2/(3*a*x^(3/2)) + (2*b)/(a^2*Sqrt[x]) - (2*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(5/2)}
{1/(x^(7/2)*(-a + b*x)), x, 4, 2/(5*a*x^(5/2)) + (2*b)/(3*a^2*x^(3/2)) + (2*b^2)/(a^3*Sqrt[x]) - (2*b^(5/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(7/2)}


{x^(5/2)/(-a + b*x)^2, x, 4, (5*a*Sqrt[x])/b^3 + (5*x^(3/2))/(3*b^2) + x^(5/2)/(b*(a - b*x)) - (5*a^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(7/2)}
{x^(3/2)/(-a + b*x)^2, x, 3, (3*Sqrt[x])/b^2 + x^(3/2)/(b*(a - b*x)) - (3*Sqrt[a]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(5/2)}
{Sqrt[x]/(-a + b*x)^2, x, 2, Sqrt[x]/(b*(a - b*x)) - ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(Sqrt[a]*b^(3/2))}
{1/(Sqrt[x]*(-a + b*x)^2), x, 2, Sqrt[x]/(a*(a - b*x)) + ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(a^(3/2)*Sqrt[b])}
{1/(x^(3/2)*(-a + b*x)^2), x, 3, -(3/(a^2*Sqrt[x])) + 1/(a*Sqrt[x]*(a - b*x)) + (3*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(5/2)}
{1/(x^(5/2)*(-a + b*x)^2), x, 4, -(5/(3*a^2*x^(3/2))) - (5*b)/(a^3*Sqrt[x]) + 1/(a*x^(3/2)*(a - b*x)) + (5*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(7/2)}


{x^(7/2)/(-a + b*x)^3, x, 5, (35*a*Sqrt[x])/(4*b^4) + (35*x^(3/2))/(12*b^3) - x^(7/2)/(2*b*(a - b*x)^2) + (7*x^(5/2))/(4*b^2*(a - b*x)) - (35*a^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(9/2))}
{x^(5/2)/(-a + b*x)^3, x, 4, (15*Sqrt[x])/(4*b^3) - x^(5/2)/(2*b*(a - b*x)^2) + (5*x^(3/2))/(4*b^2*(a - b*x)) - (15*Sqrt[a]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(7/2))}
{x^(3/2)/(-a + b*x)^3, x, 3, -(x^(3/2)/(2*b*(a - b*x)^2)) + (3*Sqrt[x])/(4*b^2*(a - b*x)) - (3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*Sqrt[a]*b^(5/2))}
{Sqrt[x]/(-a + b*x)^3, x, 3, -(Sqrt[x]/(2*b*(a - b*x)^2)) + Sqrt[x]/(4*a*b*(a - b*x)) + ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(4*a^(3/2)*b^(3/2))}
{1/(Sqrt[x]*(-a + b*x)^3), x, 3, -(Sqrt[x]/(2*a*(a - b*x)^2)) - (3*Sqrt[x])/(4*a^2*(a - b*x)) - (3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(5/2)*Sqrt[b])}
{1/(x^(3/2)*(-a + b*x)^3), x, 4, 15/(4*a^3*Sqrt[x]) - 1/(2*a*Sqrt[x]*(a - b*x)^2) - 5/(4*a^2*Sqrt[x]*(a - b*x)) - (15*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(7/2))}
{1/(x^(5/2)*(-a + b*x)^3), x, 5, 35/(12*a^3*x^(3/2)) + (35*b)/(4*a^4*Sqrt[x]) - 1/(2*a*x^(3/2)*(a - b*x)^2) - 7/(4*a^2*x^(3/2)*(a - b*x)) - (35*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(9/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x)^(n/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^(5/2)*Sqrt[a + b*x], x, 5, (5*a^3*Sqrt[x]*Sqrt[a + b*x])/(64*b^3) - (5*a^2*x^(3/2)*Sqrt[a + b*x])/(96*b^2) + (a*x^(5/2)*Sqrt[a + b*x])/(24*b) + (1/4)*x^(7/2)*Sqrt[a + b*x] - (5*a^4*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(64*b^(7/2))}
{x^(3/2)*Sqrt[a + b*x], x, 4, -((a^2*Sqrt[x]*Sqrt[a + b*x])/(8*b^2)) + (a*x^(3/2)*Sqrt[a + b*x])/(12*b) + (1/3)*x^(5/2)*Sqrt[a + b*x] + (a^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(8*b^(5/2))}
{Sqrt[x]*Sqrt[a + b*x], x, 3, (a*Sqrt[x]*Sqrt[a + b*x])/(4*b) + (1/2)*x^(3/2)*Sqrt[a + b*x] - (a^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(4*b^(3/2))}
{Sqrt[a + b*x]/Sqrt[x], x, 2, Sqrt[x]*Sqrt[a + b*x] + (a*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/Sqrt[b]}
{Sqrt[a + b*x]/x^(3/2), x, 2, (-2*Sqrt[a + b*x])/Sqrt[x] + 2*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]]}
{Sqrt[a + b*x]/x^(5/2), x, 1, (-2*(a + b*x)^(3/2))/(3*a*x^(3/2))}
{Sqrt[a + b*x]/x^(7/2), x, 2, -((2*(a + b*x)^(3/2))/(5*a*x^(5/2))) + (4*b*(a + b*x)^(3/2))/(15*a^2*x^(3/2))}
{Sqrt[a + b*x]/x^(9/2), x, 3, -((2*(a + b*x)^(3/2))/(7*a*x^(7/2))) + (8*b*(a + b*x)^(3/2))/(35*a^2*x^(5/2)) - (16*b^2*(a + b*x)^(3/2))/(105*a^3*x^(3/2))}


{x^(5/2)*Sqrt[a - b*x], x, 5, -((5*a^3*Sqrt[x]*Sqrt[a - b*x])/(64*b^3)) - (5*a^2*x^(3/2)*Sqrt[a - b*x])/(96*b^2) - (a*x^(5/2)*Sqrt[a - b*x])/(24*b) + (1/4)*x^(7/2)*Sqrt[a - b*x] + (5*a^4*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(64*b^(7/2))}
{x^(3/2)*Sqrt[a - b*x], x, 4, -((a^2*Sqrt[x]*Sqrt[a - b*x])/(8*b^2)) - (a*x^(3/2)*Sqrt[a - b*x])/(12*b) + (1/3)*x^(5/2)*Sqrt[a - b*x] + (a^3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(8*b^(5/2))}
{Sqrt[x]*Sqrt[a - b*x], x, 3, -((a*Sqrt[x]*Sqrt[a - b*x])/(4*b)) + (1/2)*x^(3/2)*Sqrt[a - b*x] + (a^2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(4*b^(3/2))}
{Sqrt[a - b*x]/Sqrt[x], x, 2, Sqrt[x]*Sqrt[a - b*x] + (a*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/Sqrt[b]}
{Sqrt[a - b*x]/x^(3/2), x, 2, (-2*Sqrt[a - b*x])/Sqrt[x] - 2*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]]}
{Sqrt[a - b*x]/x^(5/2), x, 1, (-2*(a - b*x)^(3/2))/(3*a*x^(3/2))}
{Sqrt[a - b*x]/x^(7/2), x, 2, -((2*(a - b*x)^(3/2))/(5*a*x^(5/2))) - (4*b*(a - b*x)^(3/2))/(15*a^2*x^(3/2))}
{Sqrt[a - b*x]/x^(9/2), x, 3, -((2*(a - b*x)^(3/2))/(7*a*x^(7/2))) - (8*b*(a - b*x)^(3/2))/(35*a^2*x^(5/2)) - (16*b^2*(a - b*x)^(3/2))/(105*a^3*x^(3/2))}


{x^(5/2)*Sqrt[2 + b*x], x, 5, (5*Sqrt[x]*Sqrt[2 + b*x])/(8*b^3) - (5*x^(3/2)*Sqrt[2 + b*x])/(24*b^2) + (x^(5/2)*Sqrt[2 + b*x])/(12*b) + (1/4)*x^(7/2)*Sqrt[2 + b*x] - (5*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(7/2))}
{x^(3/2)*Sqrt[2 + b*x], x, 4, -((Sqrt[x]*Sqrt[2 + b*x])/(2*b^2)) + (x^(3/2)*Sqrt[2 + b*x])/(6*b) + (1/3)*x^(5/2)*Sqrt[2 + b*x] + ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(5/2)}
{Sqrt[x]*Sqrt[2 + b*x], x, 3, (Sqrt[x]*Sqrt[2 + b*x])/(2*b) + (1/2)*x^(3/2)*Sqrt[2 + b*x] - ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(3/2)}
{Sqrt[2 + b*x]/Sqrt[x], x, 2, Sqrt[x]*Sqrt[2 + b*x] + (2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{Sqrt[2 + b*x]/x^(3/2), x, 2, (-2*Sqrt[2 + b*x])/Sqrt[x] + 2*Sqrt[b]*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{Sqrt[2 + b*x]/x^(5/2), x, 1, -(2 + b*x)^(3/2)/(3*x^(3/2))}
{Sqrt[2 + b*x]/x^(7/2), x, 2, -((2 + b*x)^(3/2)/(5*x^(5/2))) + (b*(2 + b*x)^(3/2))/(15*x^(3/2))}
{Sqrt[2 + b*x]/x^(9/2), x, 3, -((2 + b*x)^(3/2)/(7*x^(7/2))) + (2*b*(2 + b*x)^(3/2))/(35*x^(5/2)) - (2*b^2*(2 + b*x)^(3/2))/(105*x^(3/2))}


{x^(5/2)*Sqrt[2 - b*x], x, 5, -((5*Sqrt[x]*Sqrt[2 - b*x])/(8*b^3)) - (5*x^(3/2)*Sqrt[2 - b*x])/(24*b^2) - (x^(5/2)*Sqrt[2 - b*x])/(12*b) + (1/4)*x^(7/2)*Sqrt[2 - b*x] + (5*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(7/2))}
{x^(3/2)*Sqrt[2 - b*x], x, 4, -((Sqrt[x]*Sqrt[2 - b*x])/(2*b^2)) - (x^(3/2)*Sqrt[2 - b*x])/(6*b) + (1/3)*x^(5/2)*Sqrt[2 - b*x] + ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(5/2)}
{Sqrt[x]*Sqrt[2 - b*x], x, 3, -((Sqrt[x]*Sqrt[2 - b*x])/(2*b)) + (1/2)*x^(3/2)*Sqrt[2 - b*x] + ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(3/2)}
{Sqrt[2 - b*x]/Sqrt[x], x, 2, Sqrt[x]*Sqrt[2 - b*x] + (2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{Sqrt[2 - b*x]/x^(3/2), x, 2, (-2*Sqrt[2 - b*x])/Sqrt[x] - 2*Sqrt[b]*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{Sqrt[2 - b*x]/x^(5/2), x, 1, -(2 - b*x)^(3/2)/(3*x^(3/2))}
{Sqrt[2 - b*x]/x^(7/2), x, 2, -((2 - b*x)^(3/2)/(5*x^(5/2))) - (b*(2 - b*x)^(3/2))/(15*x^(3/2))}
{Sqrt[2 - b*x]/x^(9/2), x, 3, -((2 - b*x)^(3/2)/(7*x^(7/2))) - (2*b*(2 - b*x)^(3/2))/(35*x^(5/2)) - (2*b^2*(2 - b*x)^(3/2))/(105*x^(3/2))}


{x^(5/2)*(a + b*x)^(3/2), x, 6, (3*a^4*Sqrt[x]*Sqrt[a + b*x])/(128*b^3) - (a^3*x^(3/2)*Sqrt[a + b*x])/(64*b^2) + (a^2*x^(5/2)*Sqrt[a + b*x])/(80*b) + (3/40)*a*x^(7/2)*Sqrt[a + b*x] + (1/5)*x^(7/2)*(a + b*x)^(3/2) - (3*a^5*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(128*b^(7/2))}
{x^(3/2)*(a + b*x)^(3/2), x, 5, -((3*a^3*Sqrt[x]*Sqrt[a + b*x])/(64*b^2)) + (a^2*x^(3/2)*Sqrt[a + b*x])/(32*b) + (1/8)*a*x^(5/2)*Sqrt[a + b*x] + (1/4)*x^(5/2)*(a + b*x)^(3/2) + (3*a^4*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(64*b^(5/2))}
{Sqrt[x]*(a + b*x)^(3/2), x, 4, (a^2*Sqrt[x]*Sqrt[a + b*x])/(8*b) + (1/4)*a*x^(3/2)*Sqrt[a + b*x] + (1/3)*x^(3/2)*(a + b*x)^(3/2) - (a^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(8*b^(3/2))}
{(a + b*x)^(3/2)/Sqrt[x], x, 3, (3/4)*a*Sqrt[x]*Sqrt[a + b*x] + (1/2)*Sqrt[x]*(a + b*x)^(3/2) + (3*a^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(4*Sqrt[b])}
{(a + b*x)^(3/2)/x^(3/2), x, 3, 3*b*Sqrt[x]*Sqrt[a + b*x] - (2*(a + b*x)^(3/2))/Sqrt[x] + 3*a*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]]}
{(a + b*x)^(3/2)/x^(5/2), x, 3, -((2*b*Sqrt[a + b*x])/Sqrt[x]) - (2*(a + b*x)^(3/2))/(3*x^(3/2)) + 2*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]]}


{x^(5/2)*(a - b*x)^(3/2), x, 6, -((3*a^4*Sqrt[x]*Sqrt[a - b*x])/(128*b^3)) - (a^3*x^(3/2)*Sqrt[a - b*x])/(64*b^2) - (a^2*x^(5/2)*Sqrt[a - b*x])/(80*b) + (3/40)*a*x^(7/2)*Sqrt[a - b*x] + (1/5)*x^(7/2)*(a - b*x)^(3/2) + (3*a^5*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(128*b^(7/2))}
{x^(3/2)*(a - b*x)^(3/2), x, 5, -((3*a^3*Sqrt[x]*Sqrt[a - b*x])/(64*b^2)) - (a^2*x^(3/2)*Sqrt[a - b*x])/(32*b) + (1/8)*a*x^(5/2)*Sqrt[a - b*x] + (1/4)*x^(5/2)*(a - b*x)^(3/2) + (3*a^4*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(64*b^(5/2))}
{Sqrt[x]*(a - b*x)^(3/2), x, 4, -((a^2*Sqrt[x]*Sqrt[a - b*x])/(8*b)) + (1/4)*a*x^(3/2)*Sqrt[a - b*x] + (1/3)*x^(3/2)*(a - b*x)^(3/2) + (a^3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(8*b^(3/2))}
{(a - b*x)^(3/2)/Sqrt[x], x, 3, (3/4)*a*Sqrt[x]*Sqrt[a - b*x] + (1/2)*Sqrt[x]*(a - b*x)^(3/2) + (3*a^2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(4*Sqrt[b])}
{(a - b*x)^(3/2)/x^(3/2), x, 3, -3*b*Sqrt[x]*Sqrt[a - b*x] - (2*(a - b*x)^(3/2))/Sqrt[x] - 3*a*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]]}
{(a - b*x)^(3/2)/x^(5/2), x, 3, (2*b*Sqrt[a - b*x])/Sqrt[x] - (2*(a - b*x)^(3/2))/(3*x^(3/2)) + 2*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]]}


{x^(5/2)*(2 + b*x)^(3/2), x, 6, (3*Sqrt[x]*Sqrt[2 + b*x])/(8*b^3) - (x^(3/2)*Sqrt[2 + b*x])/(8*b^2) + (x^(5/2)*Sqrt[2 + b*x])/(20*b) + (3/20)*x^(7/2)*Sqrt[2 + b*x] + (1/5)*x^(7/2)*(2 + b*x)^(3/2) - (3*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(7/2))}
{x^(3/2)*(2 + b*x)^(3/2), x, 5, -((3*Sqrt[x]*Sqrt[2 + b*x])/(8*b^2)) + (x^(3/2)*Sqrt[2 + b*x])/(8*b) + (1/4)*x^(5/2)*Sqrt[2 + b*x] + (1/4)*x^(5/2)*(2 + b*x)^(3/2) + (3*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(5/2))}
{Sqrt[x]*(2 + b*x)^(3/2), x, 4, (Sqrt[x]*Sqrt[2 + b*x])/(2*b) + (1/2)*x^(3/2)*Sqrt[2 + b*x] + (1/3)*x^(3/2)*(2 + b*x)^(3/2) - ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(3/2)}
{(2 + b*x)^(3/2)/Sqrt[x], x, 3, (3/2)*Sqrt[x]*Sqrt[2 + b*x] + (1/2)*Sqrt[x]*(2 + b*x)^(3/2) + (3*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{(2 + b*x)^(3/2)/x^(3/2), x, 3, 3*b*Sqrt[x]*Sqrt[2 + b*x] - (2*(2 + b*x)^(3/2))/Sqrt[x] + 6*Sqrt[b]*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{(2 + b*x)^(3/2)/x^(5/2), x, 3, -((2*b*Sqrt[2 + b*x])/Sqrt[x]) - (2*(2 + b*x)^(3/2))/(3*x^(3/2)) + 2*b^(3/2)*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}


{x^(5/2)*(2 - b*x)^(3/2), x, 6, -((3*Sqrt[x]*Sqrt[2 - b*x])/(8*b^3)) - (x^(3/2)*Sqrt[2 - b*x])/(8*b^2) - (x^(5/2)*Sqrt[2 - b*x])/(20*b) + (3/20)*x^(7/2)*Sqrt[2 - b*x] + (1/5)*x^(7/2)*(2 - b*x)^(3/2) + (3*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(7/2))}
{x^(3/2)*(2 - b*x)^(3/2), x, 5, -((3*Sqrt[x]*Sqrt[2 - b*x])/(8*b^2)) - (x^(3/2)*Sqrt[2 - b*x])/(8*b) + (1/4)*x^(5/2)*Sqrt[2 - b*x] + (1/4)*x^(5/2)*(2 - b*x)^(3/2) + (3*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(5/2))}
{Sqrt[x]*(2 - b*x)^(3/2), x, 4, -((Sqrt[x]*Sqrt[2 - b*x])/(2*b)) + (1/2)*x^(3/2)*Sqrt[2 - b*x] + (1/3)*x^(3/2)*(2 - b*x)^(3/2) + ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]/b^(3/2)}
{(2 - b*x)^(3/2)/Sqrt[x], x, 3, (3/2)*Sqrt[x]*Sqrt[2 - b*x] + (1/2)*Sqrt[x]*(2 - b*x)^(3/2) + (3*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{(2 - b*x)^(3/2)/x^(3/2), x, 3, -3*b*Sqrt[x]*Sqrt[2 - b*x] - (2*(2 - b*x)^(3/2))/Sqrt[x] - 6*Sqrt[b]*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{(2 - b*x)^(3/2)/x^(5/2), x, 3, (2*b*Sqrt[2 - b*x])/Sqrt[x] - (2*(2 - b*x)^(3/2))/(3*x^(3/2)) + 2*b^(3/2)*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}


{x^(5/2)*(a + b*x)^(5/2), x, 7, (5*a^5*Sqrt[x]*Sqrt[a + b*x])/(512*b^3) - (5*a^4*x^(3/2)*Sqrt[a + b*x])/(768*b^2) + (a^3*x^(5/2)*Sqrt[a + b*x])/(192*b) + (1/32)*a^2*x^(7/2)*Sqrt[a + b*x] + (1/12)*a*x^(7/2)*(a + b*x)^(3/2) + (1/6)*x^(7/2)*(a + b*x)^(5/2) - (5*a^6*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(512*b^(7/2))}
{x^(3/2)*(a + b*x)^(5/2), x, 6, -((3*a^4*Sqrt[x]*Sqrt[a + b*x])/(128*b^2)) + (a^3*x^(3/2)*Sqrt[a + b*x])/(64*b) + (1/16)*a^2*x^(5/2)*Sqrt[a + b*x] + (1/8)*a*x^(5/2)*(a + b*x)^(3/2) + (1/5)*x^(5/2)*(a + b*x)^(5/2) + (3*a^5*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(128*b^(5/2))}
{Sqrt[x]*(a + b*x)^(5/2), x, 5, (5*a^3*Sqrt[x]*Sqrt[a + b*x])/(64*b) + (5/32)*a^2*x^(3/2)*Sqrt[a + b*x] + (5/24)*a*x^(3/2)*(a + b*x)^(3/2) + (1/4)*x^(3/2)*(a + b*x)^(5/2) - (5*a^4*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(64*b^(3/2))}
{(a + b*x)^(5/2)/Sqrt[x], x, 4, (5/8)*a^2*Sqrt[x]*Sqrt[a + b*x] + (5/12)*a*Sqrt[x]*(a + b*x)^(3/2) + (1/3)*Sqrt[x]*(a + b*x)^(5/2) + (5*a^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(8*Sqrt[b])}
{(a + b*x)^(5/2)/x^(3/2), x, 4, (15/4)*a*b*Sqrt[x]*Sqrt[a + b*x] + (5/2)*b*Sqrt[x]*(a + b*x)^(3/2) - (2*(a + b*x)^(5/2))/Sqrt[x] + (15/4)*a^2*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]]}
{(a + b*x)^(5/2)/x^(5/2), x, 4, 5*b^2*Sqrt[x]*Sqrt[a + b*x] - (10*b*(a + b*x)^(3/2))/(3*Sqrt[x]) - (2*(a + b*x)^(5/2))/(3*x^(3/2)) + 5*a*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]]}


{x^(5/2)*(a - b*x)^(5/2), x, 7, -((5*a^5*Sqrt[x]*Sqrt[a - b*x])/(512*b^3)) - (5*a^4*x^(3/2)*Sqrt[a - b*x])/(768*b^2) - (a^3*x^(5/2)*Sqrt[a - b*x])/(192*b) + (1/32)*a^2*x^(7/2)*Sqrt[a - b*x] + (1/12)*a*x^(7/2)*(a - b*x)^(3/2) + (1/6)*x^(7/2)*(a - b*x)^(5/2) + (5*a^6*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(512*b^(7/2))}
{x^(3/2)*(a - b*x)^(5/2), x, 6, -((3*a^4*Sqrt[x]*Sqrt[a - b*x])/(128*b^2)) - (a^3*x^(3/2)*Sqrt[a - b*x])/(64*b) + (1/16)*a^2*x^(5/2)*Sqrt[a - b*x] + (1/8)*a*x^(5/2)*(a - b*x)^(3/2) + (1/5)*x^(5/2)*(a - b*x)^(5/2) + (3*a^5*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(128*b^(5/2))}
{Sqrt[x]*(a - b*x)^(5/2), x, 5, -((5*a^3*Sqrt[x]*Sqrt[a - b*x])/(64*b)) + (5/32)*a^2*x^(3/2)*Sqrt[a - b*x] + (5/24)*a*x^(3/2)*(a - b*x)^(3/2) + (1/4)*x^(3/2)*(a - b*x)^(5/2) + (5*a^4*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(64*b^(3/2))}
{(a - b*x)^(5/2)/Sqrt[x], x, 4, (5/8)*a^2*Sqrt[x]*Sqrt[a - b*x] + (5/12)*a*Sqrt[x]*(a - b*x)^(3/2) + (1/3)*Sqrt[x]*(a - b*x)^(5/2) + (5*a^3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(8*Sqrt[b])}
{(a - b*x)^(5/2)/x^(3/2), x, 4, (-(15/4))*a*b*Sqrt[x]*Sqrt[a - b*x] - (5/2)*b*Sqrt[x]*(a - b*x)^(3/2) - (2*(a - b*x)^(5/2))/Sqrt[x] - (15/4)*a^2*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]]}
{(a - b*x)^(5/2)/x^(5/2), x, 4, 5*b^2*Sqrt[x]*Sqrt[a - b*x] + (10*b*(a - b*x)^(3/2))/(3*Sqrt[x]) - (2*(a - b*x)^(5/2))/(3*x^(3/2)) + 5*a*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]]}


{x^(5/2)*(2 + b*x)^(5/2), x, 7, (5*Sqrt[x]*Sqrt[2 + b*x])/(16*b^3) - (5*x^(3/2)*Sqrt[2 + b*x])/(48*b^2) + (x^(5/2)*Sqrt[2 + b*x])/(24*b) + (1/8)*x^(7/2)*Sqrt[2 + b*x] + (1/6)*x^(7/2)*(2 + b*x)^(3/2) + (1/6)*x^(7/2)*(2 + b*x)^(5/2) - (5*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(8*b^(7/2))}
{x^(3/2)*(2 + b*x)^(5/2), x, 6, -((3*Sqrt[x]*Sqrt[2 + b*x])/(8*b^2)) + (x^(3/2)*Sqrt[2 + b*x])/(8*b) + (1/4)*x^(5/2)*Sqrt[2 + b*x] + (1/4)*x^(5/2)*(2 + b*x)^(3/2) + (1/5)*x^(5/2)*(2 + b*x)^(5/2) + (3*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(5/2))}
{Sqrt[x]*(2 + b*x)^(5/2), x, 5, (5*Sqrt[x]*Sqrt[2 + b*x])/(8*b) + (5/8)*x^(3/2)*Sqrt[2 + b*x] + (5/12)*x^(3/2)*(2 + b*x)^(3/2) + (1/4)*x^(3/2)*(2 + b*x)^(5/2) - (5*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(3/2))}
{(2 + b*x)^(5/2)/Sqrt[x], x, 4, (5/2)*Sqrt[x]*Sqrt[2 + b*x] + (5/6)*Sqrt[x]*(2 + b*x)^(3/2) + (1/3)*Sqrt[x]*(2 + b*x)^(5/2) + (5*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{(2 + b*x)^(5/2)/x^(3/2), x, 4, (15/2)*b*Sqrt[x]*Sqrt[2 + b*x] + (5/2)*b*Sqrt[x]*(2 + b*x)^(3/2) - (2*(2 + b*x)^(5/2))/Sqrt[x] + 15*Sqrt[b]*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{(2 + b*x)^(5/2)/x^(5/2), x, 4, 5*b^2*Sqrt[x]*Sqrt[2 + b*x] - (10*b*(2 + b*x)^(3/2))/(3*Sqrt[x]) - (2*(2 + b*x)^(5/2))/(3*x^(3/2)) + 10*b^(3/2)*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}


{x^(5/2)*(2 - b*x)^(5/2), x, 7, -((5*Sqrt[x]*Sqrt[2 - b*x])/(16*b^3)) - (5*x^(3/2)*Sqrt[2 - b*x])/(48*b^2) - (x^(5/2)*Sqrt[2 - b*x])/(24*b) + (1/8)*x^(7/2)*Sqrt[2 - b*x] + (1/6)*x^(7/2)*(2 - b*x)^(3/2) + (1/6)*x^(7/2)*(2 - b*x)^(5/2) + (5*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(8*b^(7/2))}
{x^(3/2)*(2 - b*x)^(5/2), x, 6, -((3*Sqrt[x]*Sqrt[2 - b*x])/(8*b^2)) - (x^(3/2)*Sqrt[2 - b*x])/(8*b) + (1/4)*x^(5/2)*Sqrt[2 - b*x] + (1/4)*x^(5/2)*(2 - b*x)^(3/2) + (1/5)*x^(5/2)*(2 - b*x)^(5/2) + (3*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(5/2))}
{Sqrt[x]*(2 - b*x)^(5/2), x, 5, -((5*Sqrt[x]*Sqrt[2 - b*x])/(8*b)) + (5/8)*x^(3/2)*Sqrt[2 - b*x] + (5/12)*x^(3/2)*(2 - b*x)^(3/2) + (1/4)*x^(3/2)*(2 - b*x)^(5/2) + (5*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/(4*b^(3/2))}
{(2 - b*x)^(5/2)/Sqrt[x], x, 4, (5/2)*Sqrt[x]*Sqrt[2 - b*x] + (5/6)*Sqrt[x]*(2 - b*x)^(3/2) + (1/3)*Sqrt[x]*(2 - b*x)^(5/2) + (5*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{(2 - b*x)^(5/2)/x^(3/2), x, 4, (-(15/2))*b*Sqrt[x]*Sqrt[2 - b*x] - (5/2)*b*Sqrt[x]*(2 - b*x)^(3/2) - (2*(2 - b*x)^(5/2))/Sqrt[x] - 15*Sqrt[b]*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}
{(2 - b*x)^(5/2)/x^(5/2), x, 4, 5*b^2*Sqrt[x]*Sqrt[2 - b*x] + (10*b*(2 - b*x)^(3/2))/(3*Sqrt[x]) - (2*(2 - b*x)^(5/2))/(3*x^(3/2)) + 10*b^(3/2)*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]]}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^(5/2)/Sqrt[a + b*x], x, 4, (5*a^2*Sqrt[x]*Sqrt[a + b*x])/(8*b^3) - (5*a*x^(3/2)*Sqrt[a + b*x])/(12*b^2) + (x^(5/2)*Sqrt[a + b*x])/(3*b) - (5*a^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(8*b^(7/2))}
{x^(3/2)/Sqrt[a + b*x], x, 3, -((3*a*Sqrt[x]*Sqrt[a + b*x])/(4*b^2)) + (x^(3/2)*Sqrt[a + b*x])/(2*b) + (3*a^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(4*b^(5/2))}
{Sqrt[x]/Sqrt[a + b*x], x, 2, (Sqrt[x]*Sqrt[a + b*x])/b - (a*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/b^(3/2)}
{1/(Sqrt[x]*Sqrt[a + b*x]), x, 1, (2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/Sqrt[b]}
{1/(x^(3/2)*Sqrt[a + b*x]), x, 1, (-2*Sqrt[a + b*x])/(a*Sqrt[x])}
{1/(x^(5/2)*Sqrt[a + b*x]), x, 2, -((2*Sqrt[a + b*x])/(3*a*x^(3/2))) + (4*b*Sqrt[a + b*x])/(3*a^2*Sqrt[x])}
{1/(x^(7/2)*Sqrt[a + b*x]), x, 3, -((2*Sqrt[a + b*x])/(5*a*x^(5/2))) + (8*b*Sqrt[a + b*x])/(15*a^2*x^(3/2)) - (16*b^2*Sqrt[a + b*x])/(15*a^3*Sqrt[x])}
{1/(x^(9/2)*Sqrt[a + b*x]), x, 4, -((2*Sqrt[a + b*x])/(7*a*x^(7/2))) + (12*b*Sqrt[a + b*x])/(35*a^2*x^(5/2)) - (16*b^2*Sqrt[a + b*x])/(35*a^3*x^(3/2)) + (32*b^3*Sqrt[a + b*x])/(35*a^4*Sqrt[x])}


{x^(5/2)/(a + b*x)^(3/2), x, 4, -((2*x^(5/2))/(b*Sqrt[a + b*x])) - (15*a*Sqrt[x]*Sqrt[a + b*x])/(4*b^3) + (5*x^(3/2)*Sqrt[a + b*x])/(2*b^2) + (15*a^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/(4*b^(7/2))}
{x^(3/2)/(a + b*x)^(3/2), x, 3, -((2*x^(3/2))/(b*Sqrt[a + b*x])) + (3*Sqrt[x]*Sqrt[a + b*x])/b^2 - (3*a*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/b^(5/2)}
{Sqrt[x]/(a + b*x)^(3/2), x, 2, (-2*Sqrt[x])/(b*Sqrt[a + b*x]) + (2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/b^(3/2)}
{1/(Sqrt[x]*(a + b*x)^(3/2)), x, 1, (2*Sqrt[x])/(a*Sqrt[a + b*x])}
{1/(x^(3/2)*(a + b*x)^(3/2)), x, 2, 2/(a*Sqrt[x]*Sqrt[a + b*x]) - (4*Sqrt[a + b*x])/(a^2*Sqrt[x])}
{1/(x^(5/2)*(a + b*x)^(3/2)), x, 3, 2/(a*x^(3/2)*Sqrt[a + b*x]) - (8*Sqrt[a + b*x])/(3*a^2*x^(3/2)) + (16*b*Sqrt[a + b*x])/(3*a^3*Sqrt[x])}
{1/(x^(7/2)*(a + b*x)^(3/2)), x, 4, 2/(a*x^(5/2)*Sqrt[a + b*x]) - (12*Sqrt[a + b*x])/(5*a^2*x^(5/2)) + (16*b*Sqrt[a + b*x])/(5*a^3*x^(3/2)) - (32*b^2*Sqrt[a + b*x])/(5*a^4*Sqrt[x])}


{x^(5/2)/(a + b*x)^(5/2), x, 4, -((2*x^(5/2))/(3*b*(a + b*x)^(3/2))) - (10*x^(3/2))/(3*b^2*Sqrt[a + b*x]) + (5*Sqrt[x]*Sqrt[a + b*x])/b^3 - (5*a*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/b^(7/2)}
{x^(3/2)/(a + b*x)^(5/2), x, 3, -((2*x^(3/2))/(3*b*(a + b*x)^(3/2))) - (2*Sqrt[x])/(b^2*Sqrt[a + b*x]) + (2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a + b*x]])/b^(5/2)}
{Sqrt[x]/(a + b*x)^(5/2), x, 1, (2*x^(3/2))/(3*a*(a + b*x)^(3/2))}
{1/(Sqrt[x]*(a + b*x)^(5/2)), x, 2, (2*Sqrt[x])/(3*a*(a + b*x)^(3/2)) + (4*Sqrt[x])/(3*a^2*Sqrt[a + b*x])}
{1/(x^(3/2)*(a + b*x)^(5/2)), x, 3, 2/(3*a*Sqrt[x]*(a + b*x)^(3/2)) + 8/(3*a^2*Sqrt[x]*Sqrt[a + b*x]) - (16*Sqrt[a + b*x])/(3*a^3*Sqrt[x])}
{1/(x^(5/2)*(a + b*x)^(5/2)), x, 4, 2/(3*a*x^(3/2)*(a + b*x)^(3/2)) + 4/(a^2*x^(3/2)*Sqrt[a + b*x]) - (16*Sqrt[a + b*x])/(3*a^3*x^(3/2)) + (32*b*Sqrt[a + b*x])/(3*a^4*Sqrt[x])}


{x^(5/2)/Sqrt[a - b*x], x, 4, -((5*a^2*Sqrt[x]*Sqrt[a - b*x])/(8*b^3)) - (5*a*x^(3/2)*Sqrt[a - b*x])/(12*b^2) - (x^(5/2)*Sqrt[a - b*x])/(3*b) + (5*a^3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(8*b^(7/2))}
{x^(3/2)/Sqrt[a - b*x], x, 3, -((3*a*Sqrt[x]*Sqrt[a - b*x])/(4*b^2)) - (x^(3/2)*Sqrt[a - b*x])/(2*b) + (3*a^2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(4*b^(5/2))}
{Sqrt[x]/Sqrt[a - b*x], x, 2, -((Sqrt[x]*Sqrt[a - b*x])/b) + (a*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/b^(3/2)}
{1/(Sqrt[x]*Sqrt[a - b*x]), x, 1, (2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/Sqrt[b]}
{1/(x^(3/2)*Sqrt[a - b*x]), x, 1, (-2*Sqrt[a - b*x])/(a*Sqrt[x])}
{1/(x^(5/2)*Sqrt[a - b*x]), x, 2, -((2*Sqrt[a - b*x])/(3*a*x^(3/2))) - (4*b*Sqrt[a - b*x])/(3*a^2*Sqrt[x])}


{x^(5/2)/(a - b*x)^(3/2), x, 4, (2*x^(5/2))/(b*Sqrt[a - b*x]) + (15*a*Sqrt[x]*Sqrt[a - b*x])/(4*b^3) + (5*x^(3/2)*Sqrt[a - b*x])/(2*b^2) - (15*a^2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/(4*b^(7/2))}
{x^(3/2)/(a - b*x)^(3/2), x, 3, (2*x^(3/2))/(b*Sqrt[a - b*x]) + (3*Sqrt[x]*Sqrt[a - b*x])/b^2 - (3*a*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/b^(5/2)}
{Sqrt[x]/(a - b*x)^(3/2), x, 2, (2*Sqrt[x])/(b*Sqrt[a - b*x]) - (2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/b^(3/2)}
{1/(Sqrt[x]*(a - b*x)^(3/2)), x, 1, (2*Sqrt[x])/(a*Sqrt[a - b*x])}
{1/(x^(3/2)*(a - b*x)^(3/2)), x, 2, 2/(a*Sqrt[x]*Sqrt[a - b*x]) - (4*Sqrt[a - b*x])/(a^2*Sqrt[x])}
{1/(x^(5/2)*(a - b*x)^(3/2)), x, 3, 2/(a*x^(3/2)*Sqrt[a - b*x]) - (8*Sqrt[a - b*x])/(3*a^2*x^(3/2)) - (16*b*Sqrt[a - b*x])/(3*a^3*Sqrt[x])}


{x^(5/2)/(a - b*x)^(5/2), x, 4, (2*x^(5/2))/(3*b*(a - b*x)^(3/2)) - (10*x^(3/2))/(3*b^2*Sqrt[a - b*x]) - (5*Sqrt[x]*Sqrt[a - b*x])/b^3 + (5*a*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/b^(7/2)}
{x^(3/2)/(a - b*x)^(5/2), x, 3, (2*x^(3/2))/(3*b*(a - b*x)^(3/2)) - (2*Sqrt[x])/(b^2*Sqrt[a - b*x]) + (2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a - b*x]])/b^(5/2)}
{Sqrt[x]/(a - b*x)^(5/2), x, 1, (2*x^(3/2))/(3*a*(a - b*x)^(3/2))}
{1/(Sqrt[x]*(a - b*x)^(5/2)), x, 2, (2*Sqrt[x])/(3*a*(a - b*x)^(3/2)) + (4*Sqrt[x])/(3*a^2*Sqrt[a - b*x])}
{1/(x^(3/2)*(a - b*x)^(5/2)), x, 3, 2/(3*a*Sqrt[x]*(a - b*x)^(3/2)) + 8/(3*a^2*Sqrt[x]*Sqrt[a - b*x]) - (16*Sqrt[a - b*x])/(3*a^3*Sqrt[x])}
{1/(x^(5/2)*(a - b*x)^(5/2)), x, 4, 2/(3*a*x^(3/2)*(a - b*x)^(3/2)) + 4/(a^2*x^(3/2)*Sqrt[a - b*x]) - (16*Sqrt[a - b*x])/(3*a^3*x^(3/2)) - (32*b*Sqrt[a - b*x])/(3*a^4*Sqrt[x])}


{x^(5/2)/Sqrt[2 + b*x], x, 4, (5*Sqrt[x]*Sqrt[2 + b*x])/(2*b^3) - (5*x^(3/2)*Sqrt[2 + b*x])/(6*b^2) + (x^(5/2)*Sqrt[2 + b*x])/(3*b) - (5*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/Sqrt[2 + b*x], x, 3, -((3*Sqrt[x]*Sqrt[2 + b*x])/(2*b^2)) + (x^(3/2)*Sqrt[2 + b*x])/(2*b) + (3*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/Sqrt[2 + b*x], x, 2, (Sqrt[x]*Sqrt[2 + b*x])/b - (2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(3/2)}
{1/(Sqrt[x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{1/(x^(3/2)*Sqrt[2 + b*x]), x, 1, -(Sqrt[2 + b*x]/Sqrt[x])}
{1/(x^(5/2)*Sqrt[2 + b*x]), x, 2, -(Sqrt[2 + b*x]/(3*x^(3/2))) + (b*Sqrt[2 + b*x])/(3*Sqrt[x])}
{1/(x^(7/2)*Sqrt[2 + b*x]), x, 3, -(Sqrt[2 + b*x]/(5*x^(5/2))) + (2*b*Sqrt[2 + b*x])/(15*x^(3/2)) - (2*b^2*Sqrt[2 + b*x])/(15*Sqrt[x])}
{1/(x^(9/2)*Sqrt[2 + b*x]), x, 4, -(Sqrt[2 + b*x]/(7*x^(7/2))) + (3*b*Sqrt[2 + b*x])/(35*x^(5/2)) - (2*b^2*Sqrt[2 + b*x])/(35*x^(3/2)) + (2*b^3*Sqrt[2 + b*x])/(35*Sqrt[x])}


{x^(5/2)/(2 + b*x)^(3/2), x, 4, -((2*x^(5/2))/(b*Sqrt[2 + b*x])) - (15*Sqrt[x]*Sqrt[2 + b*x])/(2*b^3) + (5*x^(3/2)*Sqrt[2 + b*x])/(2*b^2) + (15*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/(2 + b*x)^(3/2), x, 3, -((2*x^(3/2))/(b*Sqrt[2 + b*x])) + (3*Sqrt[x]*Sqrt[2 + b*x])/b^2 - (6*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/(2 + b*x)^(3/2), x, 2, (-2*Sqrt[x])/(b*Sqrt[2 + b*x]) + (2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(3/2)}
{1/(Sqrt[x]*(2 + b*x)^(3/2)), x, 1, Sqrt[x]/Sqrt[2 + b*x]}
{1/(x^(3/2)*(2 + b*x)^(3/2)), x, 2, 1/(Sqrt[x]*Sqrt[2 + b*x]) - Sqrt[2 + b*x]/Sqrt[x]}
{1/(x^(5/2)*(2 + b*x)^(3/2)), x, 3, 1/(x^(3/2)*Sqrt[2 + b*x]) - (2*Sqrt[2 + b*x])/(3*x^(3/2)) + (2*b*Sqrt[2 + b*x])/(3*Sqrt[x])}
{1/(x^(7/2)*(2 + b*x)^(3/2)), x, 4, 1/(x^(5/2)*Sqrt[2 + b*x]) - (3*Sqrt[2 + b*x])/(5*x^(5/2)) + (2*b*Sqrt[2 + b*x])/(5*x^(3/2)) - (2*b^2*Sqrt[2 + b*x])/(5*Sqrt[x])}


{x^(5/2)/(2 + b*x)^(5/2), x, 4, -((2*x^(5/2))/(3*b*(2 + b*x)^(3/2))) - (10*x^(3/2))/(3*b^2*Sqrt[2 + b*x]) + (5*Sqrt[x]*Sqrt[2 + b*x])/b^3 - (10*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/(2 + b*x)^(5/2), x, 3, -((2*x^(3/2))/(3*b*(2 + b*x)^(3/2))) - (2*Sqrt[x])/(b^2*Sqrt[2 + b*x]) + (2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/(2 + b*x)^(5/2), x, 1, x^(3/2)/(3*(2 + b*x)^(3/2))}
{1/(Sqrt[x]*(2 + b*x)^(5/2)), x, 2, Sqrt[x]/(3*(2 + b*x)^(3/2)) + Sqrt[x]/(3*Sqrt[2 + b*x])}
{1/(x^(3/2)*(2 + b*x)^(5/2)), x, 3, 1/(3*Sqrt[x]*(2 + b*x)^(3/2)) + 2/(3*Sqrt[x]*Sqrt[2 + b*x]) - (2*Sqrt[2 + b*x])/(3*Sqrt[x])}
{1/(x^(5/2)*(2 + b*x)^(5/2)), x, 4, 1/(3*x^(3/2)*(2 + b*x)^(3/2)) + 1/(x^(3/2)*Sqrt[2 + b*x]) - (2*Sqrt[2 + b*x])/(3*x^(3/2)) + (2*b*Sqrt[2 + b*x])/(3*Sqrt[x])}


{x^(5/2)/Sqrt[2 - b*x], x, 4, -((5*Sqrt[x]*Sqrt[2 - b*x])/(2*b^3)) - (5*x^(3/2)*Sqrt[2 - b*x])/(6*b^2) - (x^(5/2)*Sqrt[2 - b*x])/(3*b) + (5*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/Sqrt[2 - b*x], x, 3, -((3*Sqrt[x]*Sqrt[2 - b*x])/(2*b^2)) - (x^(3/2)*Sqrt[2 - b*x])/(2*b) + (3*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/Sqrt[2 - b*x], x, 2, -((Sqrt[x]*Sqrt[2 - b*x])/b) + (2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(3/2)}
{1/(Sqrt[x]*Sqrt[2 - b*x]), x, 1, (2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]}
{1/(x^(3/2)*Sqrt[2 - b*x]), x, 1, -(Sqrt[2 - b*x]/Sqrt[x])}
{1/(x^(5/2)*Sqrt[2 - b*x]), x, 2, -(Sqrt[2 - b*x]/(3*x^(3/2))) - (b*Sqrt[2 - b*x])/(3*Sqrt[x])}


{x^(5/2)/(2 - b*x)^(3/2), x, 4, (2*x^(5/2))/(b*Sqrt[2 - b*x]) + (15*Sqrt[x]*Sqrt[2 - b*x])/(2*b^3) + (5*x^(3/2)*Sqrt[2 - b*x])/(2*b^2) - (15*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/(2 - b*x)^(3/2), x, 3, (2*x^(3/2))/(b*Sqrt[2 - b*x]) + (3*Sqrt[x]*Sqrt[2 - b*x])/b^2 - (6*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/(2 - b*x)^(3/2), x, 2, (2*Sqrt[x])/(b*Sqrt[2 - b*x]) - (2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(3/2)}
{1/(Sqrt[x]*(2 - b*x)^(3/2)), x, 1, Sqrt[x]/Sqrt[2 - b*x]}
{1/(x^(3/2)*(2 - b*x)^(3/2)), x, 2, 1/(Sqrt[x]*Sqrt[2 - b*x]) - Sqrt[2 - b*x]/Sqrt[x]}
{1/(x^(5/2)*(2 - b*x)^(3/2)), x, 3, 1/(x^(3/2)*Sqrt[2 - b*x]) - (2*Sqrt[2 - b*x])/(3*x^(3/2)) - (2*b*Sqrt[2 - b*x])/(3*Sqrt[x])}


{x^(5/2)/(2 - b*x)^(5/2), x, 4, (2*x^(5/2))/(3*b*(2 - b*x)^(3/2)) - (10*x^(3/2))/(3*b^2*Sqrt[2 - b*x]) - (5*Sqrt[x]*Sqrt[2 - b*x])/b^3 + (10*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(7/2)}
{x^(3/2)/(2 - b*x)^(5/2), x, 3, (2*x^(3/2))/(3*b*(2 - b*x)^(3/2)) - (2*Sqrt[x])/(b^2*Sqrt[2 - b*x]) + (2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/b^(5/2)}
{Sqrt[x]/(2 - b*x)^(5/2), x, 1, x^(3/2)/(3*(2 - b*x)^(3/2))}
{1/(Sqrt[x]*(2 - b*x)^(5/2)), x, 2, Sqrt[x]/(3*(2 - b*x)^(3/2)) + Sqrt[x]/(3*Sqrt[2 - b*x])}
{1/(x^(3/2)*(2 - b*x)^(5/2)), x, 3, 1/(3*Sqrt[x]*(2 - b*x)^(3/2)) + 2/(3*Sqrt[x]*Sqrt[2 - b*x]) - (2*Sqrt[2 - b*x])/(3*Sqrt[x])}
{1/(x^(5/2)*(2 - b*x)^(5/2)), x, 4, 1/(3*x^(3/2)*(2 - b*x)^(3/2)) + 1/(x^(3/2)*Sqrt[2 - b*x]) - (2*Sqrt[2 - b*x])/(3*x^(3/2)) - (2*b*Sqrt[2 - b*x])/(3*Sqrt[x])}


{Sqrt[x]/Sqrt[1 - x], x, 2, (-Sqrt[1 - x])*Sqrt[x] - (1/2)*ArcSin[1 - 2*x]}
{1/(Sqrt[x]*Sqrt[1 - x]), x, 1, -ArcSin[1 - 2*x]}
{1/(Sqrt[x]*Sqrt[1 - b*x]), x, 1, (2*ArcSin[Sqrt[b]*Sqrt[x]])/Sqrt[b]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x)^n*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^(5/3)*(a + b*x), x, 2, (3*a*x^(8/3))/8 + (3*b*x^(11/3))/11}
{x^(4/3)*(a + b*x), x, 2, (3*a*x^(7/3))/7 + (3*b*x^(10/3))/10}
{x^(2/3)*(a + b*x), x, 2, (3*a*x^(5/3))/5 + (3*b*x^(8/3))/8}
{x^(1/3)*(a + b*x), x, 2, (3*a*x^(4/3))/4 + (3*b*x^(7/3))/7}
{(a + b*x)/x^(1/3), x, 2, (3*a*x^(2/3))/2 + (3*b*x^(5/3))/5}
{(a + b*x)/x^(2/3), x, 2, 3*a*x^(1/3) + (3*b*x^(4/3))/4}
{(a + b*x)/x^(4/3), x, 2, (-3*a)/x^(1/3) + (3*b*x^(2/3))/2}
{(a + b*x)/x^(5/3), x, 2, (-3*a)/(2*x^(2/3)) + 3*b*x^(1/3)}


{x^(5/3)*(a + b*x)^2, x, 2, (3*a^2*x^(8/3))/8 + (6*a*b*x^(11/3))/11 + (3*b^2*x^(14/3))/14}
{x^(4/3)*(a + b*x)^2, x, 2, (3*a^2*x^(7/3))/7 + (3*a*b*x^(10/3))/5 + (3*b^2*x^(13/3))/13}
{x^(2/3)*(a + b*x)^2, x, 2, (3*a^2*x^(5/3))/5 + (3*a*b*x^(8/3))/4 + (3*b^2*x^(11/3))/11}
{x^(1/3)*(a + b*x)^2, x, 2, (3*a^2*x^(4/3))/4 + (6*a*b*x^(7/3))/7 + (3*b^2*x^(10/3))/10}
{(a + b*x)^2/x^(1/3), x, 2, (3*a^2*x^(2/3))/2 + (6*a*b*x^(5/3))/5 + (3*b^2*x^(8/3))/8}
{(a + b*x)^2/x^(2/3), x, 2, 3*a^2*x^(1/3) + (3*a*b*x^(4/3))/2 + (3*b^2*x^(7/3))/7}
{(a + b*x)^2/x^(4/3), x, 2, (-3*a^2)/x^(1/3) + 3*a*b*x^(2/3) + (3*b^2*x^(5/3))/5}
{(a + b*x)^2/x^(5/3), x, 2, (-3*a^2)/(2*x^(2/3)) + 6*a*b*x^(1/3) + (3*b^2*x^(4/3))/4}


{x^(5/3)*(a + b*x)^3, x, 2, (3*a^3*x^(8/3))/8 + (9*a^2*b*x^(11/3))/11 + (9*a*b^2*x^(14/3))/14 + (3*b^3*x^(17/3))/17}
{x^(4/3)*(a + b*x)^3, x, 2, (3*a^3*x^(7/3))/7 + (9*a^2*b*x^(10/3))/10 + (9*a*b^2*x^(13/3))/13 + (3*b^3*x^(16/3))/16}
{x^(2/3)*(a + b*x)^3, x, 2, (3*a^3*x^(5/3))/5 + (9*a^2*b*x^(8/3))/8 + (9*a*b^2*x^(11/3))/11 + (3*b^3*x^(14/3))/14}
{x^(1/3)*(a + b*x)^3, x, 2, (3*a^3*x^(4/3))/4 + (9*a^2*b*x^(7/3))/7 + (9*a*b^2*x^(10/3))/10 + (3*b^3*x^(13/3))/13}
{(a + b*x)^3/x^(1/3), x, 2, (3*a^3*x^(2/3))/2 + (9*a^2*b*x^(5/3))/5 + (9*a*b^2*x^(8/3))/8 + (3*b^3*x^(11/3))/11}
{(a + b*x)^3/x^(2/3), x, 2, 3*a^3*x^(1/3) + (9*a^2*b*x^(4/3))/4 + (9*a*b^2*x^(7/3))/7 + (3*b^3*x^(10/3))/10}
{(a + b*x)^3/x^(4/3), x, 2, (-3*a^3)/x^(1/3) + (9*a^2*b*x^(2/3))/2 + (9*a*b^2*x^(5/3))/5 + (3*b^3*x^(8/3))/8}
{(a + b*x)^3/x^(5/3), x, 2, (-3*a^3)/(2*x^(2/3)) + 9*a^2*b*x^(1/3) + (9*a*b^2*x^(4/3))/4 + (3*b^3*x^(7/3))/7}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^(5/3)/(a + b*x), x, 8, (-3*a*x^(2/3))/(2*b^2) + (3*x^(5/3))/(5*b) - (Sqrt[3]*a^(5/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/b^(8/3) - (a^(5/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/b^(8/3) + (a^(5/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*b^(8/3))}
{x^(4/3)/(a + b*x), x, 8, (-3*a*x^(1/3))/b^2 + (3*x^(4/3))/(4*b) - (Sqrt[3]*a^(4/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/b^(7/3) + (a^(4/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/b^(7/3) - (a^(4/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*b^(7/3))}
{x^(2/3)/(a + b*x), x, 7, (3*x^(2/3))/(2*b) + (Sqrt[3]*a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/b^(5/3) + (a^(2/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/b^(5/3) - (a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*b^(5/3))}
{x^(1/3)/(a + b*x), x, 7, (3*x^(1/3))/b + (Sqrt[3]*a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/b^(4/3) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/b^(4/3) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*b^(4/3))}
{1/(x^(1/3)*(a + b*x)), x, 6, -((Sqrt[3]*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(a^(1/3)*b^(2/3))) - Log[a^(1/3) + b^(1/3)*x^(1/3)]/(a^(1/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(2*a^(1/3)*b^(2/3))}
{1/(x^(2/3)*(a + b*x)), x, 6, -((Sqrt[3]*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(a^(2/3)*b^(1/3))) + Log[a^(1/3) + b^(1/3)*x^(1/3)]/(a^(2/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(2*a^(2/3)*b^(1/3))}
{1/(x^(4/3)*(a + b*x)), x, 7, -3/(a*x^(1/3)) + (Sqrt[3]*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/a^(4/3) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/a^(4/3) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*a^(4/3))}
{1/(x^(5/3)*(a + b*x)), x, 7, -3/(2*a*x^(2/3)) + (Sqrt[3]*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/a^(5/3) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/a^(5/3) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(2*a^(5/3))}


{x^(5/3)/(a + b*x)^2, x, 8, (5*x^(2/3))/(2*b^2) - x^(5/3)/(b*(a + b*x)) + (5*a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(8/3)) + (5*a^(2/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*b^(8/3)) - (5*a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(6*b^(8/3))}
{x^(4/3)/(a + b*x)^2, x, 8, (4*x^(1/3))/b^2 - x^(4/3)/(b*(a + b*x)) + (4*a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(7/3)) - (4*a^(1/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*b^(7/3)) + (2*a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(3*b^(7/3))}
{x^(2/3)/(a + b*x)^2, x, 7, -(x^(2/3)/(b*(a + b*x))) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)*b^(5/3)) - (2*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*a^(1/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(3*a^(1/3)*b^(5/3))}
{x^(1/3)/(a + b*x)^2, x, 7, -(x^(1/3)/(b*(a + b*x))) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x^(1/3)]/(3*a^(2/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(6*a^(2/3)*b^(4/3))}
{1/(x^(1/3)*(a + b*x)^2), x, 7, x^(2/3)/(a*(a + b*x)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(4/3)*b^(2/3)) - Log[a^(1/3) + b^(1/3)*x^(1/3)]/(3*a^(4/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(6*a^(4/3)*b^(2/3))}
{1/(x^(2/3)*(a + b*x)^2), x, 7, x^(1/3)/(a*(a + b*x)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)*b^(1/3)) + (2*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*a^(5/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(3*a^(5/3)*b^(1/3))}
{1/(x^(4/3)*(a + b*x)^2), x, 8, -4/(a^2*x^(1/3)) + 1/(a*x^(1/3)*(a + b*x)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(7/3)) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*a^(7/3)) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(3*a^(7/3))}
{1/(x^(5/3)*(a + b*x)^2), x, 8, -5/(2*a^2*x^(2/3)) + 1/(a*x^(2/3)*(a + b*x)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(8/3)) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(3*a^(8/3)) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(6*a^(8/3))}


{x^(5/3)/(a + b*x)^3, x, 8, -x^(5/3)/(2*b*(a + b*x)^2) - (5*x^(2/3))/(6*b^2*(a + b*x)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(8/3)) - (5*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(1/3)*b^(8/3)) + (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(18*a^(1/3)*b^(8/3))}
{x^(4/3)/(a + b*x)^3, x, 8, -x^(4/3)/(2*b*(a + b*x)^2) - (2*x^(1/3))/(3*b^2*(a + b*x)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(2/3)*b^(7/3)) + (2*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(2/3)*b^(7/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(9*a^(2/3)*b^(7/3))}
{x^(2/3)/(a + b*x)^3, x, 8, -x^(2/3)/(2*b*(a + b*x)^2) + x^(2/3)/(3*a*b*(a + b*x)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(5/3)) - Log[a^(1/3) + b^(1/3)*x^(1/3)]/(9*a^(4/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(18*a^(4/3)*b^(5/3))}
{x^(1/3)/(a + b*x)^3, x, 8, -x^(1/3)/(2*b*(a + b*x)^2) + x^(1/3)/(6*a*b*(a + b*x)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(5/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x^(1/3)]/(9*a^(5/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(18*a^(5/3)*b^(4/3))}
{1/(x^(1/3)*(a + b*x)^3), x, 8, x^(2/3)/(2*a*(a + b*x)^2) + (2*x^(2/3))/(3*a^2*(a + b*x)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)*b^(2/3)) - (2*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(7/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)]/(9*a^(7/3)*b^(2/3))}
{1/(x^(2/3)*(a + b*x)^3), x, 8, x^(1/3)/(2*a*(a + b*x)^2) + (5*x^(1/3))/(6*a^2*(a + b*x)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)*b^(1/3)) + (5*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(8/3)*b^(1/3)) - (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(18*a^(8/3)*b^(1/3))}
{1/(x^(4/3)*(a + b*x)^3), x, 9, -14/(3*a^3*x^(1/3)) + 1/(2*a*x^(1/3)*(a + b*x)^2) + 7/(6*a^2*x^(1/3)*(a + b*x)) + (14*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(10/3)) + (14*b^(1/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(10/3)) - (7*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(9*a^(10/3))}
{1/(x^(5/3)*(a + b*x)^3), x, 9, -10/(3*a^3*x^(2/3)) + 1/(2*a*x^(2/3)*(a + b*x)^2) + 4/(3*a^2*x^(2/3)*(a + b*x)) + (20*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(11/3)) - (20*b^(2/3)*Log[a^(1/3) + b^(1/3)*x^(1/3)])/(9*a^(11/3)) + (10*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(1/3) + b^(2/3)*x^(2/3)])/(9*a^(11/3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/4) (a+b x)^n*)


{(1 - x)^(1/4)/(1 + x), x, 5, 4*(1 - x)^(1/4) - 2*2^(1/4)*ArcTan[(1 - x)^(1/4)/2^(1/4)] - 2*2^(1/4)*ArcTanh[(1 - x)^(1/4)/2^(1/4)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x)^n when n is symbolic*)


{x^3*(a + b*x)^n, x, 2, -((a^3*(a + b*x)^(1 + n))/(b^4*(1 + n))) + (3*a^2*(a + b*x)^(2 + n))/(b^4*(2 + n)) - (3*a*(a + b*x)^(3 + n))/(b^4*(3 + n)) + (a + b*x)^(4 + n)/(b^4*(4 + n))}
{x^2*(a + b*x)^n, x, 2, (a^2*(a + b*x)^(1 + n))/(b^3*(1 + n)) - (2*a*(a + b*x)^(2 + n))/(b^3*(2 + n)) + (a + b*x)^(3 + n)/(b^3*(3 + n))}
{x^1*(a + b*x)^n, x, 2, -((a*(a + b*x)^(1 + n))/(b^2*(1 + n))) + (a + b*x)^(2 + n)/(b^2*(2 + n))}
{x^0*(a + b*x)^n, x, 1, (a + b*x)^(1 + n)/(b*(1 + n))}
{(a + b*x)^n/x^1, x, 1, -(((a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (a + b*x)/a])/(a*(1 + n)))}
{(a + b*x)^n/x^2, x, 2, -((a + b*x)^(1 + n)/(a*x)) - (b*n*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (a + b*x)/a])/(a^2*(1 + n))}
{(a + b*x)^n/x^3, x, 3, -((a + b*x)^(1 + n)/(2*a*x^2)) + (b*(1 - n)*(a + b*x)^(1 + n))/(2*a^2*x) + (b^2*(1 - n)*n*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (a + b*x)/a])/(2*a^3*(1 + n))}


{x^(-4 + n)/(a + b*x)^n, x, 3, -((x^(-3 + n)*(a + b*x)^(1 - n))/(a*(3 - n))) + (2*b*x^(-2 + n)*(a + b*x)^(1 - n))/(a^2*(2 - n)*(3 - n)) - (2*b^2*x^(-1 + n)*(a + b*x)^(1 - n))/(a^3*(1 - n)*(2 - n)*(3 - n))}
{x^(-3 + n)/(a + b*x)^n, x, 2, -((x^(-2 + n)*(a + b*x)^(1 - n))/(a*(2 - n))) + (b*x^(-1 + n)*(a + b*x)^(1 - n))/(a^2*(1 - n)*(2 - n))}
{x^(-2 + n)/(a + b*x)^n, x, 1, -((x^(-1 + n)*(a + b*x)^(1 - n))/(a*(1 - n)))}
{x^(-1 + n)/(a + b*x)^n, x, 2, (x^n*(a + b*x)^(1 - n))/(a*n) - (x^n*(a + b*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (a + b*x)/a])/((-((b*x)/a))^n*(a*(1 - n)*n))}
{x^(0 + n)/(a + b*x)^n, x, 1, (x^n*(a + b*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (a + b*x)/a])/((-((b*x)/a))^n*(b*(1 - n)))}
{x^(1 + n)/(a + b*x)^n, x, 2, (x^(1 + n)*(a + b*x)^(1 - n))/(2*b) - (a*(1 + n)*x^n*(a + b*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (a + b*x)/a])/((-((b*x)/a))^n*(2*b^2*(1 - n)))}
{x^(2 + n)/(a + b*x)^n, x, 3, -((a*(2 + n)*x^(1 + n)*(a + b*x)^(1 - n))/(6*b^2)) + (x^(2 + n)*(a + b*x)^(1 - n))/(3*b) + (a^2*(1 + n)*(2 + n)*x^n*(a + b*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (a + b*x)/a])/((-((b*x)/a))^n*(6*b^3*(1 - n)))}


{x^(3/2)*(a + b*x)^n, x, 3, -((6*a*Sqrt[x]*(a + b*x)^(1 + n))/(b^2*(3 + 2*n)*(5 + 2*n))) + (2*x^(3/2)*(a + b*x)^(1 + n))/(b*(5 + 2*n)) + (3*a^2*Sqrt[-((b*x)/a)]*(a + b*x)^(1 + n)*Hypergeometric2F1[1/2, 1 + n, 2 + n, (a + b*x)/a])/(b^3*(1 + n)*(3 + 2*n)*(5 + 2*n)*Sqrt[x])}
{x^(1/2)*(a + b*x)^n, x, 2, (2*Sqrt[x]*(a + b*x)^(1 + n))/(b*(3 + 2*n)) - (a*Sqrt[-((b*x)/a)]*(a + b*x)^(1 + n)*Hypergeometric2F1[1/2, 1 + n, 2 + n, (a + b*x)/a])/(b^2*(1 + n)*(3 + 2*n)*Sqrt[x])}
{(a + b*x)^n/x^(1/2), x, 1, (Sqrt[-((b*x)/a)]*(a + b*x)^(1 + n)*Hypergeometric2F1[1/2, 1 + n, 2 + n, (a + b*x)/a])/(b*(1 + n)*Sqrt[x])}
{(a + b*x)^n/x^(3/2), x, 2, -((2*(a + b*x)^(1 + n))/(a*Sqrt[x])) + ((1 + 2*n)*Sqrt[-((b*x)/a)]*(a + b*x)^(1 + n)*Hypergeometric2F1[1/2, 1 + n, 2 + n, (a + b*x)/a])/(a*(1 + n)*Sqrt[x])}
{(a + b*x)^n/x^(5/2), x, 3, -((2*(a + b*x)^(1 + n))/(3*a*x^(3/2))) + (2*b*(1 - 2*n)*(a + b*x)^(1 + n))/(3*a^2*Sqrt[x]) - (b*(1 - 2*n)*(1 + 2*n)*Sqrt[-((b*x)/a)]*(a + b*x)^(1 + n)*Hypergeometric2F1[1/2, 1 + n, 2 + n, (a + b*x)/a])/(3*a^2*(1 + n)*Sqrt[x])}


{x^(-1 + n)*(a + b*x)^(-1 - n), x, 1, x^n/(a*n*(a + b*x)^n)}

{x^(-3 - n)*(a + b*x)^n, x, 2, -((x^(-2 - n)*(a + b*x)^(1 + n))/(a*(2 + n))) + (b*x^(-1 - n)*(a + b*x)^(1 + n))/(a^2*(1 + n)*(2 + n))}
{x^(2*n - 3*(1 + n))*(a + b*x)^n, x, 2, -((x^(-2 - n)*(a + b*x)^(1 + n))/(a*(2 + n))) + (b*x^(-1 - n)*(a + b*x)^(1 + n))/(a^2*(1 + n)*(2 + n))}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x))^n*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x))^n*)


{1/(Sqrt[-a] + e*(c + d*x)), x, 2, Log[Sqrt[-a] + e*(c + d*x)]/(d*e)}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x))^(n/2)*)


{(c + d*(a + b*x))^(5/2), x, 2, (2*(c + d*(a + b*x))^(7/2))/(7*b*d)}
{(c + d*(a + b*x))^(3/2), x, 2, (2*(c + d*(a + b*x))^(5/2))/(5*b*d)}
{(c + d*(a + b*x))^(1/2), x, 2, (2*(c + d*(a + b*x))^(3/2))/(3*b*d)}
{1/(c + d*(a + b*x))^(1/2), x, 2, (2*Sqrt[c + d*(a + b*x)])/(b*d)}
{1/(c + d*(a + b*x))^(3/2), x, 2, -(2/(b*d*Sqrt[c + d*(a + b*x)]))}
{1/(c + d*(a + b*x))^(5/2), x, 2, -(2/(3*b*d*(c + d*(a + b*x))^(3/2)))}


(* ::Title:: *)
(*Integrands of the form (a+b x)^m (c+d x)^n*)


(* ::Section::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^n*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^n*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{(a + b*x)^m*(c + d*x), x, 2, ((b*c - a*d)*(a + b*x)^(1 + m))/(b^2*(1 + m)) + (d*(a + b*x)^(2 + m))/(b^2*(2 + m))}

{(a + b*x)^4*(c + d*x), x, 2, ((b*c - a*d)*(a + b*x)^5)/(5*b^2) + (d*(a + b*x)^6)/(6*b^2)}
{(a + b*x)^3*(c + d*x), x, 2, ((b*c - a*d)*(a + b*x)^4)/(4*b^2) + (d*(a + b*x)^5)/(5*b^2)}
{(a + b*x)^2*(c + d*x), x, 2, ((b*c - a*d)*(a + b*x)^3)/(3*b^2) + (d*(a + b*x)^4)/(4*b^2)}

{(a + b*x)^1*(c + d*x), x, 2, a*c*x + (1/2)*(b*c + a*d)*x^2 + (1/3)*b*d*x^3}
{(a + b*x)^0*(c + d*x), x, 1, c*x + (d*x^2)/2}

{(c + d*x)/(a + b*x)^1, x, 2, (d*x)/b + ((b*c - a*d)*Log[a + b*x])/b^2}
{(c + d*x)/(a + b*x)^2, x, 2, -((b*c - a*d)/(b^2*(a + b*x))) + (d*Log[a + b*x])/b^2}

{(c + d*x)/(a + b*x)^3, x, 1, -((c + d*x)^2/(2*(b*c - a*d)*(a + b*x)^2))}

{(c + d*x)/(a + b*x)^4, x, 2, -((b*c - a*d)/(3*b^2*(a + b*x)^3)) - d/(2*b^2*(a + b*x)^2)}
{(c + d*x)/(a + b*x)^5, x, 2, -((b*c - a*d)/(4*b^2*(a + b*x)^4)) - d/(3*b^2*(a + b*x)^3)}


{(a + b*x)^m*(c + d*x)^2, x, 2, ((b*c - a*d)^2*(a + b*x)^(1 + m))/(b^3*(1 + m)) + (2*d*(b*c - a*d)*(a + b*x)^(2 + m))/(b^3*(2 + m)) + (d^2*(a + b*x)^(3 + m))/(b^3*(3 + m))}

{(a + b*x)^4*(c + d*x)^2, x, 2, ((b*c - a*d)^2*(a + b*x)^5)/(5*b^3) + (d*(b*c - a*d)*(a + b*x)^6)/(3*b^3) + (d^2*(a + b*x)^7)/(7*b^3)}
{(a + b*x)^3*(c + d*x)^2, x, 2, ((b*c - a*d)^2*(a + b*x)^4)/(4*b^3) + (2*d*(b*c - a*d)*(a + b*x)^5)/(5*b^3) + (d^2*(a + b*x)^6)/(6*b^3)}
{(a + b*x)^2*(c + d*x)^2, x, 2, ((b*c - a*d)^2*(a + b*x)^3)/(3*b^3) + (d*(b*c - a*d)*(a + b*x)^4)/(2*b^3) + (d^2*(a + b*x)^5)/(5*b^3)}

{(a + b*x)^1*(c + d*x)^2, x, 2, -(((b*c - a*d)*(c + d*x)^3)/(3*d^2)) + (b*(c + d*x)^4)/(4*d^2)}
{(a + b*x)^0*(c + d*x)^2, x, 1, (c + d*x)^3/(3*d)}

{(c + d*x)^2/(a + b*x)^1, x, 2, (d*(b*c - a*d)*x)/b^2 + (c + d*x)^2/(2*b) + ((b*c - a*d)^2*Log[a + b*x])/b^3}
{(c + d*x)^2/(a + b*x)^2, x, 2, (d^2*x)/b^2 - (b*c - a*d)^2/(b^3*(a + b*x)) + (2*d*(b*c - a*d)*Log[a + b*x])/b^3}
{(c + d*x)^2/(a + b*x)^3, x, 2, -((b*c - a*d)^2/(2*b^3*(a + b*x)^2)) - (2*d*(b*c - a*d))/(b^3*(a + b*x)) + (d^2*Log[a + b*x])/b^3}

{(c + d*x)^2/(a + b*x)^4, x, 1, -((c + d*x)^3/(3*(b*c - a*d)*(a + b*x)^3))}

{(c + d*x)^2/(a + b*x)^5, x, 2, -((b*c - a*d)^2/(4*b^3*(a + b*x)^4)) - (2*d*(b*c - a*d))/(3*b^3*(a + b*x)^3) - d^2/(2*b^3*(a + b*x)^2)}
{(c + d*x)^2/(a + b*x)^6, x, 2, -((b*c - a*d)^2/(5*b^3*(a + b*x)^5)) - (d*(b*c - a*d))/(2*b^3*(a + b*x)^4) - d^2/(3*b^3*(a + b*x)^3)}
{(c + d*x)^2/(a + b*x)^7, x, 2, -((b*c - a*d)^2/(6*b^3*(a + b*x)^6)) - (2*d*(b*c - a*d))/(5*b^3*(a + b*x)^5) - d^2/(4*b^3*(a + b*x)^4)}


{(a + b*x)^m*(c + d*x)^3, x, 2, ((b*c - a*d)^3*(a + b*x)^(1 + m))/(b^4*(1 + m)) + (3*d*(b*c - a*d)^2*(a + b*x)^(2 + m))/(b^4*(2 + m)) + (3*d^2*(b*c - a*d)*(a + b*x)^(3 + m))/(b^4*(3 + m)) + (d^3*(a + b*x)^(4 + m))/(b^4*(4 + m))}

{(a + b*x)^5*(c + d*x)^3, x, 2, ((b*c - a*d)^3*(a + b*x)^6)/(6*b^4) + (3*d*(b*c - a*d)^2*(a + b*x)^7)/(7*b^4) + (3*d^2*(b*c - a*d)*(a + b*x)^8)/(8*b^4) + (d^3*(a + b*x)^9)/(9*b^4)}
{(a + b*x)^4*(c + d*x)^3, x, 2, ((b*c - a*d)^3*(a + b*x)^5)/(5*b^4) + (d*(b*c - a*d)^2*(a + b*x)^6)/(2*b^4) + (3*d^2*(b*c - a*d)*(a + b*x)^7)/(7*b^4) + (d^3*(a + b*x)^8)/(8*b^4)}
{(a + b*x)^3*(c + d*x)^3, x, 2, ((b*c - a*d)^3*(a + b*x)^4)/(4*b^4) + (3*d*(b*c - a*d)^2*(a + b*x)^5)/(5*b^4) + (d^2*(b*c - a*d)*(a + b*x)^6)/(2*b^4) + (d^3*(a + b*x)^7)/(7*b^4)}

{(a + b*x)^2*(c + d*x)^3, x, 2, ((b*c - a*d)^2*(c + d*x)^4)/(4*d^3) - (2*b*(b*c - a*d)*(c + d*x)^5)/(5*d^3) + (b^2*(c + d*x)^6)/(6*d^3)}
{(a + b*x)^1*(c + d*x)^3, x, 2, -(((b*c - a*d)*(c + d*x)^4)/(4*d^2)) + (b*(c + d*x)^5)/(5*d^2)}
{(a + b*x)^0*(c + d*x)^3, x, 1, (c + d*x)^4/(4*d)}

{(c + d*x)^3/(a + b*x)^1, x, 2, (d*(b*c - a*d)^2*x)/b^3 + ((b*c - a*d)*(c + d*x)^2)/(2*b^2) + (c + d*x)^3/(3*b) + ((b*c - a*d)^3*Log[a + b*x])/b^4}
{(c + d*x)^3/(a + b*x)^2, x, 2, (d^2*(3*b*c - 2*a*d)*x)/b^3 + (d^3*x^2)/(2*b^2) - (b*c - a*d)^3/(b^4*(a + b*x)) + (3*d*(b*c - a*d)^2*Log[a + b*x])/b^4}
{(c + d*x)^3/(a + b*x)^3, x, 2, (d^3*x)/b^3 - (b*c - a*d)^3/(2*b^4*(a + b*x)^2) - (3*d*(b*c - a*d)^2)/(b^4*(a + b*x)) + (3*d^2*(b*c - a*d)*Log[a + b*x])/b^4}
{(c + d*x)^3/(a + b*x)^4, x, 2, -((b*c - a*d)^3/(3*b^4*(a + b*x)^3)) - (3*d*(b*c - a*d)^2)/(2*b^4*(a + b*x)^2) - (3*d^2*(b*c - a*d))/(b^4*(a + b*x)) + (d^3*Log[a + b*x])/b^4}

{(c + d*x)^3/(a + b*x)^5, x, 1, -((c + d*x)^4/(4*(b*c - a*d)*(a + b*x)^4))}
{(c + d*x)^3/(a + b*x)^6, x, 2, -((c + d*x)^4/(5*(b*c - a*d)*(a + b*x)^5)) + (d*(c + d*x)^4)/(20*(b*c - a*d)^2*(a + b*x)^4)}

{(c + d*x)^3/(a + b*x)^7, x, 2, -((b*c - a*d)^3/(6*b^4*(a + b*x)^6)) - (3*d*(b*c - a*d)^2)/(5*b^4*(a + b*x)^5) - (3*d^2*(b*c - a*d))/(4*b^4*(a + b*x)^4) - d^3/(3*b^4*(a + b*x)^3)}
{(c + d*x)^3/(a + b*x)^8, x, 2, -((b*c - a*d)^3/(7*b^4*(a + b*x)^7)) - (d*(b*c - a*d)^2)/(2*b^4*(a + b*x)^6) - (3*d^2*(b*c - a*d))/(5*b^4*(a + b*x)^5) - d^3/(4*b^4*(a + b*x)^4)}
{(c + d*x)^3/(a + b*x)^9, x, 2, -((b*c - a*d)^3/(8*b^4*(a + b*x)^8)) - (3*d*(b*c - a*d)^2)/(7*b^4*(a + b*x)^7) - (d^2*(b*c - a*d))/(2*b^4*(a + b*x)^6) - d^3/(5*b^4*(a + b*x)^5)}


{(a + b*x)^m*(c + d*x)^7, x, 2, ((b*c - a*d)^7*(a + b*x)^(1 + m))/(b^8*(1 + m)) + (7*d*(b*c - a*d)^6*(a + b*x)^(2 + m))/(b^8*(2 + m)) + (21*d^2*(b*c - a*d)^5*(a + b*x)^(3 + m))/(b^8*(3 + m)) + (35*d^3*(b*c - a*d)^4*(a + b*x)^(4 + m))/(b^8*(4 + m)) + (35*d^4*(b*c - a*d)^3*(a + b*x)^(5 + m))/(b^8*(5 + m)) + (21*d^5*(b*c - a*d)^2*(a + b*x)^(6 + m))/(b^8*(6 + m)) + (7*d^6*(b*c - a*d)*(a + b*x)^(7 + m))/(b^8*(7 + m)) + (d^7*(a + b*x)^(8 + m))/(b^8*(8 + m))}

{(a + b*x)^9*(c + d*x)^7, x, 2, ((b*c - a*d)^7*(a + b*x)^10)/(10*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^11)/(11*b^8) + (7*d^2*(b*c - a*d)^5*(a + b*x)^12)/(4*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^13)/(13*b^8) + (5*d^4*(b*c - a*d)^3*(a + b*x)^14)/(2*b^8) + (7*d^5*(b*c - a*d)^2*(a + b*x)^15)/(5*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^16)/(16*b^8) + (d^7*(a + b*x)^17)/(17*b^8)}
{(a + b*x)^8*(c + d*x)^7, x, 2, ((b*c - a*d)^7*(a + b*x)^9)/(9*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^10)/(10*b^8) + (21*d^2*(b*c - a*d)^5*(a + b*x)^11)/(11*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^12)/(12*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^13)/(13*b^8) + (3*d^5*(b*c - a*d)^2*(a + b*x)^14)/(2*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^15)/(15*b^8) + (d^7*(a + b*x)^16)/(16*b^8)}
{(a + b*x)^7*(c + d*x)^7, x, 2, ((b*c - a*d)^7*(a + b*x)^8)/(8*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^9)/(9*b^8) + (21*d^2*(b*c - a*d)^5*(a + b*x)^10)/(10*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^11)/(11*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^12)/(12*b^8) + (21*d^5*(b*c - a*d)^2*(a + b*x)^13)/(13*b^8) + (d^6*(b*c - a*d)*(a + b*x)^14)/(2*b^8) + (d^7*(a + b*x)^15)/(15*b^8)}

{(a + b*x)^6*(c + d*x)^7, x, 2, ((b*c - a*d)^6*(c + d*x)^8)/(8*d^7) - (2*b*(b*c - a*d)^5*(c + d*x)^9)/(3*d^7) + (3*b^2*(b*c - a*d)^4*(c + d*x)^10)/(2*d^7) - (20*b^3*(b*c - a*d)^3*(c + d*x)^11)/(11*d^7) + (5*b^4*(b*c - a*d)^2*(c + d*x)^12)/(4*d^7) - (6*b^5*(b*c - a*d)*(c + d*x)^13)/(13*d^7) + (b^6*(c + d*x)^14)/(14*d^7)}
{(a + b*x)^5*(c + d*x)^7, x, 2, -(((b*c - a*d)^5*(c + d*x)^8)/(8*d^6)) + (5*b*(b*c - a*d)^4*(c + d*x)^9)/(9*d^6) - (b^2*(b*c - a*d)^3*(c + d*x)^10)/d^6 + (10*b^3*(b*c - a*d)^2*(c + d*x)^11)/(11*d^6) - (5*b^4*(b*c - a*d)*(c + d*x)^12)/(12*d^6) + (b^5*(c + d*x)^13)/(13*d^6)}
{(a + b*x)^4*(c + d*x)^7, x, 2, ((b*c - a*d)^4*(c + d*x)^8)/(8*d^5) - (4*b*(b*c - a*d)^3*(c + d*x)^9)/(9*d^5) + (3*b^2*(b*c - a*d)^2*(c + d*x)^10)/(5*d^5) - (4*b^3*(b*c - a*d)*(c + d*x)^11)/(11*d^5) + (b^4*(c + d*x)^12)/(12*d^5)}
{(a + b*x)^3*(c + d*x)^7, x, 2, -(((b*c - a*d)^3*(c + d*x)^8)/(8*d^4)) + (b*(b*c - a*d)^2*(c + d*x)^9)/(3*d^4) - (3*b^2*(b*c - a*d)*(c + d*x)^10)/(10*d^4) + (b^3*(c + d*x)^11)/(11*d^4)}
{(a + b*x)^2*(c + d*x)^7, x, 2, ((b*c - a*d)^2*(c + d*x)^8)/(8*d^3) - (2*b*(b*c - a*d)*(c + d*x)^9)/(9*d^3) + (b^2*(c + d*x)^10)/(10*d^3)}
{(a + b*x)^1*(c + d*x)^7, x, 2, -(((b*c - a*d)*(c + d*x)^8)/(8*d^2)) + (b*(c + d*x)^9)/(9*d^2)}
{(a + b*x)^0*(c + d*x)^7, x, 1, (c + d*x)^8/(8*d)}

{(c + d*x)^7/(a + b*x)^1, x, 2, (d*(b*c - a*d)^6*x)/b^7 + ((b*c - a*d)^5*(c + d*x)^2)/(2*b^6) + ((b*c - a*d)^4*(c + d*x)^3)/(3*b^5) + ((b*c - a*d)^3*(c + d*x)^4)/(4*b^4) + ((b*c - a*d)^2*(c + d*x)^5)/(5*b^3) + ((b*c - a*d)*(c + d*x)^6)/(6*b^2) + (c + d*x)^7/(7*b) + ((b*c - a*d)^7*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^2, x, 2, (21*d^2*(b*c - a*d)^5*x)/b^7 - (b*c - a*d)^7/(b^8*(a + b*x)) + (35*d^3*(b*c - a*d)^4*(a + b*x)^2)/(2*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^3)/(3*b^8) + (21*d^5*(b*c - a*d)^2*(a + b*x)^4)/(4*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^5)/(5*b^8) + (d^7*(a + b*x)^6)/(6*b^8) + (7*d*(b*c - a*d)^6*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^3, x, 2, (35*d^3*(b*c - a*d)^4*x)/b^7 - (b*c - a*d)^7/(2*b^8*(a + b*x)^2) - (7*d*(b*c - a*d)^6)/(b^8*(a + b*x)) + (35*d^4*(b*c - a*d)^3*(a + b*x)^2)/(2*b^8) + (7*d^5*(b*c - a*d)^2*(a + b*x)^3)/b^8 + (7*d^6*(b*c - a*d)*(a + b*x)^4)/(4*b^8) + (d^7*(a + b*x)^5)/(5*b^8) + (21*d^2*(b*c - a*d)^5*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^4, x, 2, (35*d^4*(b*c - a*d)^3*x)/b^7 - (b*c - a*d)^7/(3*b^8*(a + b*x)^3) - (7*d*(b*c - a*d)^6)/(2*b^8*(a + b*x)^2) - (21*d^2*(b*c - a*d)^5)/(b^8*(a + b*x)) + (21*d^5*(b*c - a*d)^2*(a + b*x)^2)/(2*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^3)/(3*b^8) + (d^7*(a + b*x)^4)/(4*b^8) + (35*d^3*(b*c - a*d)^4*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^5, x, 2, (21*d^5*(b*c - a*d)^2*x)/b^7 - (b*c - a*d)^7/(4*b^8*(a + b*x)^4) - (7*d*(b*c - a*d)^6)/(3*b^8*(a + b*x)^3) - (21*d^2*(b*c - a*d)^5)/(2*b^8*(a + b*x)^2) - (35*d^3*(b*c - a*d)^4)/(b^8*(a + b*x)) + (7*d^6*(b*c - a*d)*(a + b*x)^2)/(2*b^8) + (d^7*(a + b*x)^3)/(3*b^8) + (35*d^4*(b*c - a*d)^3*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^6, x, 2, (d^6*(7*b*c - 6*a*d)*x)/b^7 + (d^7*x^2)/(2*b^6) - (b*c - a*d)^7/(5*b^8*(a + b*x)^5) - (7*d*(b*c - a*d)^6)/(4*b^8*(a + b*x)^4) - (7*d^2*(b*c - a*d)^5)/(b^8*(a + b*x)^3) - (35*d^3*(b*c - a*d)^4)/(2*b^8*(a + b*x)^2) - (35*d^4*(b*c - a*d)^3)/(b^8*(a + b*x)) + (21*d^5*(b*c - a*d)^2*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^7, x, 2, (d^7*x)/b^7 - (b*c - a*d)^7/(6*b^8*(a + b*x)^6) - (7*d*(b*c - a*d)^6)/(5*b^8*(a + b*x)^5) - (21*d^2*(b*c - a*d)^5)/(4*b^8*(a + b*x)^4) - (35*d^3*(b*c - a*d)^4)/(3*b^8*(a + b*x)^3) - (35*d^4*(b*c - a*d)^3)/(2*b^8*(a + b*x)^2) - (21*d^5*(b*c - a*d)^2)/(b^8*(a + b*x)) + (7*d^6*(b*c - a*d)*Log[a + b*x])/b^8}
{(c + d*x)^7/(a + b*x)^8, x, 2, -(b*c - a*d)^7/(7*b^8*(a + b*x)^7) - (7*d*(b*c - a*d)^6)/(6*b^8*(a + b*x)^6) - (21*d^2*(b*c - a*d)^5)/(5*b^8*(a + b*x)^5) - (35*d^3*(b*c - a*d)^4)/(4*b^8*(a + b*x)^4) - (35*d^4*(b*c - a*d)^3)/(3*b^8*(a + b*x)^3) - (21*d^5*(b*c - a*d)^2)/(2*b^8*(a + b*x)^2) - (7*d^6*(b*c - a*d))/(b^8*(a + b*x)) + (d^7*Log[a + b*x])/b^8}

{(c + d*x)^7/(a + b*x)^9, x, 1, -((c + d*x)^8/(8*(b*c - a*d)*(a + b*x)^8))}
{(c + d*x)^7/(a + b*x)^10, x, 2, -((c + d*x)^8/(9*(b*c - a*d)*(a + b*x)^9)) + (d*(c + d*x)^8)/(72*(b*c - a*d)^2*(a + b*x)^8)}
{(c + d*x)^7/(a + b*x)^11, x, 3, -((c + d*x)^8/(10*(b*c - a*d)*(a + b*x)^10)) + (d*(c + d*x)^8)/(45*(b*c - a*d)^2*(a + b*x)^9) - (d^2*(c + d*x)^8)/(360*(b*c - a*d)^3*(a + b*x)^8)}
{(c + d*x)^7/(a + b*x)^12, x, 4, -((c + d*x)^8/(11*(b*c - a*d)*(a + b*x)^11)) + (3*d*(c + d*x)^8)/(110*(b*c - a*d)^2*(a + b*x)^10) - (d^2*(c + d*x)^8)/(165*(b*c - a*d)^3*(a + b*x)^9) + (d^3*(c + d*x)^8)/(1320*(b*c - a*d)^4*(a + b*x)^8)}
{(c + d*x)^7/(a + b*x)^13, x, 5, -((c + d*x)^8/(12*(b*c - a*d)*(a + b*x)^12)) + (d*(c + d*x)^8)/(33*(b*c - a*d)^2*(a + b*x)^11) - (d^2*(c + d*x)^8)/(110*(b*c - a*d)^3*(a + b*x)^10) + (d^3*(c + d*x)^8)/(495*(b*c - a*d)^4*(a + b*x)^9) - (d^4*(c + d*x)^8)/(3960*(b*c - a*d)^5*(a + b*x)^8)}
{(c + d*x)^7/(a + b*x)^14, x, 2, -((b*c - a*d)^7/(13*b^8*(a + b*x)^13)) - (7*d*(b*c - a*d)^6)/(12*b^8*(a + b*x)^12) - (21*d^2*(b*c - a*d)^5)/(11*b^8*(a + b*x)^11) - (7*d^3*(b*c - a*d)^4)/(2*b^8*(a + b*x)^10) - (35*d^4*(b*c - a*d)^3)/(9*b^8*(a + b*x)^9) - (21*d^5*(b*c - a*d)^2)/(8*b^8*(a + b*x)^8) - (d^6*(b*c - a*d))/(b^8*(a + b*x)^7) - d^7/(6*b^8*(a + b*x)^6)}

{(c + d*x)^7/(a + b*x)^15, x, 2, -((b*c - a*d)^7/(14*b^8*(a + b*x)^14)) - (7*d*(b*c - a*d)^6)/(13*b^8*(a + b*x)^13) - (7*d^2*(b*c - a*d)^5)/(4*b^8*(a + b*x)^12) - (35*d^3*(b*c - a*d)^4)/(11*b^8*(a + b*x)^11) - (7*d^4*(b*c - a*d)^3)/(2*b^8*(a + b*x)^10) - (7*d^5*(b*c - a*d)^2)/(3*b^8*(a + b*x)^9) - (7*d^6*(b*c - a*d))/(8*b^8*(a + b*x)^8) - d^7/(7*b^8*(a + b*x)^7)}
{(c + d*x)^7/(a + b*x)^16, x, 2, -((b*c - a*d)^7/(15*b^8*(a + b*x)^15)) - (d*(b*c - a*d)^6)/(2*b^8*(a + b*x)^14) - (21*d^2*(b*c - a*d)^5)/(13*b^8*(a + b*x)^13) - (35*d^3*(b*c - a*d)^4)/(12*b^8*(a + b*x)^12) - (35*d^4*(b*c - a*d)^3)/(11*b^8*(a + b*x)^11) - (21*d^5*(b*c - a*d)^2)/(10*b^8*(a + b*x)^10) - (7*d^6*(b*c - a*d))/(9*b^8*(a + b*x)^9) - d^7/(8*b^8*(a + b*x)^8)}


{(a + b*x)^m*(c + d*x)^10, x, 2, ((b*c - a*d)^10*(a + b*x)^(1 + m))/(b^11*(1 + m)) + (10*d*(b*c - a*d)^9*(a + b*x)^(2 + m))/(b^11*(2 + m)) + (45*d^2*(b*c - a*d)^8*(a + b*x)^(3 + m))/(b^11*(3 + m)) + (120*d^3*(b*c - a*d)^7*(a + b*x)^(4 + m))/(b^11*(4 + m)) + (210*d^4*(b*c - a*d)^6*(a + b*x)^(5 + m))/(b^11*(5 + m)) + (252*d^5*(b*c - a*d)^5*(a + b*x)^(6 + m))/(b^11*(6 + m)) + (210*d^6*(b*c - a*d)^4*(a + b*x)^(7 + m))/(b^11*(7 + m)) + (120*d^7*(b*c - a*d)^3*(a + b*x)^(8 + m))/(b^11*(8 + m)) + (45*d^8*(b*c - a*d)^2*(a + b*x)^(9 + m))/(b^11*(9 + m)) + (10*d^9*(b*c - a*d)*(a + b*x)^(10 + m))/(b^11*(10 + m)) + (d^10*(a + b*x)^(11 + m))/(b^11*(11 + m))}

{(a + b*x)^12*(c + d*x)^10, x, 2, ((b*c - a*d)^10*(a + b*x)^13)/(13*b^11) + (5*d*(b*c - a*d)^9*(a + b*x)^14)/(7*b^11) + (3*d^2*(b*c - a*d)^8*(a + b*x)^15)/b^11 + (15*d^3*(b*c - a*d)^7*(a + b*x)^16)/(2*b^11) + (210*d^4*(b*c - a*d)^6*(a + b*x)^17)/(17*b^11) + (14*d^5*(b*c - a*d)^5*(a + b*x)^18)/b^11 + (210*d^6*(b*c - a*d)^4*(a + b*x)^19)/(19*b^11) + (6*d^7*(b*c - a*d)^3*(a + b*x)^20)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^21)/(7*b^11) + (5*d^9*(b*c - a*d)*(a + b*x)^22)/(11*b^11) + (d^10*(a + b*x)^23)/(23*b^11)}
{(a + b*x)^11*(c + d*x)^10, x, 2, ((b*c - a*d)^10*(a + b*x)^12)/(12*b^11) + (10*d*(b*c - a*d)^9*(a + b*x)^13)/(13*b^11) + (45*d^2*(b*c - a*d)^8*(a + b*x)^14)/(14*b^11) + (8*d^3*(b*c - a*d)^7*(a + b*x)^15)/b^11 + (105*d^4*(b*c - a*d)^6*(a + b*x)^16)/(8*b^11) + (252*d^5*(b*c - a*d)^5*(a + b*x)^17)/(17*b^11) + (35*d^6*(b*c - a*d)^4*(a + b*x)^18)/(3*b^11) + (120*d^7*(b*c - a*d)^3*(a + b*x)^19)/(19*b^11) + (9*d^8*(b*c - a*d)^2*(a + b*x)^20)/(4*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^21)/(21*b^11) + (d^10*(a + b*x)^22)/(22*b^11)}
{(a + b*x)^10*(c + d*x)^10, x, 2, ((b*c - a*d)^10*(a + b*x)^11)/(11*b^11) + (5*d*(b*c - a*d)^9*(a + b*x)^12)/(6*b^11) + (45*d^2*(b*c - a*d)^8*(a + b*x)^13)/(13*b^11) + (60*d^3*(b*c - a*d)^7*(a + b*x)^14)/(7*b^11) + (14*d^4*(b*c - a*d)^6*(a + b*x)^15)/b^11 + (63*d^5*(b*c - a*d)^5*(a + b*x)^16)/(4*b^11) + (210*d^6*(b*c - a*d)^4*(a + b*x)^17)/(17*b^11) + (20*d^7*(b*c - a*d)^3*(a + b*x)^18)/(3*b^11) + (45*d^8*(b*c - a*d)^2*(a + b*x)^19)/(19*b^11) + (d^9*(b*c - a*d)*(a + b*x)^20)/(2*b^11) + (d^10*(a + b*x)^21)/(21*b^11)}

{(a + b*x)^9*(c + d*x)^10, x, 2, -((b*c - a*d)^9*(c + d*x)^11)/(11*d^10) + (3*b*(b*c - a*d)^8*(c + d*x)^12)/(4*d^10) - (36*b^2*(b*c - a*d)^7*(c + d*x)^13)/(13*d^10) + (6*b^3*(b*c - a*d)^6*(c + d*x)^14)/d^10 - (42*b^4*(b*c - a*d)^5*(c + d*x)^15)/(5*d^10) + (63*b^5*(b*c - a*d)^4*(c + d*x)^16)/(8*d^10) - (84*b^6*(b*c - a*d)^3*(c + d*x)^17)/(17*d^10) + (2*b^7*(b*c - a*d)^2*(c + d*x)^18)/d^10 - (9*b^8*(b*c - a*d)*(c + d*x)^19)/(19*d^10) + (b^9*(c + d*x)^20)/(20*d^10)}
{(a + b*x)^8*(c + d*x)^10, x, 2, ((b*c - a*d)^8*(c + d*x)^11)/(11*d^9) - (2*b*(b*c - a*d)^7*(c + d*x)^12)/(3*d^9) + (28*b^2*(b*c - a*d)^6*(c + d*x)^13)/(13*d^9) - (4*b^3*(b*c - a*d)^5*(c + d*x)^14)/d^9 + (14*b^4*(b*c - a*d)^4*(c + d*x)^15)/(3*d^9) - (7*b^5*(b*c - a*d)^3*(c + d*x)^16)/(2*d^9) + (28*b^6*(b*c - a*d)^2*(c + d*x)^17)/(17*d^9) - (4*b^7*(b*c - a*d)*(c + d*x)^18)/(9*d^9) + (b^8*(c + d*x)^19)/(19*d^9)}
{(a + b*x)^7*(c + d*x)^10, x, 2, -((b*c - a*d)^7*(c + d*x)^11)/(11*d^8) + (7*b*(b*c - a*d)^6*(c + d*x)^12)/(12*d^8) - (21*b^2*(b*c - a*d)^5*(c + d*x)^13)/(13*d^8) + (5*b^3*(b*c - a*d)^4*(c + d*x)^14)/(2*d^8) - (7*b^4*(b*c - a*d)^3*(c + d*x)^15)/(3*d^8) + (21*b^5*(b*c - a*d)^2*(c + d*x)^16)/(16*d^8) - (7*b^6*(b*c - a*d)*(c + d*x)^17)/(17*d^8) + (b^7*(c + d*x)^18)/(18*d^8)}
{(a + b*x)^6*(c + d*x)^10, x, 2, ((b*c - a*d)^6*(c + d*x)^11)/(11*d^7) - (b*(b*c - a*d)^5*(c + d*x)^12)/(2*d^7) + (15*b^2*(b*c - a*d)^4*(c + d*x)^13)/(13*d^7) - (10*b^3*(b*c - a*d)^3*(c + d*x)^14)/(7*d^7) + (b^4*(b*c - a*d)^2*(c + d*x)^15)/d^7 - (3*b^5*(b*c - a*d)*(c + d*x)^16)/(8*d^7) + (b^6*(c + d*x)^17)/(17*d^7)}
{(a + b*x)^5*(c + d*x)^10, x, 2, -((b*c - a*d)^5*(c + d*x)^11)/(11*d^6) + (5*b*(b*c - a*d)^4*(c + d*x)^12)/(12*d^6) - (10*b^2*(b*c - a*d)^3*(c + d*x)^13)/(13*d^6) + (5*b^3*(b*c - a*d)^2*(c + d*x)^14)/(7*d^6) - (b^4*(b*c - a*d)*(c + d*x)^15)/(3*d^6) + (b^5*(c + d*x)^16)/(16*d^6)}
{(a + b*x)^4*(c + d*x)^10, x, 2, ((b*c - a*d)^4*(c + d*x)^11)/(11*d^5) - (b*(b*c - a*d)^3*(c + d*x)^12)/(3*d^5) + (6*b^2*(b*c - a*d)^2*(c + d*x)^13)/(13*d^5) - (2*b^3*(b*c - a*d)*(c + d*x)^14)/(7*d^5) + (b^4*(c + d*x)^15)/(15*d^5)}
{(a + b*x)^3*(c + d*x)^10, x, 2, -((b*c - a*d)^3*(c + d*x)^11)/(11*d^4) + (b*(b*c - a*d)^2*(c + d*x)^12)/(4*d^4) - (3*b^2*(b*c - a*d)*(c + d*x)^13)/(13*d^4) + (b^3*(c + d*x)^14)/(14*d^4)}
{(a + b*x)^2*(c + d*x)^10, x, 2, ((b*c - a*d)^2*(c + d*x)^11)/(11*d^3) - (b*(b*c - a*d)*(c + d*x)^12)/(6*d^3) + (b^2*(c + d*x)^13)/(13*d^3)}
{(a + b*x)^1*(c + d*x)^10, x, 2, -((b*c - a*d)*(c + d*x)^11)/(11*d^2) + (b*(c + d*x)^12)/(12*d^2)}
{(a + b*x)^0*(c + d*x)^10, x, 1, (c + d*x)^11/(11*d)}

{(c + d*x)^10/(a + b*x)^1, x, 2, (d*(b*c - a*d)^9*x)/b^10 + ((b*c - a*d)^8*(c + d*x)^2)/(2*b^9) + ((b*c - a*d)^7*(c + d*x)^3)/(3*b^8) + ((b*c - a*d)^6*(c + d*x)^4)/(4*b^7) + ((b*c - a*d)^5*(c + d*x)^5)/(5*b^6) + ((b*c - a*d)^4*(c + d*x)^6)/(6*b^5) + ((b*c - a*d)^3*(c + d*x)^7)/(7*b^4) + ((b*c - a*d)^2*(c + d*x)^8)/(8*b^3) + ((b*c - a*d)*(c + d*x)^9)/(9*b^2) + (c + d*x)^10/(10*b) + ((b*c - a*d)^10*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^2, x, 2, (45*d^2*(b*c - a*d)^8*x)/b^10 - (b*c - a*d)^10/(b^11*(a + b*x)) + (60*d^3*(b*c - a*d)^7*(a + b*x)^2)/b^11 + (70*d^4*(b*c - a*d)^6*(a + b*x)^3)/b^11 + (63*d^5*(b*c - a*d)^5*(a + b*x)^4)/b^11 + (42*d^6*(b*c - a*d)^4*(a + b*x)^5)/b^11 + (20*d^7*(b*c - a*d)^3*(a + b*x)^6)/b^11 + (45*d^8*(b*c - a*d)^2*(a + b*x)^7)/(7*b^11) + (5*d^9*(b*c - a*d)*(a + b*x)^8)/(4*b^11) + (d^10*(a + b*x)^9)/(9*b^11) + (10*d*(b*c - a*d)^9*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^3, x, 2, (120*d^3*(b*c - a*d)^7*x)/b^10 - (b*c - a*d)^10/(2*b^11*(a + b*x)^2) - (10*d*(b*c - a*d)^9)/(b^11*(a + b*x)) + (105*d^4*(b*c - a*d)^6*(a + b*x)^2)/b^11 + (84*d^5*(b*c - a*d)^5*(a + b*x)^3)/b^11 + (105*d^6*(b*c - a*d)^4*(a + b*x)^4)/(2*b^11) + (24*d^7*(b*c - a*d)^3*(a + b*x)^5)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^6)/(2*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^7)/(7*b^11) + (d^10*(a + b*x)^8)/(8*b^11) + (45*d^2*(b*c - a*d)^8*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^4, x, 2, (210*d^4*(b*c - a*d)^6*x)/b^10 - (b*c - a*d)^10/(3*b^11*(a + b*x)^3) - (5*d*(b*c - a*d)^9)/(b^11*(a + b*x)^2) - (45*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)) + (126*d^5*(b*c - a*d)^5*(a + b*x)^2)/b^11 + (70*d^6*(b*c - a*d)^4*(a + b*x)^3)/b^11 + (30*d^7*(b*c - a*d)^3*(a + b*x)^4)/b^11 + (9*d^8*(b*c - a*d)^2*(a + b*x)^5)/b^11 + (5*d^9*(b*c - a*d)*(a + b*x)^6)/(3*b^11) + (d^10*(a + b*x)^7)/(7*b^11) + (120*d^3*(b*c - a*d)^7*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^5, x, 2, (252*d^5*(b*c - a*d)^5*x)/b^10 - (b*c - a*d)^10/(4*b^11*(a + b*x)^4) - (10*d*(b*c - a*d)^9)/(3*b^11*(a + b*x)^3) - (45*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^2) - (120*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)) + (105*d^6*(b*c - a*d)^4*(a + b*x)^2)/b^11 + (40*d^7*(b*c - a*d)^3*(a + b*x)^3)/b^11 + (45*d^8*(b*c - a*d)^2*(a + b*x)^4)/(4*b^11) + (2*d^9*(b*c - a*d)*(a + b*x)^5)/b^11 + (d^10*(a + b*x)^6)/(6*b^11) + (210*d^4*(b*c - a*d)^6*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^6, x, 2, (210*d^6*(b*c - a*d)^4*x)/b^10 - (b*c - a*d)^10/(5*b^11*(a + b*x)^5) - (5*d*(b*c - a*d)^9)/(2*b^11*(a + b*x)^4) - (15*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)^3) - (60*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^2) - (210*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)) + (60*d^7*(b*c - a*d)^3*(a + b*x)^2)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^3)/b^11 + (5*d^9*(b*c - a*d)*(a + b*x)^4)/(2*b^11) + (d^10*(a + b*x)^5)/(5*b^11) + (252*d^5*(b*c - a*d)^5*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^7, x, 2, (120*d^7*(b*c - a*d)^3*x)/b^10 - (b*c - a*d)^10/(6*b^11*(a + b*x)^6) - (2*d*(b*c - a*d)^9)/(b^11*(a + b*x)^5) - (45*d^2*(b*c - a*d)^8)/(4*b^11*(a + b*x)^4) - (40*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^3) - (105*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^2) - (252*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)) + (45*d^8*(b*c - a*d)^2*(a + b*x)^2)/(2*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^3)/(3*b^11) + (d^10*(a + b*x)^4)/(4*b^11) + (210*d^6*(b*c - a*d)^4*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^8, x, 2, (45*d^8*(b*c - a*d)^2*x)/b^10 - (b*c - a*d)^10/(7*b^11*(a + b*x)^7) - (5*d*(b*c - a*d)^9)/(3*b^11*(a + b*x)^6) - (9*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)^5) - (30*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^4) - (70*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^3) - (126*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^2) - (210*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)) + (5*d^9*(b*c - a*d)*(a + b*x)^2)/b^11 + (d^10*(a + b*x)^3)/(3*b^11) + (120*d^7*(b*c - a*d)^3*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^9, x, 2, (d^9*(10*b*c - 9*a*d)*x)/b^10 + (d^10*x^2)/(2*b^9) - (b*c - a*d)^10/(8*b^11*(a + b*x)^8) - (10*d*(b*c - a*d)^9)/(7*b^11*(a + b*x)^7) - (15*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^6) - (24*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^5) - (105*d^4*(b*c - a*d)^6)/(2*b^11*(a + b*x)^4) - (84*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^3) - (105*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^2) - (120*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)) + (45*d^8*(b*c - a*d)^2*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^10, x, 2, (d^10*x)/b^10 - (b*c - a*d)^10/(9*b^11*(a + b*x)^9) - (5*d*(b*c - a*d)^9)/(4*b^11*(a + b*x)^8) - (45*d^2*(b*c - a*d)^8)/(7*b^11*(a + b*x)^7) - (20*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^6) - (42*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^5) - (63*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^4) - (70*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^3) - (60*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^2) - (45*d^8*(b*c - a*d)^2)/(b^11*(a + b*x)) + (10*d^9*(b*c - a*d)*Log[a + b*x])/b^11}
{(c + d*x)^10/(a + b*x)^11, x, 2, -(b*c - a*d)^10/(10*b^11*(a + b*x)^10) - (10*d*(b*c - a*d)^9)/(9*b^11*(a + b*x)^9) - (45*d^2*(b*c - a*d)^8)/(8*b^11*(a + b*x)^8) - (120*d^3*(b*c - a*d)^7)/(7*b^11*(a + b*x)^7) - (35*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^6) - (252*d^5*(b*c - a*d)^5)/(5*b^11*(a + b*x)^5) - (105*d^6*(b*c - a*d)^4)/(2*b^11*(a + b*x)^4) - (40*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^3) - (45*d^8*(b*c - a*d)^2)/(2*b^11*(a + b*x)^2) - (10*d^9*(b*c - a*d))/(b^11*(a + b*x)) + (d^10*Log[a + b*x])/b^11}

{(c + d*x)^10/(a + b*x)^12, x, 1, -(c + d*x)^11/(11*(b*c - a*d)*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^13, x, 2, -((c + d*x)^11/(12*(b*c - a*d)*(a + b*x)^12)) + (d*(c + d*x)^11)/(132*(b*c - a*d)^2*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^14, x, 3, -((c + d*x)^11/(13*(b*c - a*d)*(a + b*x)^13)) + (d*(c + d*x)^11)/(78*(b*c - a*d)^2*(a + b*x)^12) - (d^2*(c + d*x)^11)/(858*(b*c - a*d)^3*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^15, x, 4, -((c + d*x)^11/(14*(b*c - a*d)*(a + b*x)^14)) + (3*d*(c + d*x)^11)/(182*(b*c - a*d)^2*(a + b*x)^13) - (d^2*(c + d*x)^11)/(364*(b*c - a*d)^3*(a + b*x)^12) + (d^3*(c + d*x)^11)/(4004*(b*c - a*d)^4*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^16, x, 5, -((c + d*x)^11/(15*(b*c - a*d)*(a + b*x)^15)) + (2*d*(c + d*x)^11)/(105*(b*c - a*d)^2*(a + b*x)^14) - (2*d^2*(c + d*x)^11)/(455*(b*c - a*d)^3*(a + b*x)^13) + (d^3*(c + d*x)^11)/(1365*(b*c - a*d)^4*(a + b*x)^12) - (d^4*(c + d*x)^11)/(15015*(b*c - a*d)^5*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^17, x, 6, -((c + d*x)^11/(16*(b*c - a*d)*(a + b*x)^16)) + (d*(c + d*x)^11)/(48*(b*c - a*d)^2*(a + b*x)^15) - (d^2*(c + d*x)^11)/(168*(b*c - a*d)^3*(a + b*x)^14) + (d^3*(c + d*x)^11)/(728*(b*c - a*d)^4*(a + b*x)^13) - (d^4*(c + d*x)^11)/(4368*(b*c - a*d)^5*(a + b*x)^12) + (d^5*(c + d*x)^11)/(48048*(b*c - a*d)^6*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^18, x, 7, -((c + d*x)^11/(17*(b*c - a*d)*(a + b*x)^17)) + (3*d*(c + d*x)^11)/(136*(b*c - a*d)^2*(a + b*x)^16) - (d^2*(c + d*x)^11)/(136*(b*c - a*d)^3*(a + b*x)^15) + (d^3*(c + d*x)^11)/(476*(b*c - a*d)^4*(a + b*x)^14) - (3*d^4*(c + d*x)^11)/(6188*(b*c - a*d)^5*(a + b*x)^13) + (d^5*(c + d*x)^11)/(12376*(b*c - a*d)^6*(a + b*x)^12) - (d^6*(c + d*x)^11)/(136136*(b*c - a*d)^7*(a + b*x)^11)}
{(c + d*x)^10/(a + b*x)^19, x, 8, -((c + d*x)^11/(18*(b*c - a*d)*(a + b*x)^18)) + (7*d*(c + d*x)^11)/(306*(b*c - a*d)^2*(a + b*x)^17) - (7*d^2*(c + d*x)^11)/(816*(b*c - a*d)^3*(a + b*x)^16) + (7*d^3*(c + d*x)^11)/(2448*(b*c - a*d)^4*(a + b*x)^15) - (d^4*(c + d*x)^11)/(1224*(b*c - a*d)^5*(a + b*x)^14) + (d^5*(c + d*x)^11)/(5304*(b*c - a*d)^6*(a + b*x)^13) - (d^6*(c + d*x)^11)/(31824*(b*c - a*d)^7*(a + b*x)^12) + (d^7*(c + d*x)^11)/(350064*(b*c - a*d)^8*(a + b*x)^11)}

{(c + d*x)^10/(a + b*x)^20, x, 2, -(b*c - a*d)^10/(19*b^11*(a + b*x)^19) - (5*d*(b*c - a*d)^9)/(9*b^11*(a + b*x)^18) - (45*d^2*(b*c - a*d)^8)/(17*b^11*(a + b*x)^17) - (15*d^3*(b*c - a*d)^7)/(2*b^11*(a + b*x)^16) - (14*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^15) - (18*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^14) - (210*d^6*(b*c - a*d)^4)/(13*b^11*(a + b*x)^13) - (10*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^12) - (45*d^8*(b*c - a*d)^2)/(11*b^11*(a + b*x)^11) - (d^9*(b*c - a*d))/(b^11*(a + b*x)^10) - d^10/(9*b^11*(a + b*x)^9)}
{(c + d*x)^10/(a + b*x)^21, x, 2, -((b*c - a*d)^10/(20*b^11*(a + b*x)^20)) - (10*d*(b*c - a*d)^9)/(19*b^11*(a + b*x)^19) - (5*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^18) - (120*d^3*(b*c - a*d)^7)/(17*b^11*(a + b*x)^17) - (105*d^4*(b*c - a*d)^6)/(8*b^11*(a + b*x)^16) - (84*d^5*(b*c - a*d)^5)/(5*b^11*(a + b*x)^15) - (15*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^14) - (120*d^7*(b*c - a*d)^3)/(13*b^11*(a + b*x)^13) - (15*d^8*(b*c - a*d)^2)/(4*b^11*(a + b*x)^12) - (10*d^9*(b*c - a*d))/(11*b^11*(a + b*x)^11) - d^10/(10*b^11*(a + b*x)^10)}
{(c + d*x)^10/(a + b*x)^22, x, 2, -((b*c - a*d)^10/(21*b^11*(a + b*x)^21)) - (d*(b*c - a*d)^9)/(2*b^11*(a + b*x)^20) - (45*d^2*(b*c - a*d)^8)/(19*b^11*(a + b*x)^19) - (20*d^3*(b*c - a*d)^7)/(3*b^11*(a + b*x)^18) - (210*d^4*(b*c - a*d)^6)/(17*b^11*(a + b*x)^17) - (63*d^5*(b*c - a*d)^5)/(4*b^11*(a + b*x)^16) - (14*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^15) - (60*d^7*(b*c - a*d)^3)/(7*b^11*(a + b*x)^14) - (45*d^8*(b*c - a*d)^2)/(13*b^11*(a + b*x)^13) - (5*d^9*(b*c - a*d))/(6*b^11*(a + b*x)^12) - d^10/(11*b^11*(a + b*x)^11)}


(* {(a + b*x)^m*(c + d*x)^15, x, 2, ((b*c - a*d)^15*(a + b*x)^(1 + m))/(b^16*(1 + m)) + (15*d*(b*c - a*d)^14*(a + b*x)^(2 + m))/(b^16*(2 + m)) + (105*d^2*(b*c - a*d)^13*(a + b*x)^(3 + m))/(b^16*(3 + m)) + (455*d^3*(b*c - a*d)^12*(a + b*x)^(4 + m))/(b^16*(4 + m)) + (1365*d^4*(b*c - a*d)^11*(a + b*x)^(5 + m))/(b^16*(5 + m)) + (3003*d^5*(b*c - a*d)^10*(a + b*x)^(6 + m))/(b^16*(6 + m)) + (5005*d^6*(b*c - a*d)^9*(a + b*x)^(7 + m))/(b^16*(7 + m)) + (6435*d^7*(b*c - a*d)^8*(a + b*x)^(8 + m))/(b^16*(8 + m)) + (6435*d^8*(b*c - a*d)^7*(a + b*x)^(9 + m))/(b^16*(9 + m)) + (5005*d^9*(b*c - a*d)^6*(a + b*x)^(10 + m))/(b^16*(10 + m)) + (3003*d^10*(b*c - a*d)^5*(a + b*x)^(11 + m))/(b^16*(11 + m)) + (1365*d^11*(b*c - a*d)^4*(a + b*x)^(12 + m))/(b^16*(12 + m)) + (455*d^12*(b*c - a*d)^3*(a + b*x)^(13 + m))/(b^16*(13 + m)) + (105*d^13*(b*c - a*d)^2*(a + b*x)^(14 + m))/(b^16*(14 + m)) + (15*d^14*(b*c - a*d)*(a + b*x)^(15 + m))/(b^16*(15 + m)) + (d^15*(a + b*x)^(16 + m))/(b^16*(16 + m))}

{(a + b*x)^17*(c + d*x)^15, x, 2, ((b*c - a*d)^15*(a + b*x)^18)/(18*b^16) + (15*d*(b*c - a*d)^14*(a + b*x)^19)/(19*b^16) + (21*d^2*(b*c - a*d)^13*(a + b*x)^20)/(4*b^16) + (65*d^3*(b*c - a*d)^12*(a + b*x)^21)/(3*b^16) + (1365*d^4*(b*c - a*d)^11*(a + b*x)^22)/(22*b^16) + (3003*d^5*(b*c - a*d)^10*(a + b*x)^23)/(23*b^16) + (5005*d^6*(b*c - a*d)^9*(a + b*x)^24)/(24*b^16) + (1287*d^7*(b*c - a*d)^8*(a + b*x)^25)/(5*b^16) + (495*d^8*(b*c - a*d)^7*(a + b*x)^26)/(2*b^16) + (5005*d^9*(b*c - a*d)^6*(a + b*x)^27)/(27*b^16) + (429*d^10*(b*c - a*d)^5*(a + b*x)^28)/(4*b^16) + (1365*d^11*(b*c - a*d)^4*(a + b*x)^29)/(29*b^16) + (91*d^12*(b*c - a*d)^3*(a + b*x)^30)/(6*b^16) + (105*d^13*(b*c - a*d)^2*(a + b*x)^31)/(31*b^16) + (15*d^14*(b*c - a*d)*(a + b*x)^32)/(32*b^16) + (d^15*(a + b*x)^33)/(33*b^16)}
{(a + b*x)^16*(c + d*x)^15, x, 2, ((b*c - a*d)^15*(a + b*x)^17)/(17*b^16) + (5*d*(b*c - a*d)^14*(a + b*x)^18)/(6*b^16) + (105*d^2*(b*c - a*d)^13*(a + b*x)^19)/(19*b^16) + (91*d^3*(b*c - a*d)^12*(a + b*x)^20)/(4*b^16) + (65*d^4*(b*c - a*d)^11*(a + b*x)^21)/b^16 + (273*d^5*(b*c - a*d)^10*(a + b*x)^22)/(2*b^16) + (5005*d^6*(b*c - a*d)^9*(a + b*x)^23)/(23*b^16) + (2145*d^7*(b*c - a*d)^8*(a + b*x)^24)/(8*b^16) + (1287*d^8*(b*c - a*d)^7*(a + b*x)^25)/(5*b^16) + (385*d^9*(b*c - a*d)^6*(a + b*x)^26)/(2*b^16) + (1001*d^10*(b*c - a*d)^5*(a + b*x)^27)/(9*b^16) + (195*d^11*(b*c - a*d)^4*(a + b*x)^28)/(4*b^16) + (455*d^12*(b*c - a*d)^3*(a + b*x)^29)/(29*b^16) + (7*d^13*(b*c - a*d)^2*(a + b*x)^30)/(2*b^16) + (15*d^14*(b*c - a*d)*(a + b*x)^31)/(31*b^16) + (d^15*(a + b*x)^32)/(32*b^16)}
{(a + b*x)^15*(c + d*x)^15, x, 2, ((b*c - a*d)^15*(a + b*x)^16)/(16*b^16) + (15*d*(b*c - a*d)^14*(a + b*x)^17)/(17*b^16) + (35*d^2*(b*c - a*d)^13*(a + b*x)^18)/(6*b^16) + (455*d^3*(b*c - a*d)^12*(a + b*x)^19)/(19*b^16) + (273*d^4*(b*c - a*d)^11*(a + b*x)^20)/(4*b^16) + (143*d^5*(b*c - a*d)^10*(a + b*x)^21)/b^16 + (455*d^6*(b*c - a*d)^9*(a + b*x)^22)/(2*b^16) + (6435*d^7*(b*c - a*d)^8*(a + b*x)^23)/(23*b^16) + (2145*d^8*(b*c - a*d)^7*(a + b*x)^24)/(8*b^16) + (1001*d^9*(b*c - a*d)^6*(a + b*x)^25)/(5*b^16) + (231*d^10*(b*c - a*d)^5*(a + b*x)^26)/(2*b^16) + (455*d^11*(b*c - a*d)^4*(a + b*x)^27)/(9*b^16) + (65*d^12*(b*c - a*d)^3*(a + b*x)^28)/(4*b^16) + (105*d^13*(b*c - a*d)^2*(a + b*x)^29)/(29*b^16) + (d^14*(b*c - a*d)*(a + b*x)^30)/(2*b^16) + (d^15*(a + b*x)^31)/(31*b^16)}

{(a + b*x)^14*(c + d*x)^15, x, 2, ((b*c - a*d)^14*(c + d*x)^16)/(16*d^15) - (14*b*(b*c - a*d)^13*(c + d*x)^17)/(17*d^15) + (91*b^2*(b*c - a*d)^12*(c + d*x)^18)/(18*d^15) - (364*b^3*(b*c - a*d)^11*(c + d*x)^19)/(19*d^15) + (1001*b^4*(b*c - a*d)^10*(c + d*x)^20)/(20*d^15) - (286*b^5*(b*c - a*d)^9*(c + d*x)^21)/(3*d^15) + (273*b^6*(b*c - a*d)^8*(c + d*x)^22)/(2*d^15) - (3432*b^7*(b*c - a*d)^7*(c + d*x)^23)/(23*d^15) + (1001*b^8*(b*c - a*d)^6*(c + d*x)^24)/(8*d^15) - (2002*b^9*(b*c - a*d)^5*(c + d*x)^25)/(25*d^15) + (77*b^10*(b*c - a*d)^4*(c + d*x)^26)/(2*d^15) - (364*b^11*(b*c - a*d)^3*(c + d*x)^27)/(27*d^15) + (13*b^12*(b*c - a*d)^2*(c + d*x)^28)/(4*d^15) - (14*b^13*(b*c - a*d)*(c + d*x)^29)/(29*d^15) + (b^14*(c + d*x)^30)/(30*d^15)}
{(a + b*x)^13*(c + d*x)^15, x, 2, -(((b*c - a*d)^13*(c + d*x)^16)/(16*d^14)) + (13*b*(b*c - a*d)^12*(c + d*x)^17)/(17*d^14) - (13*b^2*(b*c - a*d)^11*(c + d*x)^18)/(3*d^14) + (286*b^3*(b*c - a*d)^10*(c + d*x)^19)/(19*d^14) - (143*b^4*(b*c - a*d)^9*(c + d*x)^20)/(4*d^14) + (429*b^5*(b*c - a*d)^8*(c + d*x)^21)/(7*d^14) - (78*b^6*(b*c - a*d)^7*(c + d*x)^22)/d^14 + (1716*b^7*(b*c - a*d)^6*(c + d*x)^23)/(23*d^14) - (429*b^8*(b*c - a*d)^5*(c + d*x)^24)/(8*d^14) + (143*b^9*(b*c - a*d)^4*(c + d*x)^25)/(5*d^14) - (11*b^10*(b*c - a*d)^3*(c + d*x)^26)/d^14 + (26*b^11*(b*c - a*d)^2*(c + d*x)^27)/(9*d^14) - (13*b^12*(b*c - a*d)*(c + d*x)^28)/(28*d^14) + (b^13*(c + d*x)^29)/(29*d^14)}
{(a + b*x)^12*(c + d*x)^15, x, 2, ((b*c - a*d)^12*(c + d*x)^16)/(16*d^13) - (12*b*(b*c - a*d)^11*(c + d*x)^17)/(17*d^13) + (11*b^2*(b*c - a*d)^10*(c + d*x)^18)/(3*d^13) - (220*b^3*(b*c - a*d)^9*(c + d*x)^19)/(19*d^13) + (99*b^4*(b*c - a*d)^8*(c + d*x)^20)/(4*d^13) - (264*b^5*(b*c - a*d)^7*(c + d*x)^21)/(7*d^13) + (42*b^6*(b*c - a*d)^6*(c + d*x)^22)/d^13 - (792*b^7*(b*c - a*d)^5*(c + d*x)^23)/(23*d^13) + (165*b^8*(b*c - a*d)^4*(c + d*x)^24)/(8*d^13) - (44*b^9*(b*c - a*d)^3*(c + d*x)^25)/(5*d^13) + (33*b^10*(b*c - a*d)^2*(c + d*x)^26)/(13*d^13) - (4*b^11*(b*c - a*d)*(c + d*x)^27)/(9*d^13) + (b^12*(c + d*x)^28)/(28*d^13)}
{(a + b*x)^11*(c + d*x)^15, x, 2, -((b*c - a*d)^11*(c + d*x)^16)/(16*d^12) + (11*b*(b*c - a*d)^10*(c + d*x)^17)/(17*d^12) - (55*b^2*(b*c - a*d)^9*(c + d*x)^18)/(18*d^12) + (165*b^3*(b*c - a*d)^8*(c + d*x)^19)/(19*d^12) - (33*b^4*(b*c - a*d)^7*(c + d*x)^20)/(2*d^12) + (22*b^5*(b*c - a*d)^6*(c + d*x)^21)/d^12 - (21*b^6*(b*c - a*d)^5*(c + d*x)^22)/d^12 + (330*b^7*(b*c - a*d)^4*(c + d*x)^23)/(23*d^12) - (55*b^8*(b*c - a*d)^3*(c + d*x)^24)/(8*d^12) + (11*b^9*(b*c - a*d)^2*(c + d*x)^25)/(5*d^12) - (11*b^10*(b*c - a*d)*(c + d*x)^26)/(26*d^12) + (b^11*(c + d*x)^27)/(27*d^12)}
{(a + b*x)^10*(c + d*x)^15, x, 2, ((b*c - a*d)^10*(c + d*x)^16)/(16*d^11) - (10*b*(b*c - a*d)^9*(c + d*x)^17)/(17*d^11) + (5*b^2*(b*c - a*d)^8*(c + d*x)^18)/(2*d^11) - (120*b^3*(b*c - a*d)^7*(c + d*x)^19)/(19*d^11) + (21*b^4*(b*c - a*d)^6*(c + d*x)^20)/(2*d^11) - (12*b^5*(b*c - a*d)^5*(c + d*x)^21)/d^11 + (105*b^6*(b*c - a*d)^4*(c + d*x)^22)/(11*d^11) - (120*b^7*(b*c - a*d)^3*(c + d*x)^23)/(23*d^11) + (15*b^8*(b*c - a*d)^2*(c + d*x)^24)/(8*d^11) - (2*b^9*(b*c - a*d)*(c + d*x)^25)/(5*d^11) + (b^10*(c + d*x)^26)/(26*d^11)}
{(a + b*x)^9*(c + d*x)^15, x, 2, -((b*c - a*d)^9*(c + d*x)^16)/(16*d^10) + (9*b*(b*c - a*d)^8*(c + d*x)^17)/(17*d^10) - (2*b^2*(b*c - a*d)^7*(c + d*x)^18)/d^10 + (84*b^3*(b*c - a*d)^6*(c + d*x)^19)/(19*d^10) - (63*b^4*(b*c - a*d)^5*(c + d*x)^20)/(10*d^10) + (6*b^5*(b*c - a*d)^4*(c + d*x)^21)/d^10 - (42*b^6*(b*c - a*d)^3*(c + d*x)^22)/(11*d^10) + (36*b^7*(b*c - a*d)^2*(c + d*x)^23)/(23*d^10) - (3*b^8*(b*c - a*d)*(c + d*x)^24)/(8*d^10) + (b^9*(c + d*x)^25)/(25*d^10)}
{(a + b*x)^8*(c + d*x)^15, x, 2, ((b*c - a*d)^8*(c + d*x)^16)/(16*d^9) - (8*b*(b*c - a*d)^7*(c + d*x)^17)/(17*d^9) + (14*b^2*(b*c - a*d)^6*(c + d*x)^18)/(9*d^9) - (56*b^3*(b*c - a*d)^5*(c + d*x)^19)/(19*d^9) + (7*b^4*(b*c - a*d)^4*(c + d*x)^20)/(2*d^9) - (8*b^5*(b*c - a*d)^3*(c + d*x)^21)/(3*d^9) + (14*b^6*(b*c - a*d)^2*(c + d*x)^22)/(11*d^9) - (8*b^7*(b*c - a*d)*(c + d*x)^23)/(23*d^9) + (b^8*(c + d*x)^24)/(24*d^9)}
{(a + b*x)^7*(c + d*x)^15, x, 2, -((b*c - a*d)^7*(c + d*x)^16)/(16*d^8) + (7*b*(b*c - a*d)^6*(c + d*x)^17)/(17*d^8) - (7*b^2*(b*c - a*d)^5*(c + d*x)^18)/(6*d^8) + (35*b^3*(b*c - a*d)^4*(c + d*x)^19)/(19*d^8) - (7*b^4*(b*c - a*d)^3*(c + d*x)^20)/(4*d^8) + (b^5*(b*c - a*d)^2*(c + d*x)^21)/d^8 - (7*b^6*(b*c - a*d)*(c + d*x)^22)/(22*d^8) + (b^7*(c + d*x)^23)/(23*d^8)}
{(a + b*x)^6*(c + d*x)^15, x, 2, ((b*c - a*d)^6*(c + d*x)^16)/(16*d^7) - (6*b*(b*c - a*d)^5*(c + d*x)^17)/(17*d^7) + (5*b^2*(b*c - a*d)^4*(c + d*x)^18)/(6*d^7) - (20*b^3*(b*c - a*d)^3*(c + d*x)^19)/(19*d^7) + (3*b^4*(b*c - a*d)^2*(c + d*x)^20)/(4*d^7) - (2*b^5*(b*c - a*d)*(c + d*x)^21)/(7*d^7) + (b^6*(c + d*x)^22)/(22*d^7)}
{(a + b*x)^5*(c + d*x)^15, x, 2, -((b*c - a*d)^5*(c + d*x)^16)/(16*d^6) + (5*b*(b*c - a*d)^4*(c + d*x)^17)/(17*d^6) - (5*b^2*(b*c - a*d)^3*(c + d*x)^18)/(9*d^6) + (10*b^3*(b*c - a*d)^2*(c + d*x)^19)/(19*d^6) - (b^4*(b*c - a*d)*(c + d*x)^20)/(4*d^6) + (b^5*(c + d*x)^21)/(21*d^6)}
{(a + b*x)^4*(c + d*x)^15, x, 2, ((b*c - a*d)^4*(c + d*x)^16)/(16*d^5) - (4*b*(b*c - a*d)^3*(c + d*x)^17)/(17*d^5) + (b^2*(b*c - a*d)^2*(c + d*x)^18)/(3*d^5) - (4*b^3*(b*c - a*d)*(c + d*x)^19)/(19*d^5) + (b^4*(c + d*x)^20)/(20*d^5)}
{(a + b*x)^3*(c + d*x)^15, x, 2, -((b*c - a*d)^3*(c + d*x)^16)/(16*d^4) + (3*b*(b*c - a*d)^2*(c + d*x)^17)/(17*d^4) - (b^2*(b*c - a*d)*(c + d*x)^18)/(6*d^4) + (b^3*(c + d*x)^19)/(19*d^4)}
{(a + b*x)^2*(c + d*x)^15, x, 2, ((b*c - a*d)^2*(c + d*x)^16)/(16*d^3) - (2*b*(b*c - a*d)*(c + d*x)^17)/(17*d^3) + (b^2*(c + d*x)^18)/(18*d^3)}
{(a + b*x)*(c + d*x)^15, x, 2, -((b*c - a*d)*(c + d*x)^16)/(16*d^2) + (b*(c + d*x)^17)/(17*d^2)}
{(c + d*x)^15, x, 1, (c + d*x)^16/(16*d)}

{(c + d*x)^15/(a + b*x), x, 2, (d*(b*c - a*d)^14*x)/b^15 + ((b*c - a*d)^13*(c + d*x)^2)/(2*b^14) + ((b*c - a*d)^12*(c + d*x)^3)/(3*b^13) + ((b*c - a*d)^11*(c + d*x)^4)/(4*b^12) + ((b*c - a*d)^10*(c + d*x)^5)/(5*b^11) + ((b*c - a*d)^9*(c + d*x)^6)/(6*b^10) + ((b*c - a*d)^8*(c + d*x)^7)/(7*b^9) + ((b*c - a*d)^7*(c + d*x)^8)/(8*b^8) + ((b*c - a*d)^6*(c + d*x)^9)/(9*b^7) + ((b*c - a*d)^5*(c + d*x)^10)/(10*b^6) + ((b*c - a*d)^4*(c + d*x)^11)/(11*b^5) + ((b*c - a*d)^3*(c + d*x)^12)/(12*b^4) + ((b*c - a*d)^2*(c + d*x)^13)/(13*b^3) + ((b*c - a*d)*(c + d*x)^14)/(14*b^2) + (c + d*x)^15/(15*b) + ((b*c - a*d)^15*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^2, x, 2, (105*d^2*(b*c - a*d)^13*x)/b^15 - (b*c - a*d)^15/(b^16*(a + b*x)) + (455*d^3*(b*c - a*d)^12*(a + b*x)^2)/(2*b^16) + (455*d^4*(b*c - a*d)^11*(a + b*x)^3)/b^16 + (3003*d^5*(b*c - a*d)^10*(a + b*x)^4)/(4*b^16) + (1001*d^6*(b*c - a*d)^9*(a + b*x)^5)/b^16 + (2145*d^7*(b*c - a*d)^8*(a + b*x)^6)/(2*b^16) + (6435*d^8*(b*c - a*d)^7*(a + b*x)^7)/(7*b^16) + (5005*d^9*(b*c - a*d)^6*(a + b*x)^8)/(8*b^16) + (1001*d^10*(b*c - a*d)^5*(a + b*x)^9)/(3*b^16) + (273*d^11*(b*c - a*d)^4*(a + b*x)^10)/(2*b^16) + (455*d^12*(b*c - a*d)^3*(a + b*x)^11)/(11*b^16) + (35*d^13*(b*c - a*d)^2*(a + b*x)^12)/(4*b^16) + (15*d^14*(b*c - a*d)*(a + b*x)^13)/(13*b^16) + (d^15*(a + b*x)^14)/(14*b^16) + (15*d*(b*c - a*d)^14*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^3, x, 2, (455*d^3*(b*c - a*d)^12*x)/b^15 - (b*c - a*d)^15/(2*b^16*(a + b*x)^2) - (15*d*(b*c - a*d)^14)/(b^16*(a + b*x)) + (1365*d^4*(b*c - a*d)^11*(a + b*x)^2)/(2*b^16) + (1001*d^5*(b*c - a*d)^10*(a + b*x)^3)/b^16 + (5005*d^6*(b*c - a*d)^9*(a + b*x)^4)/(4*b^16) + (1287*d^7*(b*c - a*d)^8*(a + b*x)^5)/b^16 + (2145*d^8*(b*c - a*d)^7*(a + b*x)^6)/(2*b^16) + (715*d^9*(b*c - a*d)^6*(a + b*x)^7)/b^16 + (3003*d^10*(b*c - a*d)^5*(a + b*x)^8)/(8*b^16) + (455*d^11*(b*c - a*d)^4*(a + b*x)^9)/(3*b^16) + (91*d^12*(b*c - a*d)^3*(a + b*x)^10)/(2*b^16) + (105*d^13*(b*c - a*d)^2*(a + b*x)^11)/(11*b^16) + (5*d^14*(b*c - a*d)*(a + b*x)^12)/(4*b^16) + (d^15*(a + b*x)^13)/(13*b^16) + (105*d^2*(b*c - a*d)^13*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^4, x, 2, (1365*d^4*(b*c - a*d)^11*x)/b^15 - (b*c - a*d)^15/(3*b^16*(a + b*x)^3) - (15*d*(b*c - a*d)^14)/(2*b^16*(a + b*x)^2) - (105*d^2*(b*c - a*d)^13)/(b^16*(a + b*x)) + (3003*d^5*(b*c - a*d)^10*(a + b*x)^2)/(2*b^16) + (5005*d^6*(b*c - a*d)^9*(a + b*x)^3)/(3*b^16) + (6435*d^7*(b*c - a*d)^8*(a + b*x)^4)/(4*b^16) + (1287*d^8*(b*c - a*d)^7*(a + b*x)^5)/b^16 + (5005*d^9*(b*c - a*d)^6*(a + b*x)^6)/(6*b^16) + (429*d^10*(b*c - a*d)^5*(a + b*x)^7)/b^16 + (1365*d^11*(b*c - a*d)^4*(a + b*x)^8)/(8*b^16) + (455*d^12*(b*c - a*d)^3*(a + b*x)^9)/(9*b^16) + (21*d^13*(b*c - a*d)^2*(a + b*x)^10)/(2*b^16) + (15*d^14*(b*c - a*d)*(a + b*x)^11)/(11*b^16) + (d^15*(a + b*x)^12)/(12*b^16) + (455*d^3*(b*c - a*d)^12*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^5, x, 2, (3003*d^5*(b*c - a*d)^10*x)/b^15 - (b*c - a*d)^15/(4*b^16*(a + b*x)^4) - (5*d*(b*c - a*d)^14)/(b^16*(a + b*x)^3) - (105*d^2*(b*c - a*d)^13)/(2*b^16*(a + b*x)^2) - (455*d^3*(b*c - a*d)^12)/(b^16*(a + b*x)) + (5005*d^6*(b*c - a*d)^9*(a + b*x)^2)/(2*b^16) + (2145*d^7*(b*c - a*d)^8*(a + b*x)^3)/b^16 + (6435*d^8*(b*c - a*d)^7*(a + b*x)^4)/(4*b^16) + (1001*d^9*(b*c - a*d)^6*(a + b*x)^5)/b^16 + (1001*d^10*(b*c - a*d)^5*(a + b*x)^6)/(2*b^16) + (195*d^11*(b*c - a*d)^4*(a + b*x)^7)/b^16 + (455*d^12*(b*c - a*d)^3*(a + b*x)^8)/(8*b^16) + (35*d^13*(b*c - a*d)^2*(a + b*x)^9)/(3*b^16) + (3*d^14*(b*c - a*d)*(a + b*x)^10)/(2*b^16) + (d^15*(a + b*x)^11)/(11*b^16) + (1365*d^4*(b*c - a*d)^11*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^6, x, 2, (5005*d^6*(b*c - a*d)^9*x)/b^15 - (b*c - a*d)^15/(5*b^16*(a + b*x)^5) - (15*d*(b*c - a*d)^14)/(4*b^16*(a + b*x)^4) - (35*d^2*(b*c - a*d)^13)/(b^16*(a + b*x)^3) - (455*d^3*(b*c - a*d)^12)/(2*b^16*(a + b*x)^2) - (1365*d^4*(b*c - a*d)^11)/(b^16*(a + b*x)) + (6435*d^7*(b*c - a*d)^8*(a + b*x)^2)/(2*b^16) + (2145*d^8*(b*c - a*d)^7*(a + b*x)^3)/b^16 + (5005*d^9*(b*c - a*d)^6*(a + b*x)^4)/(4*b^16) + (3003*d^10*(b*c - a*d)^5*(a + b*x)^5)/(5*b^16) + (455*d^11*(b*c - a*d)^4*(a + b*x)^6)/(2*b^16) + (65*d^12*(b*c - a*d)^3*(a + b*x)^7)/b^16 + (105*d^13*(b*c - a*d)^2*(a + b*x)^8)/(8*b^16) + (5*d^14*(b*c - a*d)*(a + b*x)^9)/(3*b^16) + (d^15*(a + b*x)^10)/(10*b^16) + (3003*d^5*(b*c - a*d)^10*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^7, x, 2, (6435*d^7*(b*c - a*d)^8*x)/b^15 - (b*c - a*d)^15/(6*b^16*(a + b*x)^6) - (3*d*(b*c - a*d)^14)/(b^16*(a + b*x)^5) - (105*d^2*(b*c - a*d)^13)/(4*b^16*(a + b*x)^4) - (455*d^3*(b*c - a*d)^12)/(3*b^16*(a + b*x)^3) - (1365*d^4*(b*c - a*d)^11)/(2*b^16*(a + b*x)^2) - (3003*d^5*(b*c - a*d)^10)/(b^16*(a + b*x)) + (6435*d^8*(b*c - a*d)^7*(a + b*x)^2)/(2*b^16) + (5005*d^9*(b*c - a*d)^6*(a + b*x)^3)/(3*b^16) + (3003*d^10*(b*c - a*d)^5*(a + b*x)^4)/(4*b^16) + (273*d^11*(b*c - a*d)^4*(a + b*x)^5)/b^16 + (455*d^12*(b*c - a*d)^3*(a + b*x)^6)/(6*b^16) + (15*d^13*(b*c - a*d)^2*(a + b*x)^7)/b^16 + (15*d^14*(b*c - a*d)*(a + b*x)^8)/(8*b^16) + (d^15*(a + b*x)^9)/(9*b^16) + (5005*d^6*(b*c - a*d)^9*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^8, x, 2, (6435*d^8*(b*c - a*d)^7*x)/b^15 - (b*c - a*d)^15/(7*b^16*(a + b*x)^7) - (5*d*(b*c - a*d)^14)/(2*b^16*(a + b*x)^6) - (21*d^2*(b*c - a*d)^13)/(b^16*(a + b*x)^5) - (455*d^3*(b*c - a*d)^12)/(4*b^16*(a + b*x)^4) - (455*d^4*(b*c - a*d)^11)/(b^16*(a + b*x)^3) - (3003*d^5*(b*c - a*d)^10)/(2*b^16*(a + b*x)^2) - (5005*d^6*(b*c - a*d)^9)/(b^16*(a + b*x)) + (5005*d^9*(b*c - a*d)^6*(a + b*x)^2)/(2*b^16) + (1001*d^10*(b*c - a*d)^5*(a + b*x)^3)/b^16 + (1365*d^11*(b*c - a*d)^4*(a + b*x)^4)/(4*b^16) + (91*d^12*(b*c - a*d)^3*(a + b*x)^5)/b^16 + (35*d^13*(b*c - a*d)^2*(a + b*x)^6)/(2*b^16) + (15*d^14*(b*c - a*d)*(a + b*x)^7)/(7*b^16) + (d^15*(a + b*x)^8)/(8*b^16) + (6435*d^7*(b*c - a*d)^8*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^9, x, 2, (5005*d^9*(b*c - a*d)^6*x)/b^15 - (b*c - a*d)^15/(8*b^16*(a + b*x)^8) - (15*d*(b*c - a*d)^14)/(7*b^16*(a + b*x)^7) - (35*d^2*(b*c - a*d)^13)/(2*b^16*(a + b*x)^6) - (91*d^3*(b*c - a*d)^12)/(b^16*(a + b*x)^5) - (1365*d^4*(b*c - a*d)^11)/(4*b^16*(a + b*x)^4) - (1001*d^5*(b*c - a*d)^10)/(b^16*(a + b*x)^3) - (5005*d^6*(b*c - a*d)^9)/(2*b^16*(a + b*x)^2) - (6435*d^7*(b*c - a*d)^8)/(b^16*(a + b*x)) + (3003*d^10*(b*c - a*d)^5*(a + b*x)^2)/(2*b^16) + (455*d^11*(b*c - a*d)^4*(a + b*x)^3)/b^16 + (455*d^12*(b*c - a*d)^3*(a + b*x)^4)/(4*b^16) + (21*d^13*(b*c - a*d)^2*(a + b*x)^5)/b^16 + (5*d^14*(b*c - a*d)*(a + b*x)^6)/(2*b^16) + (d^15*(a + b*x)^7)/(7*b^16) + (6435*d^8*(b*c - a*d)^7*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^10, x, 2, (3003*d^10*(b*c - a*d)^5*x)/b^15 - (b*c - a*d)^15/(9*b^16*(a + b*x)^9) - (15*d*(b*c - a*d)^14)/(8*b^16*(a + b*x)^8) - (15*d^2*(b*c - a*d)^13)/(b^16*(a + b*x)^7) - (455*d^3*(b*c - a*d)^12)/(6*b^16*(a + b*x)^6) - (273*d^4*(b*c - a*d)^11)/(b^16*(a + b*x)^5) - (3003*d^5*(b*c - a*d)^10)/(4*b^16*(a + b*x)^4) - (5005*d^6*(b*c - a*d)^9)/(3*b^16*(a + b*x)^3) - (6435*d^7*(b*c - a*d)^8)/(2*b^16*(a + b*x)^2) - (6435*d^8*(b*c - a*d)^7)/(b^16*(a + b*x)) + (1365*d^11*(b*c - a*d)^4*(a + b*x)^2)/(2*b^16) + (455*d^12*(b*c - a*d)^3*(a + b*x)^3)/(3*b^16) + (105*d^13*(b*c - a*d)^2*(a + b*x)^4)/(4*b^16) + (3*d^14*(b*c - a*d)*(a + b*x)^5)/b^16 + (d^15*(a + b*x)^6)/(6*b^16) + (5005*d^9*(b*c - a*d)^6*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^11, x, 2, (1365*d^11*(b*c - a*d)^4*x)/b^15 - (b*c - a*d)^15/(10*b^16*(a + b*x)^10) - (5*d*(b*c - a*d)^14)/(3*b^16*(a + b*x)^9) - (105*d^2*(b*c - a*d)^13)/(8*b^16*(a + b*x)^8) - (65*d^3*(b*c - a*d)^12)/(b^16*(a + b*x)^7) - (455*d^4*(b*c - a*d)^11)/(2*b^16*(a + b*x)^6) - (3003*d^5*(b*c - a*d)^10)/(5*b^16*(a + b*x)^5) - (5005*d^6*(b*c - a*d)^9)/(4*b^16*(a + b*x)^4) - (2145*d^7*(b*c - a*d)^8)/(b^16*(a + b*x)^3) - (6435*d^8*(b*c - a*d)^7)/(2*b^16*(a + b*x)^2) - (5005*d^9*(b*c - a*d)^6)/(b^16*(a + b*x)) + (455*d^12*(b*c - a*d)^3*(a + b*x)^2)/(2*b^16) + (35*d^13*(b*c - a*d)^2*(a + b*x)^3)/b^16 + (15*d^14*(b*c - a*d)*(a + b*x)^4)/(4*b^16) + (d^15*(a + b*x)^5)/(5*b^16) + (3003*d^10*(b*c - a*d)^5*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^12, x, 2, (455*d^12*(b*c - a*d)^3*x)/b^15 - (b*c - a*d)^15/(11*b^16*(a + b*x)^11) - (3*d*(b*c - a*d)^14)/(2*b^16*(a + b*x)^10) - (35*d^2*(b*c - a*d)^13)/(3*b^16*(a + b*x)^9) - (455*d^3*(b*c - a*d)^12)/(8*b^16*(a + b*x)^8) - (195*d^4*(b*c - a*d)^11)/(b^16*(a + b*x)^7) - (1001*d^5*(b*c - a*d)^10)/(2*b^16*(a + b*x)^6) - (1001*d^6*(b*c - a*d)^9)/(b^16*(a + b*x)^5) - (6435*d^7*(b*c - a*d)^8)/(4*b^16*(a + b*x)^4) - (2145*d^8*(b*c - a*d)^7)/(b^16*(a + b*x)^3) - (5005*d^9*(b*c - a*d)^6)/(2*b^16*(a + b*x)^2) - (3003*d^10*(b*c - a*d)^5)/(b^16*(a + b*x)) + (105*d^13*(b*c - a*d)^2*(a + b*x)^2)/(2*b^16) + (5*d^14*(b*c - a*d)*(a + b*x)^3)/b^16 + (d^15*(a + b*x)^4)/(4*b^16) + (1365*d^11*(b*c - a*d)^4*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^13, x, 2, (105*d^13*(b*c - a*d)^2*x)/b^15 - (b*c - a*d)^15/(12*b^16*(a + b*x)^12) - (15*d*(b*c - a*d)^14)/(11*b^16*(a + b*x)^11) - (21*d^2*(b*c - a*d)^13)/(2*b^16*(a + b*x)^10) - (455*d^3*(b*c - a*d)^12)/(9*b^16*(a + b*x)^9) - (1365*d^4*(b*c - a*d)^11)/(8*b^16*(a + b*x)^8) - (429*d^5*(b*c - a*d)^10)/(b^16*(a + b*x)^7) - (5005*d^6*(b*c - a*d)^9)/(6*b^16*(a + b*x)^6) - (1287*d^7*(b*c - a*d)^8)/(b^16*(a + b*x)^5) - (6435*d^8*(b*c - a*d)^7)/(4*b^16*(a + b*x)^4) - (5005*d^9*(b*c - a*d)^6)/(3*b^16*(a + b*x)^3) - (3003*d^10*(b*c - a*d)^5)/(2*b^16*(a + b*x)^2) - (1365*d^11*(b*c - a*d)^4)/(b^16*(a + b*x)) + (15*d^14*(b*c - a*d)*(a + b*x)^2)/(2*b^16) + (d^15*(a + b*x)^3)/(3*b^16) + (455*d^12*(b*c - a*d)^3*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^14, x, 2, (d^14*(15*b*c - 14*a*d)*x)/b^15 + (d^15*x^2)/(2*b^14) - (b*c - a*d)^15/(13*b^16*(a + b*x)^13) - (5*d*(b*c - a*d)^14)/(4*b^16*(a + b*x)^12) - (105*d^2*(b*c - a*d)^13)/(11*b^16*(a + b*x)^11) - (91*d^3*(b*c - a*d)^12)/(2*b^16*(a + b*x)^10) - (455*d^4*(b*c - a*d)^11)/(3*b^16*(a + b*x)^9) - (3003*d^5*(b*c - a*d)^10)/(8*b^16*(a + b*x)^8) - (715*d^6*(b*c - a*d)^9)/(b^16*(a + b*x)^7) - (2145*d^7*(b*c - a*d)^8)/(2*b^16*(a + b*x)^6) - (1287*d^8*(b*c - a*d)^7)/(b^16*(a + b*x)^5) - (5005*d^9*(b*c - a*d)^6)/(4*b^16*(a + b*x)^4) - (1001*d^10*(b*c - a*d)^5)/(b^16*(a + b*x)^3) - (1365*d^11*(b*c - a*d)^4)/(2*b^16*(a + b*x)^2) - (455*d^12*(b*c - a*d)^3)/(b^16*(a + b*x)) + (105*d^13*(b*c - a*d)^2*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^15, x, 2, (d^15*x)/b^15 - (b*c - a*d)^15/(14*b^16*(a + b*x)^14) - (15*d*(b*c - a*d)^14)/(13*b^16*(a + b*x)^13) - (35*d^2*(b*c - a*d)^13)/(4*b^16*(a + b*x)^12) - (455*d^3*(b*c - a*d)^12)/(11*b^16*(a + b*x)^11) - (273*d^4*(b*c - a*d)^11)/(2*b^16*(a + b*x)^10) - (1001*d^5*(b*c - a*d)^10)/(3*b^16*(a + b*x)^9) - (5005*d^6*(b*c - a*d)^9)/(8*b^16*(a + b*x)^8) - (6435*d^7*(b*c - a*d)^8)/(7*b^16*(a + b*x)^7) - (2145*d^8*(b*c - a*d)^7)/(2*b^16*(a + b*x)^6) - (1001*d^9*(b*c - a*d)^6)/(b^16*(a + b*x)^5) - (3003*d^10*(b*c - a*d)^5)/(4*b^16*(a + b*x)^4) - (455*d^11*(b*c - a*d)^4)/(b^16*(a + b*x)^3) - (455*d^12*(b*c - a*d)^3)/(2*b^16*(a + b*x)^2) - (105*d^13*(b*c - a*d)^2)/(b^16*(a + b*x)) + (15*d^14*(b*c - a*d)*Log[a + b*x])/b^16}
{(c + d*x)^15/(a + b*x)^16, x, 2, -(b*c - a*d)^15/(15*b^16*(a + b*x)^15) - (15*d*(b*c - a*d)^14)/(14*b^16*(a + b*x)^14) - (105*d^2*(b*c - a*d)^13)/(13*b^16*(a + b*x)^13) - (455*d^3*(b*c - a*d)^12)/(12*b^16*(a + b*x)^12) - (1365*d^4*(b*c - a*d)^11)/(11*b^16*(a + b*x)^11) - (3003*d^5*(b*c - a*d)^10)/(10*b^16*(a + b*x)^10) - (5005*d^6*(b*c - a*d)^9)/(9*b^16*(a + b*x)^9) - (6435*d^7*(b*c - a*d)^8)/(8*b^16*(a + b*x)^8) - (6435*d^8*(b*c - a*d)^7)/(7*b^16*(a + b*x)^7) - (5005*d^9*(b*c - a*d)^6)/(6*b^16*(a + b*x)^6) - (3003*d^10*(b*c - a*d)^5)/(5*b^16*(a + b*x)^5) - (1365*d^11*(b*c - a*d)^4)/(4*b^16*(a + b*x)^4) - (455*d^12*(b*c - a*d)^3)/(3*b^16*(a + b*x)^3) - (105*d^13*(b*c - a*d)^2)/(2*b^16*(a + b*x)^2) - (15*d^14*(b*c - a*d))/(b^16*(a + b*x)) + (d^15*Log[a + b*x])/b^16}

{(c + d*x)^15/(a + b*x)^17, x, 1, -(c + d*x)^16/(16*(b*c - a*d)*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^18, x, 2, -(c + d*x)^16/(17*(b*c - a*d)*(a + b*x)^17) + (d*(c + d*x)^16)/(272*(b*c - a*d)^2*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^19, x, 3, -(c + d*x)^16/(18*(b*c - a*d)*(a + b*x)^18) + (d*(c + d*x)^16)/(153*(b*c - a*d)^2*(a + b*x)^17) - (d^2*(c + d*x)^16)/(2448*(b*c - a*d)^3*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^20, x, 4, -(c + d*x)^16/(19*(b*c - a*d)*(a + b*x)^19) + (d*(c + d*x)^16)/(114*(b*c - a*d)^2*(a + b*x)^18) - (d^2*(c + d*x)^16)/(969*(b*c - a*d)^3*(a + b*x)^17) + (d^3*(c + d*x)^16)/(15504*(b*c - a*d)^4*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^21, x, 5, -(c + d*x)^16/(20*(b*c - a*d)*(a + b*x)^20) + (d*(c + d*x)^16)/(95*(b*c - a*d)^2*(a + b*x)^19) - (d^2*(c + d*x)^16)/(570*(b*c - a*d)^3*(a + b*x)^18) + (d^3*(c + d*x)^16)/(4845*(b*c - a*d)^4*(a + b*x)^17) - (d^4*(c + d*x)^16)/(77520*(b*c - a*d)^5*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^22, x, 6, -(c + d*x)^16/(21*(b*c - a*d)*(a + b*x)^21) + (d*(c + d*x)^16)/(84*(b*c - a*d)^2*(a + b*x)^20) - (d^2*(c + d*x)^16)/(399*(b*c - a*d)^3*(a + b*x)^19) + (d^3*(c + d*x)^16)/(2394*(b*c - a*d)^4*(a + b*x)^18) - (d^4*(c + d*x)^16)/(20349*(b*c - a*d)^5*(a + b*x)^17) + (d^5*(c + d*x)^16)/(325584*(b*c - a*d)^6*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^23, x, 7, -(c + d*x)^16/(22*(b*c - a*d)*(a + b*x)^22) + (d*(c + d*x)^16)/(77*(b*c - a*d)^2*(a + b*x)^21) - (d^2*(c + d*x)^16)/(308*(b*c - a*d)^3*(a + b*x)^20) + (d^3*(c + d*x)^16)/(1463*(b*c - a*d)^4*(a + b*x)^19) - (d^4*(c + d*x)^16)/(8778*(b*c - a*d)^5*(a + b*x)^18) + (d^5*(c + d*x)^16)/(74613*(b*c - a*d)^6*(a + b*x)^17) - (d^6*(c + d*x)^16)/(1193808*(b*c - a*d)^7*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^24, x, 8, -(c + d*x)^16/(23*(b*c - a*d)*(a + b*x)^23) + (7*d*(c + d*x)^16)/(506*(b*c - a*d)^2*(a + b*x)^22) - (d^2*(c + d*x)^16)/(253*(b*c - a*d)^3*(a + b*x)^21) + (d^3*(c + d*x)^16)/(1012*(b*c - a*d)^4*(a + b*x)^20) - (d^4*(c + d*x)^16)/(4807*(b*c - a*d)^5*(a + b*x)^19) + (d^5*(c + d*x)^16)/(28842*(b*c - a*d)^6*(a + b*x)^18) - (d^6*(c + d*x)^16)/(245157*(b*c - a*d)^7*(a + b*x)^17) + (d^7*(c + d*x)^16)/(3922512*(b*c - a*d)^8*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^25, x, 9, -(c + d*x)^16/(24*(b*c - a*d)*(a + b*x)^24) + (d*(c + d*x)^16)/(69*(b*c - a*d)^2*(a + b*x)^23) - (7*d^2*(c + d*x)^16)/(1518*(b*c - a*d)^3*(a + b*x)^22) + (d^3*(c + d*x)^16)/(759*(b*c - a*d)^4*(a + b*x)^21) - (d^4*(c + d*x)^16)/(3036*(b*c - a*d)^5*(a + b*x)^20) + (d^5*(c + d*x)^16)/(14421*(b*c - a*d)^6*(a + b*x)^19) - (d^6*(c + d*x)^16)/(86526*(b*c - a*d)^7*(a + b*x)^18) + (d^7*(c + d*x)^16)/(735471*(b*c - a*d)^8*(a + b*x)^17) - (d^8*(c + d*x)^16)/(11767536*(b*c - a*d)^9*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^26, x, 10, -(c + d*x)^16/(25*(b*c - a*d)*(a + b*x)^25) + (3*d*(c + d*x)^16)/(200*(b*c - a*d)^2*(a + b*x)^24) - (3*d^2*(c + d*x)^16)/(575*(b*c - a*d)^3*(a + b*x)^23) + (21*d^3*(c + d*x)^16)/(12650*(b*c - a*d)^4*(a + b*x)^22) - (3*d^4*(c + d*x)^16)/(6325*(b*c - a*d)^5*(a + b*x)^21) + (3*d^5*(c + d*x)^16)/(25300*(b*c - a*d)^6*(a + b*x)^20) - (3*d^6*(c + d*x)^16)/(120175*(b*c - a*d)^7*(a + b*x)^19) + (d^7*(c + d*x)^16)/(240350*(b*c - a*d)^8*(a + b*x)^18) - (d^8*(c + d*x)^16)/(2042975*(b*c - a*d)^9*(a + b*x)^17) + (d^9*(c + d*x)^16)/(32687600*(b*c - a*d)^10*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^27, x, 11, -(c + d*x)^16/(26*(b*c - a*d)*(a + b*x)^26) + (d*(c + d*x)^16)/(65*(b*c - a*d)^2*(a + b*x)^25) - (3*d^2*(c + d*x)^16)/(520*(b*c - a*d)^3*(a + b*x)^24) + (3*d^3*(c + d*x)^16)/(1495*(b*c - a*d)^4*(a + b*x)^23) - (21*d^4*(c + d*x)^16)/(32890*(b*c - a*d)^5*(a + b*x)^22) + (3*d^5*(c + d*x)^16)/(16445*(b*c - a*d)^6*(a + b*x)^21) - (3*d^6*(c + d*x)^16)/(65780*(b*c - a*d)^7*(a + b*x)^20) + (3*d^7*(c + d*x)^16)/(312455*(b*c - a*d)^8*(a + b*x)^19) - (d^8*(c + d*x)^16)/(624910*(b*c - a*d)^9*(a + b*x)^18) + (d^9*(c + d*x)^16)/(5311735*(b*c - a*d)^10*(a + b*x)^17) - (d^10*(c + d*x)^16)/(84987760*(b*c - a*d)^11*(a + b*x)^16)}
{(c + d*x)^15/(a + b*x)^28, x, 12, -((c + d*x)^16/(27*(b*c - a*d)*(a + b*x)^27)) + (11*d*(c + d*x)^16)/(702*(b*c - a*d)^2*(a + b*x)^26) - (11*d^2*(c + d*x)^16)/(1755*(b*c - a*d)^3*(a + b*x)^25) + (11*d^3*(c + d*x)^16)/(4680*(b*c - a*d)^4*(a + b*x)^24) - (11*d^4*(c + d*x)^16)/(13455*(b*c - a*d)^5*(a + b*x)^23) + (7*d^5*(c + d*x)^16)/(26910*(b*c - a*d)^6*(a + b*x)^22) - (d^6*(c + d*x)^16)/(13455*(b*c - a*d)^7*(a + b*x)^21) + (d^7*(c + d*x)^16)/(53820*(b*c - a*d)^8*(a + b*x)^20) - (d^8*(c + d*x)^16)/(255645*(b*c - a*d)^9*(a + b*x)^19) + (d^9*(c + d*x)^16)/(1533870*(b*c - a*d)^10*(a + b*x)^18) - (d^10*(c + d*x)^16)/(13037895*(b*c - a*d)^11*(a + b*x)^17) + (d^11*(c + d*x)^16)/(208606320*(b*c - a*d)^12*(a + b*x)^16)}

{(c + d*x)^15/(a + b*x)^29, x, 2, -(b*c - a*d)^15/(28*b^16*(a + b*x)^28) - (5*d*(b*c - a*d)^14)/(9*b^16*(a + b*x)^27) - (105*d^2*(b*c - a*d)^13)/(26*b^16*(a + b*x)^26) - (91*d^3*(b*c - a*d)^12)/(5*b^16*(a + b*x)^25) - (455*d^4*(b*c - a*d)^11)/(8*b^16*(a + b*x)^24) - (3003*d^5*(b*c - a*d)^10)/(23*b^16*(a + b*x)^23) - (455*d^6*(b*c - a*d)^9)/(2*b^16*(a + b*x)^22) - (2145*d^7*(b*c - a*d)^8)/(7*b^16*(a + b*x)^21) - (1287*d^8*(b*c - a*d)^7)/(4*b^16*(a + b*x)^20) - (5005*d^9*(b*c - a*d)^6)/(19*b^16*(a + b*x)^19) - (1001*d^10*(b*c - a*d)^5)/(6*b^16*(a + b*x)^18) - (1365*d^11*(b*c - a*d)^4)/(17*b^16*(a + b*x)^17) - (455*d^12*(b*c - a*d)^3)/(16*b^16*(a + b*x)^16) - (7*d^13*(b*c - a*d)^2)/(b^16*(a + b*x)^15) - (15*d^14*(b*c - a*d))/(14*b^16*(a + b*x)^14) - d^15/(13*b^16*(a + b*x)^13)}
{(c + d*x)^15/(a + b*x)^30, x, 2, -(b*c - a*d)^15/(29*b^16*(a + b*x)^29) - (15*d*(b*c - a*d)^14)/(28*b^16*(a + b*x)^28) - (35*d^2*(b*c - a*d)^13)/(9*b^16*(a + b*x)^27) - (35*d^3*(b*c - a*d)^12)/(2*b^16*(a + b*x)^26) - (273*d^4*(b*c - a*d)^11)/(5*b^16*(a + b*x)^25) - (1001*d^5*(b*c - a*d)^10)/(8*b^16*(a + b*x)^24) - (5005*d^6*(b*c - a*d)^9)/(23*b^16*(a + b*x)^23) - (585*d^7*(b*c - a*d)^8)/(2*b^16*(a + b*x)^22) - (2145*d^8*(b*c - a*d)^7)/(7*b^16*(a + b*x)^21) - (1001*d^9*(b*c - a*d)^6)/(4*b^16*(a + b*x)^20) - (3003*d^10*(b*c - a*d)^5)/(19*b^16*(a + b*x)^19) - (455*d^11*(b*c - a*d)^4)/(6*b^16*(a + b*x)^18) - (455*d^12*(b*c - a*d)^3)/(17*b^16*(a + b*x)^17) - (105*d^13*(b*c - a*d)^2)/(16*b^16*(a + b*x)^16) - (d^14*(b*c - a*d))/(b^16*(a + b*x)^15) - d^15/(14*b^16*(a + b*x)^14)}
{(c + d*x)^15/(a + b*x)^31, x, 2, -(b*c - a*d)^15/(30*b^16*(a + b*x)^30) - (15*d*(b*c - a*d)^14)/(29*b^16*(a + b*x)^29) - (15*d^2*(b*c - a*d)^13)/(4*b^16*(a + b*x)^28) - (455*d^3*(b*c - a*d)^12)/(27*b^16*(a + b*x)^27) - (105*d^4*(b*c - a*d)^11)/(2*b^16*(a + b*x)^26) - (3003*d^5*(b*c - a*d)^10)/(25*b^16*(a + b*x)^25) - (5005*d^6*(b*c - a*d)^9)/(24*b^16*(a + b*x)^24) - (6435*d^7*(b*c - a*d)^8)/(23*b^16*(a + b*x)^23) - (585*d^8*(b*c - a*d)^7)/(2*b^16*(a + b*x)^22) - (715*d^9*(b*c - a*d)^6)/(3*b^16*(a + b*x)^21) - (3003*d^10*(b*c - a*d)^5)/(20*b^16*(a + b*x)^20) - (1365*d^11*(b*c - a*d)^4)/(19*b^16*(a + b*x)^19) - (455*d^12*(b*c - a*d)^3)/(18*b^16*(a + b*x)^18) - (105*d^13*(b*c - a*d)^2)/(17*b^16*(a + b*x)^17) - (15*d^14*(b*c - a*d))/(16*b^16*(a + b*x)^16) - d^15/(15*b^16*(a + b*x)^15)} *)


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(a + b*x)^m/(c + d*x), x, 1, ((a + b*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)*(1 + m))}

{(a + b*x)^5/(c + d*x), x, 2, (b*(b*c - a*d)^4*x)/d^5 - ((b*c - a*d)^3*(a + b*x)^2)/(2*d^4) + ((b*c - a*d)^2*(a + b*x)^3)/(3*d^3) - ((b*c - a*d)*(a + b*x)^4)/(4*d^2) + (a + b*x)^5/(5*d) - ((b*c - a*d)^5*Log[c + d*x])/d^6}
{(a + b*x)^4/(c + d*x), x, 2, -((b*(b*c - a*d)^3*x)/d^4) + ((b*c - a*d)^2*(a + b*x)^2)/(2*d^3) - ((b*c - a*d)*(a + b*x)^3)/(3*d^2) + (a + b*x)^4/(4*d) + ((b*c - a*d)^4*Log[c + d*x])/d^5}
{(a + b*x)^3/(c + d*x), x, 2, (b*(b*c - a*d)^2*x)/d^3 - ((b*c - a*d)*(a + b*x)^2)/(2*d^2) + (a + b*x)^3/(3*d) - ((b*c - a*d)^3*Log[c + d*x])/d^4}
{(a + b*x)^2/(c + d*x), x, 2, -((b*(b*c - a*d)*x)/d^2) + (a + b*x)^2/(2*d) + ((b*c - a*d)^2*Log[c + d*x])/d^3}
{(a + b*x)^1/(c + d*x), x, 2, (b*x)/d - ((b*c - a*d)*Log[c + d*x])/d^2}
{(a + b*x)^0/(c + d*x), x, 1, Log[c + d*x]/d}
{(a + b*x)^(-1)/(c + d*x), x, 2, Log[a + b*x]/(b*c - a*d) - Log[c + d*x]/(b*c - a*d)}
{(a + b*x)^(-2)/(c + d*x), x, 2, -(1/((b*c - a*d)*(a + b*x))) - (d*Log[a + b*x])/(b*c - a*d)^2 + (d*Log[c + d*x])/(b*c - a*d)^2}
{(a + b*x)^(-3)/(c + d*x), x, 2, -(1/(2*(b*c - a*d)*(a + b*x)^2)) + d/((b*c - a*d)^2*(a + b*x)) + (d^2*Log[a + b*x])/(b*c - a*d)^3 - (d^2*Log[c + d*x])/(b*c - a*d)^3}


{(a + b*x)^m/(c + d*x)^2, x, 2, (a + b*x)^(1 + m)/((b*c - a*d)*(c + d*x)) - (b*m*(a + b*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)^2*(1 + m))}

{(a + b*x)^5/(c + d*x)^2, x, 2, -((10*b^2*(b*c - a*d)^3*x)/d^5) + (b*c - a*d)^5/(d^6*(c + d*x)) + (5*b^3*(b*c - a*d)^2*(c + d*x)^2)/d^6 - (5*b^4*(b*c - a*d)*(c + d*x)^3)/(3*d^6) + (b^5*(c + d*x)^4)/(4*d^6) + (5*b*(b*c - a*d)^4*Log[c + d*x])/d^6}
{(a + b*x)^4/(c + d*x)^2, x, 2, (6*b^2*(b*c - a*d)^2*x)/d^4 - (b*c - a*d)^4/(d^5*(c + d*x)) - (2*b^3*(b*c - a*d)*(c + d*x)^2)/d^5 + (b^4*(c + d*x)^3)/(3*d^5) - (4*b*(b*c - a*d)^3*Log[c + d*x])/d^5}
{(a + b*x)^3/(c + d*x)^2, x, 2, -((b^2*(2*b*c - 3*a*d)*x)/d^3) + (b^3*x^2)/(2*d^2) + (b*c - a*d)^3/(d^4*(c + d*x)) + (3*b*(b*c - a*d)^2*Log[c + d*x])/d^4}
{(a + b*x)^2/(c + d*x)^2, x, 2, (b^2*x)/d^2 - (b*c - a*d)^2/(d^3*(c + d*x)) - (2*b*(b*c - a*d)*Log[c + d*x])/d^3}
{(a + b*x)^1/(c + d*x)^2, x, 2, (b*c - a*d)/(d^2*(c + d*x)) + (b*Log[c + d*x])/d^2}
{(a + b*x)^0/(c + d*x)^2, x, 1, -(1/(d*(c + d*x)))}
{(a + b*x)^(-1)/(c + d*x)^2, x, 2, 1/((b*c - a*d)*(c + d*x)) + (b*Log[a + b*x])/(b*c - a*d)^2 - (b*Log[c + d*x])/(b*c - a*d)^2}
{(a + b*x)^(-2)/(c + d*x)^2, x, 2, -(b/((b*c - a*d)^2*(a + b*x))) - d/((b*c - a*d)^2*(c + d*x)) - (2*b*d*Log[a + b*x])/(b*c - a*d)^3 + (2*b*d*Log[c + d*x])/(b*c - a*d)^3}
{(a + b*x)^(-3)/(c + d*x)^2, x, 2, -(b/(2*(b*c - a*d)^2*(a + b*x)^2)) + (2*b*d)/((b*c - a*d)^3*(a + b*x)) + d^2/((b*c - a*d)^3*(c + d*x)) + (3*b*d^2*Log[a + b*x])/(b*c - a*d)^4 - (3*b*d^2*Log[c + d*x])/(b*c - a*d)^4}


{(a + b*x)^m/(c + d*x)^3, x, 3, (a + b*x)^(1 + m)/(2*(b*c - a*d)*(c + d*x)^2) + (b*(1 - m)*(a + b*x)^(1 + m))/(2*(b*c - a*d)^2*(c + d*x)) - (b^2*(1 - m)*m*(a + b*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/(2*(b*c - a*d)^3*(1 + m))}

{(a + b*x)^6/(c + d*x)^3, x, 2, -((20*b^3*(b*c - a*d)^3*x)/d^6) - (b*c - a*d)^6/(2*d^7*(c + d*x)^2) + (6*b*(b*c - a*d)^5)/(d^7*(c + d*x)) + (15*b^4*(b*c - a*d)^2*(c + d*x)^2)/(2*d^7) - (2*b^5*(b*c - a*d)*(c + d*x)^3)/d^7 + (b^6*(c + d*x)^4)/(4*d^7) + (15*b^2*(b*c - a*d)^4*Log[c + d*x])/d^7}
{(a + b*x)^5/(c + d*x)^3, x, 2, (10*b^3*(b*c - a*d)^2*x)/d^5 + (b*c - a*d)^5/(2*d^6*(c + d*x)^2) - (5*b*(b*c - a*d)^4)/(d^6*(c + d*x)) - (5*b^4*(b*c - a*d)*(c + d*x)^2)/(2*d^6) + (b^5*(c + d*x)^3)/(3*d^6) - (10*b^2*(b*c - a*d)^3*Log[c + d*x])/d^6}
{(a + b*x)^4/(c + d*x)^3, x, 2, -((b^3*(3*b*c - 4*a*d)*x)/d^4) + (b^4*x^2)/(2*d^3) - (b*c - a*d)^4/(2*d^5*(c + d*x)^2) + (4*b*(b*c - a*d)^3)/(d^5*(c + d*x)) + (6*b^2*(b*c - a*d)^2*Log[c + d*x])/d^5}
{(a + b*x)^3/(c + d*x)^3, x, 2, (b^3*x)/d^3 + (b*c - a*d)^3/(2*d^4*(c + d*x)^2) - (3*b*(b*c - a*d)^2)/(d^4*(c + d*x)) - (3*b^2*(b*c - a*d)*Log[c + d*x])/d^4}
{(a + b*x)^2/(c + d*x)^3, x, 2, -((b*c - a*d)^2/(2*d^3*(c + d*x)^2)) + (2*b*(b*c - a*d))/(d^3*(c + d*x)) + (b^2*Log[c + d*x])/d^3}
{(a + b*x)^1/(c + d*x)^3, x, 1, (a + b*x)^2/(2*(b*c - a*d)*(c + d*x)^2)}
{(a + b*x)^0/(c + d*x)^3, x, 1, -(1/(2*d*(c + d*x)^2))}
{(a + b*x)^(-1)/(c + d*x)^3, x, 2, 1/(2*(b*c - a*d)*(c + d*x)^2) + b/((b*c - a*d)^2*(c + d*x)) + (b^2*Log[a + b*x])/(b*c - a*d)^3 - (b^2*Log[c + d*x])/(b*c - a*d)^3}
{(a + b*x)^(-2)/(c + d*x)^3, x, 2, -(b^2/((b*c - a*d)^3*(a + b*x))) - d/(2*(b*c - a*d)^2*(c + d*x)^2) - (2*b*d)/((b*c - a*d)^3*(c + d*x)) - (3*b^2*d*Log[a + b*x])/(b*c - a*d)^4 + (3*b^2*d*Log[c + d*x])/(b*c - a*d)^4}
{(a + b*x)^(-3)/(c + d*x)^3, x, 2, -(b^2/(2*(b*c - a*d)^3*(a + b*x)^2)) + (3*b^2*d)/((b*c - a*d)^4*(a + b*x)) + d^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (3*b*d^2)/((b*c - a*d)^4*(c + d*x)) + (6*b^2*d^2*Log[a + b*x])/(b*c - a*d)^5 - (6*b^2*d^2*Log[c + d*x])/(b*c - a*d)^5}


{(a + b*x)^9/(c + d*x)^8, x, 2, -((b^8*(8*b*c - 9*a*d)*x)/d^9) + (b^9*x^2)/(2*d^8) + (b*c - a*d)^9/(7*d^10*(c + d*x)^7) - (3*b*(b*c - a*d)^8)/(2*d^10*(c + d*x)^6) + (36*b^2*(b*c - a*d)^7)/(5*d^10*(c + d*x)^5) - (21*b^3*(b*c - a*d)^6)/(d^10*(c + d*x)^4) + (42*b^4*(b*c - a*d)^5)/(d^10*(c + d*x)^3) - (63*b^5*(b*c - a*d)^4)/(d^10*(c + d*x)^2) + (84*b^6*(b*c - a*d)^3)/(d^10*(c + d*x)) + (36*b^7*(b*c - a*d)^2*Log[c + d*x])/d^10}
{(a + b*x)^8/(c + d*x)^8, x, 2, (b^8*x)/d^8 - (b*c - a*d)^8/(7*d^9*(c + d*x)^7) + (4*b*(b*c - a*d)^7)/(3*d^9*(c + d*x)^6) - (28*b^2*(b*c - a*d)^6)/(5*d^9*(c + d*x)^5) + (14*b^3*(b*c - a*d)^5)/(d^9*(c + d*x)^4) - (70*b^4*(b*c - a*d)^4)/(3*d^9*(c + d*x)^3) + (28*b^5*(b*c - a*d)^3)/(d^9*(c + d*x)^2) - (28*b^6*(b*c - a*d)^2)/(d^9*(c + d*x)) - (8*b^7*(b*c - a*d)*Log[c + d*x])/d^9}
{(a + b*x)^7/(c + d*x)^8, x, 2, (b*c - a*d)^7/(7*d^8*(c + d*x)^7) - (7*b*(b*c - a*d)^6)/(6*d^8*(c + d*x)^6) + (21*b^2*(b*c - a*d)^5)/(5*d^8*(c + d*x)^5) - (35*b^3*(b*c - a*d)^4)/(4*d^8*(c + d*x)^4) + (35*b^4*(b*c - a*d)^3)/(3*d^8*(c + d*x)^3) - (21*b^5*(b*c - a*d)^2)/(2*d^8*(c + d*x)^2) + (7*b^6*(b*c - a*d))/(d^8*(c + d*x)) + (b^7*Log[c + d*x])/d^8}
{(a + b*x)^6/(c + d*x)^8, x, 1, (a + b*x)^7/(7*(b*c - a*d)*(c + d*x)^7)}
{(a + b*x)^5/(c + d*x)^8, x, 2, (a + b*x)^6/(7*(b*c - a*d)*(c + d*x)^7) + (b*(a + b*x)^6)/(42*(b*c - a*d)^2*(c + d*x)^6)}
{(a + b*x)^4/(c + d*x)^8, x, 3, (a + b*x)^5/(7*(b*c - a*d)*(c + d*x)^7) + (b*(a + b*x)^5)/(21*(b*c - a*d)^2*(c + d*x)^6) + (b^2*(a + b*x)^5)/(105*(b*c - a*d)^3*(c + d*x)^5)}
{(a + b*x)^3/(c + d*x)^8, x, 2, (b*c - a*d)^3/(7*d^4*(c + d*x)^7) - (b*(b*c - a*d)^2)/(2*d^4*(c + d*x)^6) + (3*b^2*(b*c - a*d))/(5*d^4*(c + d*x)^5) - b^3/(4*d^4*(c + d*x)^4)}
{(a + b*x)^2/(c + d*x)^8, x, 2, -((b*c - a*d)^2/(7*d^3*(c + d*x)^7)) + (b*(b*c - a*d))/(3*d^3*(c + d*x)^6) - b^2/(5*d^3*(c + d*x)^5)}
{(a + b*x)^1/(c + d*x)^8, x, 2, (b*c - a*d)/(7*d^2*(c + d*x)^7) - b/(6*d^2*(c + d*x)^6)}
{(a + b*x)^0/(c + d*x)^8, x, 1, -(1/(7*d*(c + d*x)^7))}
{(a + b*x)^(-1)/(c + d*x)^8, x, 2, 1/(7*(b*c - a*d)*(c + d*x)^7) + b/(6*(b*c - a*d)^2*(c + d*x)^6) + b^2/(5*(b*c - a*d)^3*(c + d*x)^5) + b^3/(4*(b*c - a*d)^4*(c + d*x)^4) + b^4/(3*(b*c - a*d)^5*(c + d*x)^3) + b^5/(2*(b*c - a*d)^6*(c + d*x)^2) + b^6/((b*c - a*d)^7*(c + d*x)) + (b^7*Log[a + b*x])/(b*c - a*d)^8 - (b^7*Log[c + d*x])/(b*c - a*d)^8}
{(a + b*x)^(-2)/(c + d*x)^8, x, 2, -(b^7/((b*c - a*d)^8*(a + b*x))) - d/(7*(b*c - a*d)^2*(c + d*x)^7) - (b*d)/(3*(b*c - a*d)^3*(c + d*x)^6) - (3*b^2*d)/(5*(b*c - a*d)^4*(c + d*x)^5) - (b^3*d)/((b*c - a*d)^5*(c + d*x)^4) - (5*b^4*d)/(3*(b*c - a*d)^6*(c + d*x)^3) - (3*b^5*d)/((b*c - a*d)^7*(c + d*x)^2) - (7*b^6*d)/((b*c - a*d)^8*(c + d*x)) - (8*b^7*d*Log[a + b*x])/(b*c - a*d)^9 + (8*b^7*d*Log[c + d*x])/(b*c - a*d)^9}
{(a + b*x)^(-3)/(c + d*x)^8, x, 2, -(b^7/(2*(b*c - a*d)^8*(a + b*x)^2)) + (8*b^7*d)/((b*c - a*d)^9*(a + b*x)) + d^2/(7*(b*c - a*d)^3*(c + d*x)^7) + (b*d^2)/(2*(b*c - a*d)^4*(c + d*x)^6) + (6*b^2*d^2)/(5*(b*c - a*d)^5*(c + d*x)^5) + (5*b^3*d^2)/(2*(b*c - a*d)^6*(c + d*x)^4) + (5*b^4*d^2)/((b*c - a*d)^7*(c + d*x)^3) + (21*b^5*d^2)/(2*(b*c - a*d)^8*(c + d*x)^2) + (28*b^6*d^2)/((b*c - a*d)^9*(c + d*x)) + (36*b^7*d^2*Log[a + b*x])/(b*c - a*d)^10 - (36*b^7*d^2*Log[c + d*x])/(b*c - a*d)^10}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^(n/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{(a + b*x)^5*(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)^5*(c + d*x)^(3/2))/(3*d^6)) + (2*b*(b*c - a*d)^4*(c + d*x)^(5/2))/d^6 - (20*b^2*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(9/2))/(9*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^6) + (2*b^5*(c + d*x)^(13/2))/(13*d^6)}
{(a + b*x)^4*(c + d*x)^(1/2), x, 2, (2*(b*c - a*d)^4*(c + d*x)^(3/2))/(3*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(5/2))/(5*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^5) + (2*b^4*(c + d*x)^(11/2))/(11*d^5)}
{(a + b*x)^3*(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^4)) + (6*b*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^4) - (6*b^2*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^4) + (2*b^3*(c + d*x)^(9/2))/(9*d^4)}
{(a + b*x)^2*(c + d*x)^(1/2), x, 2, (2*(b*c - a*d)^2*(c + d*x)^(3/2))/(3*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^3) + (2*b^2*(c + d*x)^(7/2))/(7*d^3)}
{(a + b*x)^1*(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^2)) + (2*b*(c + d*x)^(5/2))/(5*d^2)}
{(a + b*x)^0*(c + d*x)^(1/2), x, 1, (2*(c + d*x)^(3/2))/(3*d)}
{(c + d*x)^(1/2)/(a + b*x)^1, x, 2, (2*Sqrt[c + d*x])/b - (2*Sqrt[b*c - a*d]*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/b^(3/2)}
{(c + d*x)^(1/2)/(a + b*x)^2, x, 2, -(Sqrt[c + d*x]/(b*(a + b*x))) - (d*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(b^(3/2)*Sqrt[b*c - a*d])}
{(c + d*x)^(1/2)/(a + b*x)^3, x, 3, -(Sqrt[c + d*x]/(2*b*(a + b*x)^2)) - (d*Sqrt[c + d*x])/(4*b*(b*c - a*d)*(a + b*x)) + (d^2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*b^(3/2)*(b*c - a*d)^(3/2))}
{(c + d*x)^(1/2)/(a + b*x)^4, x, 4, -(Sqrt[c + d*x]/(3*b*(a + b*x)^3)) - (d*Sqrt[c + d*x])/(12*b*(b*c - a*d)*(a + b*x)^2) + (d^2*Sqrt[c + d*x])/(8*b*(b*c - a*d)^2*(a + b*x)) - (d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*b^(3/2)*(b*c - a*d)^(5/2))}
{(c + d*x)^(1/2)/(a + b*x)^5, x, 5, -(Sqrt[c + d*x]/(4*b*(a + b*x)^4)) - (d*Sqrt[c + d*x])/(24*b*(b*c - a*d)*(a + b*x)^3) + (5*d^2*Sqrt[c + d*x])/(96*b*(b*c - a*d)^2*(a + b*x)^2) - (5*d^3*Sqrt[c + d*x])/(64*b*(b*c - a*d)^3*(a + b*x)) + (5*d^4*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(64*b^(3/2)*(b*c - a*d)^(7/2))}
{(c + d*x)^(1/2)/(a + b*x)^6, x, 6, -(Sqrt[c + d*x]/(5*b*(a + b*x)^5)) - (d*Sqrt[c + d*x])/(40*b*(b*c - a*d)*(a + b*x)^4) + (7*d^2*Sqrt[c + d*x])/(240*b*(b*c - a*d)^2*(a + b*x)^3) - (7*d^3*Sqrt[c + d*x])/(192*b*(b*c - a*d)^3*(a + b*x)^2) + (7*d^4*Sqrt[c + d*x])/(128*b*(b*c - a*d)^4*(a + b*x)) - (7*d^5*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(128*b^(3/2)*(b*c - a*d)^(9/2))}


{(a + b*x)^5*(c + d*x)^(3/2), x, 2, -((2*(b*c - a*d)^5*(c + d*x)^(5/2))/(5*d^6)) + (10*b*(b*c - a*d)^4*(c + d*x)^(7/2))/(7*d^6) - (20*b^2*(b*c - a*d)^3*(c + d*x)^(9/2))/(9*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(11/2))/(11*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(13/2))/(13*d^6) + (2*b^5*(c + d*x)^(15/2))/(15*d^6)}
{(a + b*x)^4*(c + d*x)^(3/2), x, 2, (2*(b*c - a*d)^4*(c + d*x)^(5/2))/(5*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^5) + (4*b^2*(b*c - a*d)^2*(c + d*x)^(9/2))/(3*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^5) + (2*b^4*(c + d*x)^(13/2))/(13*d^5)}
{(a + b*x)^3*(c + d*x)^(3/2), x, 2, -((2*(b*c - a*d)^3*(c + d*x)^(5/2))/(5*d^4)) + (6*b*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^4) - (2*b^2*(b*c - a*d)*(c + d*x)^(9/2))/(3*d^4) + (2*b^3*(c + d*x)^(11/2))/(11*d^4)}
{(a + b*x)^2*(c + d*x)^(3/2), x, 2, (2*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^3) + (2*b^2*(c + d*x)^(9/2))/(9*d^3)}
{(a + b*x)^1*(c + d*x)^(3/2), x, 2, -((2*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^2)) + (2*b*(c + d*x)^(7/2))/(7*d^2)}
{(a + b*x)^0*(c + d*x)^(3/2), x, 1, (2*(c + d*x)^(5/2))/(5*d)}
{(c + d*x)^(3/2)/(a + b*x)^1, x, 3, (2*(b*c - a*d)*Sqrt[c + d*x])/b^2 + (2*(c + d*x)^(3/2))/(3*b) - (2*(b*c - a*d)^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/b^(5/2)}
{(c + d*x)^(3/2)/(a + b*x)^2, x, 3, (3*d*Sqrt[c + d*x])/b^2 - (c + d*x)^(3/2)/(b*(a + b*x)) - (3*d*Sqrt[b*c - a*d]*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/b^(5/2)}
{(c + d*x)^(3/2)/(a + b*x)^3, x, 3, -((3*d*Sqrt[c + d*x])/(4*b^2*(a + b*x))) - (c + d*x)^(3/2)/(2*b*(a + b*x)^2) - (3*d^2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*b^(5/2)*Sqrt[b*c - a*d])}
{(c + d*x)^(3/2)/(a + b*x)^4, x, 4, -((d*Sqrt[c + d*x])/(4*b^2*(a + b*x)^2)) - (d^2*Sqrt[c + d*x])/(8*b^2*(b*c - a*d)*(a + b*x)) - (c + d*x)^(3/2)/(3*b*(a + b*x)^3) + (d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*b^(5/2)*(b*c - a*d)^(3/2))}
{(c + d*x)^(3/2)/(a + b*x)^5, x, 5, -((d*Sqrt[c + d*x])/(8*b^2*(a + b*x)^3)) - (d^2*Sqrt[c + d*x])/(32*b^2*(b*c - a*d)*(a + b*x)^2) + (3*d^3*Sqrt[c + d*x])/(64*b^2*(b*c - a*d)^2*(a + b*x)) - (c + d*x)^(3/2)/(4*b*(a + b*x)^4) - (3*d^4*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(64*b^(5/2)*(b*c - a*d)^(5/2))}
{(c + d*x)^(3/2)/(a + b*x)^6, x, 6, -((3*d*Sqrt[c + d*x])/(40*b^2*(a + b*x)^4)) - (d^2*Sqrt[c + d*x])/(80*b^2*(b*c - a*d)*(a + b*x)^3) + (d^3*Sqrt[c + d*x])/(64*b^2*(b*c - a*d)^2*(a + b*x)^2) - (3*d^4*Sqrt[c + d*x])/(128*b^2*(b*c - a*d)^3*(a + b*x)) - (c + d*x)^(3/2)/(5*b*(a + b*x)^5) + (3*d^5*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(128*b^(5/2)*(b*c - a*d)^(7/2))}


{(a + b*x)^5*(c + d*x)^(5/2), x, 2, -((2*(b*c - a*d)^5*(c + d*x)^(7/2))/(7*d^6)) + (10*b*(b*c - a*d)^4*(c + d*x)^(9/2))/(9*d^6) - (20*b^2*(b*c - a*d)^3*(c + d*x)^(11/2))/(11*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(13/2))/(13*d^6) - (2*b^4*(b*c - a*d)*(c + d*x)^(15/2))/(3*d^6) + (2*b^5*(c + d*x)^(17/2))/(17*d^6)}
{(a + b*x)^4*(c + d*x)^(5/2), x, 2, (2*(b*c - a*d)^4*(c + d*x)^(7/2))/(7*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(9/2))/(9*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(11/2))/(11*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(13/2))/(13*d^5) + (2*b^4*(c + d*x)^(15/2))/(15*d^5)}
{(a + b*x)^3*(c + d*x)^(5/2), x, 2, -((2*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^4)) + (2*b*(b*c - a*d)^2*(c + d*x)^(9/2))/(3*d^4) - (6*b^2*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^4) + (2*b^3*(c + d*x)^(13/2))/(13*d^4)}
{(a + b*x)^2*(c + d*x)^(5/2), x, 2, (2*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^3) + (2*b^2*(c + d*x)^(11/2))/(11*d^3)}
{(a + b*x)^1*(c + d*x)^(5/2), x, 2, -((2*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^2)) + (2*b*(c + d*x)^(9/2))/(9*d^2)}
{(a + b*x)^0*(c + d*x)^(5/2), x, 1, (2*(c + d*x)^(7/2))/(7*d)}
{(c + d*x)^(5/2)/(a + b*x)^1, x, 4, (2*(b*c - a*d)^2*Sqrt[c + d*x])/b^3 + (2*(b*c - a*d)*(c + d*x)^(3/2))/(3*b^2) + (2*(c + d*x)^(5/2))/(5*b) - (2*(b*c - a*d)^(5/2)*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/b^(7/2)}
{(c + d*x)^(5/2)/(a + b*x)^2, x, 4, (5*d*(b*c - a*d)*Sqrt[c + d*x])/b^3 + (5*d*(c + d*x)^(3/2))/(3*b^2) - (c + d*x)^(5/2)/(b*(a + b*x)) - (5*d*(b*c - a*d)^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/b^(7/2)}
{(c + d*x)^(5/2)/(a + b*x)^3, x, 4, (15*d^2*Sqrt[c + d*x])/(4*b^3) - (5*d*(c + d*x)^(3/2))/(4*b^2*(a + b*x)) - (c + d*x)^(5/2)/(2*b*(a + b*x)^2) - (15*d^2*Sqrt[b*c - a*d]*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*b^(7/2))}
{(c + d*x)^(5/2)/(a + b*x)^4, x, 4, -((5*d^2*Sqrt[c + d*x])/(8*b^3*(a + b*x))) - (5*d*(c + d*x)^(3/2))/(12*b^2*(a + b*x)^2) - (c + d*x)^(5/2)/(3*b*(a + b*x)^3) - (5*d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*b^(7/2)*Sqrt[b*c - a*d])}
{(c + d*x)^(5/2)/(a + b*x)^5, x, 5, -((5*d^2*Sqrt[c + d*x])/(32*b^3*(a + b*x)^2)) - (5*d^3*Sqrt[c + d*x])/(64*b^3*(b*c - a*d)*(a + b*x)) - (5*d*(c + d*x)^(3/2))/(24*b^2*(a + b*x)^3) - (c + d*x)^(5/2)/(4*b*(a + b*x)^4) + (5*d^4*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(64*b^(7/2)*(b*c - a*d)^(3/2))}
{(c + d*x)^(5/2)/(a + b*x)^6, x, 6, -((d^2*Sqrt[c + d*x])/(16*b^3*(a + b*x)^3)) - (d^3*Sqrt[c + d*x])/(64*b^3*(b*c - a*d)*(a + b*x)^2) + (3*d^4*Sqrt[c + d*x])/(128*b^3*(b*c - a*d)^2*(a + b*x)) - (d*(c + d*x)^(3/2))/(8*b^2*(a + b*x)^4) - (c + d*x)^(5/2)/(5*b*(a + b*x)^5) - (3*d^5*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(128*b^(7/2)*(b*c - a*d)^(5/2))}


{Sqrt[-1 + x]/(1 + x)^2, x, 2, -(Sqrt[-1 + x]/(1 + x)) + ArcTan[Sqrt[-1 + x]/Sqrt[2]]/Sqrt[2]}
{Sqrt[-1 + x]/(1 + x)^3, x, 3, -(Sqrt[-1 + x]/(2*(1 + x)^2)) + Sqrt[-1 + x]/(8*(1 + x)) + ArcTan[Sqrt[-1 + x]/Sqrt[2]]/(8*Sqrt[2])}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(a + b*x)^5/(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)^5*Sqrt[c + d*x])/d^6) + (10*b*(b*c - a*d)^4*(c + d*x)^(3/2))/(3*d^6) - (4*b^2*(b*c - a*d)^3*(c + d*x)^(5/2))/d^6 + (20*b^3*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^6) + (2*b^5*(c + d*x)^(11/2))/(11*d^6)}
{(a + b*x)^4/(c + d*x)^(1/2), x, 2, (2*(b*c - a*d)^4*Sqrt[c + d*x])/d^5 - (8*b*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^5) + (2*b^4*(c + d*x)^(9/2))/(9*d^5)}
{(a + b*x)^3/(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)^3*Sqrt[c + d*x])/d^4) + (2*b*(b*c - a*d)^2*(c + d*x)^(3/2))/d^4 - (6*b^2*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^4) + (2*b^3*(c + d*x)^(7/2))/(7*d^4)}
{(a + b*x)^2/(c + d*x)^(1/2), x, 2, (2*(b*c - a*d)^2*Sqrt[c + d*x])/d^3 - (4*b*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^3) + (2*b^2*(c + d*x)^(5/2))/(5*d^3)}
{(a + b*x)^1/(c + d*x)^(1/2), x, 2, -((2*(b*c - a*d)*Sqrt[c + d*x])/d^2) + (2*b*(c + d*x)^(3/2))/(3*d^2)}
{(a + b*x)^0/(c + d*x)^(1/2), x, 1, (2*Sqrt[c + d*x])/d}
{1/((a + b*x)^1*(c + d*x)^(1/2)), x, 1, -((2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(Sqrt[b]*Sqrt[b*c - a*d]))}
{1/((a + b*x)^2*(c + d*x)^(1/2)), x, 2, -(Sqrt[c + d*x]/((b*c - a*d)*(a + b*x))) + (d*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(Sqrt[b]*(b*c - a*d)^(3/2))}
{1/((a + b*x)^3*(c + d*x)^(1/2)), x, 3, -(Sqrt[c + d*x]/(2*(b*c - a*d)*(a + b*x)^2)) + (3*d*Sqrt[c + d*x])/(4*(b*c - a*d)^2*(a + b*x)) - (3*d^2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*Sqrt[b]*(b*c - a*d)^(5/2))}
{1/((a + b*x)^4*(c + d*x)^(1/2)), x, 4, -(Sqrt[c + d*x]/(3*(b*c - a*d)*(a + b*x)^3)) + (5*d*Sqrt[c + d*x])/(12*(b*c - a*d)^2*(a + b*x)^2) - (5*d^2*Sqrt[c + d*x])/(8*(b*c - a*d)^3*(a + b*x)) + (5*d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*Sqrt[b]*(b*c - a*d)^(7/2))}
{1/((a + b*x)^5*(c + d*x)^(1/2)), x, 5, -(Sqrt[c + d*x]/(4*(b*c - a*d)*(a + b*x)^4)) + (7*d*Sqrt[c + d*x])/(24*(b*c - a*d)^2*(a + b*x)^3) - (35*d^2*Sqrt[c + d*x])/(96*(b*c - a*d)^3*(a + b*x)^2) + (35*d^3*Sqrt[c + d*x])/(64*(b*c - a*d)^4*(a + b*x)) - (35*d^4*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(64*Sqrt[b]*(b*c - a*d)^(9/2))}


{(a + b*x)^5/(c + d*x)^(3/2), x, 2, (2*(b*c - a*d)^5)/(d^6*Sqrt[c + d*x]) + (10*b*(b*c - a*d)^4*Sqrt[c + d*x])/d^6 - (20*b^2*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^6) + (4*b^3*(b*c - a*d)^2*(c + d*x)^(5/2))/d^6 - (10*b^4*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^6) + (2*b^5*(c + d*x)^(9/2))/(9*d^6)}
{(a + b*x)^4/(c + d*x)^(3/2), x, 2, -((2*(b*c - a*d)^4)/(d^5*Sqrt[c + d*x])) - (8*b*(b*c - a*d)^3*Sqrt[c + d*x])/d^5 + (4*b^2*(b*c - a*d)^2*(c + d*x)^(3/2))/d^5 - (8*b^3*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^5) + (2*b^4*(c + d*x)^(7/2))/(7*d^5)}
{(a + b*x)^3/(c + d*x)^(3/2), x, 2, (2*(b*c - a*d)^3)/(d^4*Sqrt[c + d*x]) + (6*b*(b*c - a*d)^2*Sqrt[c + d*x])/d^4 - (2*b^2*(b*c - a*d)*(c + d*x)^(3/2))/d^4 + (2*b^3*(c + d*x)^(5/2))/(5*d^4)}
{(a + b*x)^2/(c + d*x)^(3/2), x, 2, -((2*(b*c - a*d)^2)/(d^3*Sqrt[c + d*x])) - (4*b*(b*c - a*d)*Sqrt[c + d*x])/d^3 + (2*b^2*(c + d*x)^(3/2))/(3*d^3)}
{(a + b*x)^1/(c + d*x)^(3/2), x, 2, (2*(b*c - a*d))/(d^2*Sqrt[c + d*x]) + (2*b*Sqrt[c + d*x])/d^2}
{(a + b*x)^0/(c + d*x)^(3/2), x, 1, -(2/(d*Sqrt[c + d*x]))}
{1/((a + b*x)^1*(c + d*x)^(3/2)), x, 2, 2/((b*c - a*d)*Sqrt[c + d*x]) - (2*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(b*c - a*d)^(3/2)}
{1/((a + b*x)^2*(c + d*x)^(3/2)), x, 3, -((3*d)/((b*c - a*d)^2*Sqrt[c + d*x])) - 1/((b*c - a*d)*(a + b*x)*Sqrt[c + d*x]) + (3*Sqrt[b]*d*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(b*c - a*d)^(5/2)}
{1/((a + b*x)^3*(c + d*x)^(3/2)), x, 4, (15*d^2)/(4*(b*c - a*d)^3*Sqrt[c + d*x]) - 1/(2*(b*c - a*d)*(a + b*x)^2*Sqrt[c + d*x]) + (5*d)/(4*(b*c - a*d)^2*(a + b*x)*Sqrt[c + d*x]) - (15*Sqrt[b]*d^2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*(b*c - a*d)^(7/2))}
{1/((a + b*x)^4*(c + d*x)^(3/2)), x, 5, -((35*d^3)/(8*(b*c - a*d)^4*Sqrt[c + d*x])) - 1/(3*(b*c - a*d)*(a + b*x)^3*Sqrt[c + d*x]) + (7*d)/(12*(b*c - a*d)^2*(a + b*x)^2*Sqrt[c + d*x]) - (35*d^2)/(24*(b*c - a*d)^3*(a + b*x)*Sqrt[c + d*x]) + (35*Sqrt[b]*d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*(b*c - a*d)^(9/2))}


{(a + b*x)^5/(c + d*x)^(5/2), x, 2, (2*(b*c - a*d)^5)/(3*d^6*(c + d*x)^(3/2)) - (10*b*(b*c - a*d)^4)/(d^6*Sqrt[c + d*x]) - (20*b^2*(b*c - a*d)^3*Sqrt[c + d*x])/d^6 + (20*b^3*(b*c - a*d)^2*(c + d*x)^(3/2))/(3*d^6) - (2*b^4*(b*c - a*d)*(c + d*x)^(5/2))/d^6 + (2*b^5*(c + d*x)^(7/2))/(7*d^6)}
{(a + b*x)^4/(c + d*x)^(5/2), x, 2, -((2*(b*c - a*d)^4)/(3*d^5*(c + d*x)^(3/2))) + (8*b*(b*c - a*d)^3)/(d^5*Sqrt[c + d*x]) + (12*b^2*(b*c - a*d)^2*Sqrt[c + d*x])/d^5 - (8*b^3*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^5) + (2*b^4*(c + d*x)^(5/2))/(5*d^5)}
{(a + b*x)^3/(c + d*x)^(5/2), x, 2, (2*(b*c - a*d)^3)/(3*d^4*(c + d*x)^(3/2)) - (6*b*(b*c - a*d)^2)/(d^4*Sqrt[c + d*x]) - (6*b^2*(b*c - a*d)*Sqrt[c + d*x])/d^4 + (2*b^3*(c + d*x)^(3/2))/(3*d^4)}
{(a + b*x)^2/(c + d*x)^(5/2), x, 2, -((2*(b*c - a*d)^2)/(3*d^3*(c + d*x)^(3/2))) + (4*b*(b*c - a*d))/(d^3*Sqrt[c + d*x]) + (2*b^2*Sqrt[c + d*x])/d^3}
{(a + b*x)^1/(c + d*x)^(5/2), x, 2, (2*(b*c - a*d))/(3*d^2*(c + d*x)^(3/2)) - (2*b)/(d^2*Sqrt[c + d*x])}
{(a + b*x)^0/(c + d*x)^(5/2), x, 1, -(2/(3*d*(c + d*x)^(3/2)))}
{1/((a + b*x)^1*(c + d*x)^(5/2)), x, 3, 2/(3*(b*c - a*d)*(c + d*x)^(3/2)) + (2*b)/((b*c - a*d)^2*Sqrt[c + d*x]) - (2*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(b*c - a*d)^(5/2)}
{1/((a + b*x)^2*(c + d*x)^(5/2)), x, 4, -((5*d)/(3*(b*c - a*d)^2*(c + d*x)^(3/2))) - 1/((b*c - a*d)*(a + b*x)*(c + d*x)^(3/2)) - (5*b*d)/((b*c - a*d)^3*Sqrt[c + d*x]) + (5*b^(3/2)*d*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(b*c - a*d)^(7/2)}
{1/((a + b*x)^3*(c + d*x)^(5/2)), x, 5, (35*d^2)/(12*(b*c - a*d)^3*(c + d*x)^(3/2)) - 1/(2*(b*c - a*d)*(a + b*x)^2*(c + d*x)^(3/2)) + (7*d)/(4*(b*c - a*d)^2*(a + b*x)*(c + d*x)^(3/2)) + (35*b*d^2)/(4*(b*c - a*d)^4*Sqrt[c + d*x]) - (35*b^(3/2)*d^2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(4*(b*c - a*d)^(9/2))}
{1/((a + b*x)^4*(c + d*x)^(5/2)), x, 6, -((35*d^3)/(8*(b*c - a*d)^4*(c + d*x)^(3/2))) - 1/(3*(b*c - a*d)*(a + b*x)^3*(c + d*x)^(3/2)) + (3*d)/(4*(b*c - a*d)^2*(a + b*x)^2*(c + d*x)^(3/2)) - (21*d^2)/(8*(b*c - a*d)^3*(a + b*x)*(c + d*x)^(3/2)) - (105*b*d^3)/(8*(b*c - a*d)^5*Sqrt[c + d*x]) + (105*b^(3/2)*d^3*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(8*(b*c - a*d)^(11/2))}


{(a + b*x)^5*(a*c + b*c*x)^(3/2), x, 2, (2*(a*c + b*c*x)^(15/2))/(15*b*c^6)}
{(a + b*x)^5*(a*c + b*c*x)^(1/2), x, 2, (2*(a*c + b*c*x)^(13/2))/(13*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(1/2), x, 2, (2*(a*c + b*c*x)^(11/2))/(11*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(3/2), x, 2, (2*(a*c + b*c*x)^(9/2))/(9*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(5/2), x, 2, (2*(a*c + b*c*x)^(7/2))/(7*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(7/2), x, 2, (2*(a*c + b*c*x)^(5/2))/(5*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(9/2), x, 2, (2*(a*c + b*c*x)^(3/2))/(3*b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(11/2), x, 2, (2*Sqrt[a*c + b*c*x])/(b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^(13/2), x, 2, -(2/(b*c^6*Sqrt[a*c + b*c*x]))}


{1/((-2 + x)*Sqrt[2 + x]), x, 1, -ArcTanh[Sqrt[2 + x]/2]}
{1/((2 + 3*x)*Sqrt[1 + 5*x]), x, 1, (2*ArcTan[Sqrt[3/7]*Sqrt[1 + 5*x]])/Sqrt[21]}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^(n/3)*)


{(1 - x)^(1/3)/(1 + x), x, 7, 3*(1 - x)^(1/3) - 2^(1/3)*Sqrt[3]*ArcTan[(1 + 2^(2/3)*(1 - x)^(1/3))/Sqrt[3]] + 2^(1/3)*Log[2^(1/3) - (1 - x)^(1/3)] - Log[2^(2/3) + 2^(1/3)*(1 - x)^(1/3) + (1 - x)^(2/3)]/2^(2/3)}
{(3 - 2*x)^(1/3)*(7 + x), x, 2, (-(51/16))*(3 - 2*x)^(4/3) + (3/28)*(3 - 2*x)^(7/3)}
{(1 - x)^(1/3)*(1 + x)^2, x, 2, -3*(1 - x)^(4/3) + (12/7)*(1 - x)^(7/3) - (3/10)*(1 - x)^(10/3)}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^(m/2) (c+d x)^(n/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{(a + b*x)^(7/2)*(c + d*x)^(1/2), x, 6, -((7*(b*c - a*d)^4*Sqrt[a + b*x]*Sqrt[c + d*x])/(128*b*d^4)) + (7*(b*c - a*d)^3*(a + b*x)^(3/2)*Sqrt[c + d*x])/(192*b*d^3) - (7*(b*c - a*d)^2*(a + b*x)^(5/2)*Sqrt[c + d*x])/(240*b*d^2) + ((b*c - a*d)*(a + b*x)^(7/2)*Sqrt[c + d*x])/(40*b*d) + ((a + b*x)^(9/2)*Sqrt[c + d*x])/(5*b) + (7*(b*c - a*d)^5*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(128*b^(3/2)*d^(9/2))}
{(a + b*x)^(5/2)*(c + d*x)^(1/2), x, 5, (5*(b*c - a*d)^3*Sqrt[a + b*x]*Sqrt[c + d*x])/(64*b*d^3) - (5*(b*c - a*d)^2*(a + b*x)^(3/2)*Sqrt[c + d*x])/(96*b*d^2) + ((b*c - a*d)*(a + b*x)^(5/2)*Sqrt[c + d*x])/(24*b*d) + ((a + b*x)^(7/2)*Sqrt[c + d*x])/(4*b) - (5*(b*c - a*d)^4*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(64*b^(3/2)*d^(7/2))}
{(a + b*x)^(3/2)*(c + d*x)^(1/2), x, 4, -(((b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*b*d^2)) + ((b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])/(12*b*d) + ((a + b*x)^(5/2)*Sqrt[c + d*x])/(3*b) + ((b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*b^(3/2)*d^(5/2))}
{(a + b*x)^(1/2)*(c + d*x)^(1/2), x, 3, ((b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*b*d) + ((a + b*x)^(3/2)*Sqrt[c + d*x])/(2*b) - ((b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*b^(3/2)*d^(3/2))}
{(c + d*x)^(1/2)/(a + b*x)^(1/2), x, 2, (Sqrt[a + b*x]*Sqrt[c + d*x])/b + ((b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(b^(3/2)*Sqrt[d])}
{(c + d*x)^(1/2)/(a + b*x)^(3/2), x, 2, -((2*Sqrt[c + d*x])/(b*Sqrt[a + b*x])) + (2*Sqrt[d]*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/b^(3/2)}
{(c + d*x)^(1/2)/(a + b*x)^(5/2), x, 1, -((2*(c + d*x)^(3/2))/(3*(b*c - a*d)*(a + b*x)^(3/2)))}
{(c + d*x)^(1/2)/(a + b*x)^(7/2), x, 2, -((2*(c + d*x)^(3/2))/(5*(b*c - a*d)*(a + b*x)^(5/2))) + (4*d*(c + d*x)^(3/2))/(15*(b*c - a*d)^2*(a + b*x)^(3/2))}
{(c + d*x)^(1/2)/(a + b*x)^(9/2), x, 3, -((2*(c + d*x)^(3/2))/(7*(b*c - a*d)*(a + b*x)^(7/2))) + (8*d*(c + d*x)^(3/2))/(35*(b*c - a*d)^2*(a + b*x)^(5/2)) - (16*d^2*(c + d*x)^(3/2))/(105*(b*c - a*d)^3*(a + b*x)^(3/2))}
{(c + d*x)^(1/2)/(a + b*x)^(11/2), x, 4, -((2*(c + d*x)^(3/2))/(9*(b*c - a*d)*(a + b*x)^(9/2))) + (4*d*(c + d*x)^(3/2))/(21*(b*c - a*d)^2*(a + b*x)^(7/2)) - (16*d^2*(c + d*x)^(3/2))/(105*(b*c - a*d)^3*(a + b*x)^(5/2)) + (32*d^3*(c + d*x)^(3/2))/(315*(b*c - a*d)^4*(a + b*x)^(3/2))}
{(c + d*x)^(1/2)/(a + b*x)^(13/2), x, 5, -((2*(c + d*x)^(3/2))/(11*(b*c - a*d)*(a + b*x)^(11/2))) + (16*d*(c + d*x)^(3/2))/(99*(b*c - a*d)^2*(a + b*x)^(9/2)) - (32*d^2*(c + d*x)^(3/2))/(231*(b*c - a*d)^3*(a + b*x)^(7/2)) + (128*d^3*(c + d*x)^(3/2))/(1155*(b*c - a*d)^4*(a + b*x)^(5/2)) - (256*d^4*(c + d*x)^(3/2))/(3465*(b*c - a*d)^5*(a + b*x)^(3/2))}


{(a + b*x)^(5/2)*(c + d*x)^(3/2), x, 6, (3*(b*c - a*d)^4*Sqrt[a + b*x]*Sqrt[c + d*x])/(128*b^2*d^3) - ((b*c - a*d)^3*(a + b*x)^(3/2)*Sqrt[c + d*x])/(64*b^2*d^2) + ((b*c - a*d)^2*(a + b*x)^(5/2)*Sqrt[c + d*x])/(80*b^2*d) + (3*(b*c - a*d)*(a + b*x)^(7/2)*Sqrt[c + d*x])/(40*b^2) + ((a + b*x)^(7/2)*(c + d*x)^(3/2))/(5*b) - (3*(b*c - a*d)^5*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(128*b^(5/2)*d^(7/2))}
{(a + b*x)^(3/2)*(c + d*x)^(3/2), x, 5, -((3*(b*c - a*d)^3*Sqrt[a + b*x]*Sqrt[c + d*x])/(64*b^2*d^2)) + ((b*c - a*d)^2*(a + b*x)^(3/2)*Sqrt[c + d*x])/(32*b^2*d) + ((b*c - a*d)*(a + b*x)^(5/2)*Sqrt[c + d*x])/(8*b^2) + ((a + b*x)^(5/2)*(c + d*x)^(3/2))/(4*b) + (3*(b*c - a*d)^4*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(64*b^(5/2)*d^(5/2))}
{(a + b*x)^(1/2)*(c + d*x)^(3/2), x, 4, ((b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*b^2*d) + ((b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])/(4*b^2) + ((a + b*x)^(3/2)*(c + d*x)^(3/2))/(3*b) - ((b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*b^(5/2)*d^(3/2))}
{(c + d*x)^(3/2)/(a + b*x)^(1/2), x, 3, (3*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*b^2) + (Sqrt[a + b*x]*(c + d*x)^(3/2))/(2*b) + (3*(b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*b^(5/2)*Sqrt[d])}
{(c + d*x)^(3/2)/(a + b*x)^(3/2), x, 3, (3*d*Sqrt[a + b*x]*Sqrt[c + d*x])/b^2 - (2*(c + d*x)^(3/2))/(b*Sqrt[a + b*x]) + (3*Sqrt[d]*(b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/b^(5/2)}
{(c + d*x)^(3/2)/(a + b*x)^(5/2), x, 3, -((2*d*Sqrt[c + d*x])/(b^2*Sqrt[a + b*x])) - (2*(c + d*x)^(3/2))/(3*b*(a + b*x)^(3/2)) + (2*d^(3/2)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/b^(5/2)}
{(c + d*x)^(3/2)/(a + b*x)^(7/2), x, 1, -((2*(c + d*x)^(5/2))/(5*(b*c - a*d)*(a + b*x)^(5/2)))}
{(c + d*x)^(3/2)/(a + b*x)^(9/2), x, 2, -((2*(c + d*x)^(5/2))/(7*(b*c - a*d)*(a + b*x)^(7/2))) + (4*d*(c + d*x)^(5/2))/(35*(b*c - a*d)^2*(a + b*x)^(5/2))}
{(c + d*x)^(3/2)/(a + b*x)^(11/2), x, 3, -((2*(c + d*x)^(5/2))/(9*(b*c - a*d)*(a + b*x)^(9/2))) + (8*d*(c + d*x)^(5/2))/(63*(b*c - a*d)^2*(a + b*x)^(7/2)) - (16*d^2*(c + d*x)^(5/2))/(315*(b*c - a*d)^3*(a + b*x)^(5/2))}
{(c + d*x)^(3/2)/(a + b*x)^(13/2), x, 4, -((2*(c + d*x)^(5/2))/(11*(b*c - a*d)*(a + b*x)^(11/2))) + (4*d*(c + d*x)^(5/2))/(33*(b*c - a*d)^2*(a + b*x)^(9/2)) - (16*d^2*(c + d*x)^(5/2))/(231*(b*c - a*d)^3*(a + b*x)^(7/2)) + (32*d^3*(c + d*x)^(5/2))/(1155*(b*c - a*d)^4*(a + b*x)^(5/2))}


{(a + b*x)^(5/2)*(c + d*x)^(5/2), x, 7, (5*(b*c - a*d)^5*Sqrt[a + b*x]*Sqrt[c + d*x])/(512*b^3*d^3) - (5*(b*c - a*d)^4*(a + b*x)^(3/2)*Sqrt[c + d*x])/(768*b^3*d^2) + ((b*c - a*d)^3*(a + b*x)^(5/2)*Sqrt[c + d*x])/(192*b^3*d) + ((b*c - a*d)^2*(a + b*x)^(7/2)*Sqrt[c + d*x])/(32*b^3) + ((b*c - a*d)*(a + b*x)^(7/2)*(c + d*x)^(3/2))/(12*b^2) + ((a + b*x)^(7/2)*(c + d*x)^(5/2))/(6*b) - (5*(b*c - a*d)^6*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(512*b^(7/2)*d^(7/2))}
{(a + b*x)^(3/2)*(c + d*x)^(5/2), x, 6, -((3*(b*c - a*d)^4*Sqrt[a + b*x]*Sqrt[c + d*x])/(128*b^3*d^2)) + ((b*c - a*d)^3*(a + b*x)^(3/2)*Sqrt[c + d*x])/(64*b^3*d) + ((b*c - a*d)^2*(a + b*x)^(5/2)*Sqrt[c + d*x])/(16*b^3) + ((b*c - a*d)*(a + b*x)^(5/2)*(c + d*x)^(3/2))/(8*b^2) + ((a + b*x)^(5/2)*(c + d*x)^(5/2))/(5*b) + (3*(b*c - a*d)^5*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(128*b^(7/2)*d^(5/2))}
{(a + b*x)^(1/2)*(c + d*x)^(5/2), x, 5, (5*(b*c - a*d)^3*Sqrt[a + b*x]*Sqrt[c + d*x])/(64*b^3*d) + (5*(b*c - a*d)^2*(a + b*x)^(3/2)*Sqrt[c + d*x])/(32*b^3) + (5*(b*c - a*d)*(a + b*x)^(3/2)*(c + d*x)^(3/2))/(24*b^2) + ((a + b*x)^(3/2)*(c + d*x)^(5/2))/(4*b) - (5*(b*c - a*d)^4*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(64*b^(7/2)*d^(3/2))}
{(c + d*x)^(5/2)/(a + b*x)^(1/2), x, 4, (5*(b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*b^3) + (5*(b*c - a*d)*Sqrt[a + b*x]*(c + d*x)^(3/2))/(12*b^2) + (Sqrt[a + b*x]*(c + d*x)^(5/2))/(3*b) + (5*(b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*b^(7/2)*Sqrt[d])}
{(c + d*x)^(5/2)/(a + b*x)^(3/2), x, 4, (15*d*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*b^3) + (5*d*Sqrt[a + b*x]*(c + d*x)^(3/2))/(2*b^2) - (2*(c + d*x)^(5/2))/(b*Sqrt[a + b*x]) + (15*Sqrt[d]*(b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*b^(7/2))}
{(c + d*x)^(5/2)/(a + b*x)^(5/2), x, 4, (5*d^2*Sqrt[a + b*x]*Sqrt[c + d*x])/b^3 - (10*d*(c + d*x)^(3/2))/(3*b^2*Sqrt[a + b*x]) - (2*(c + d*x)^(5/2))/(3*b*(a + b*x)^(3/2)) + (5*d^(3/2)*(b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/b^(7/2)}
{(c + d*x)^(5/2)/(a + b*x)^(7/2), x, 4, -((2*d^2*Sqrt[c + d*x])/(b^3*Sqrt[a + b*x])) - (2*d*(c + d*x)^(3/2))/(3*b^2*(a + b*x)^(3/2)) - (2*(c + d*x)^(5/2))/(5*b*(a + b*x)^(5/2)) + (2*d^(5/2)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/b^(7/2)}
{(c + d*x)^(5/2)/(a + b*x)^(9/2), x, 1, -((2*(c + d*x)^(7/2))/(7*(b*c - a*d)*(a + b*x)^(7/2)))}
{(c + d*x)^(5/2)/(a + b*x)^(11/2), x, 2, -((2*(c + d*x)^(7/2))/(9*(b*c - a*d)*(a + b*x)^(9/2))) + (4*d*(c + d*x)^(7/2))/(63*(b*c - a*d)^2*(a + b*x)^(7/2))}
{(c + d*x)^(5/2)/(a + b*x)^(13/2), x, 3, -((2*(c + d*x)^(7/2))/(11*(b*c - a*d)*(a + b*x)^(11/2))) + (8*d*(c + d*x)^(7/2))/(99*(b*c - a*d)^2*(a + b*x)^(9/2)) - (16*d^2*(c + d*x)^(7/2))/(693*(b*c - a*d)^3*(a + b*x)^(7/2))}
{(c + d*x)^(5/2)/(a + b*x)^(15/2), x, 4, -((2*(c + d*x)^(7/2))/(13*(b*c - a*d)*(a + b*x)^(13/2))) + (12*d*(c + d*x)^(7/2))/(143*(b*c - a*d)^2*(a + b*x)^(11/2)) - (16*d^2*(c + d*x)^(7/2))/(429*(b*c - a*d)^3*(a + b*x)^(9/2)) + (32*d^3*(c + d*x)^(7/2))/(3003*(b*c - a*d)^4*(a + b*x)^(7/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(a + b*x)^(7/2)/(c + d*x)^(1/2), x, 5, -((35*(b*c - a*d)^3*Sqrt[a + b*x]*Sqrt[c + d*x])/(64*d^4)) + (35*(b*c - a*d)^2*(a + b*x)^(3/2)*Sqrt[c + d*x])/(96*d^3) - (7*(b*c - a*d)*(a + b*x)^(5/2)*Sqrt[c + d*x])/(24*d^2) + ((a + b*x)^(7/2)*Sqrt[c + d*x])/(4*d) + (35*(b*c - a*d)^4*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(64*Sqrt[b]*d^(9/2))}
{(a + b*x)^(5/2)/(c + d*x)^(1/2), x, 4, (5*(b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*d^3) - (5*(b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])/(12*d^2) + ((a + b*x)^(5/2)*Sqrt[c + d*x])/(3*d) - (5*(b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*Sqrt[b]*d^(7/2))}
{(a + b*x)^(3/2)/(c + d*x)^(1/2), x, 3, -((3*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*d^2)) + ((a + b*x)^(3/2)*Sqrt[c + d*x])/(2*d) + (3*(b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*Sqrt[b]*d^(5/2))}
{(a + b*x)^(1/2)/(c + d*x)^(1/2), x, 2, (Sqrt[a + b*x]*Sqrt[c + d*x])/d - ((b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(Sqrt[b]*d^(3/2))}
{1/((a + b*x)^(1/2)*(c + d*x)^(1/2)), x, 1, (2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(Sqrt[b]*Sqrt[d])}
{1/((a + b*x)^(3/2)*(c + d*x)^(1/2)), x, 1, -((2*Sqrt[c + d*x])/((b*c - a*d)*Sqrt[a + b*x]))}
{1/((a + b*x)^(5/2)*(c + d*x)^(1/2)), x, 2, -((2*Sqrt[c + d*x])/(3*(b*c - a*d)*(a + b*x)^(3/2))) + (4*d*Sqrt[c + d*x])/(3*(b*c - a*d)^2*Sqrt[a + b*x])}
{1/((a + b*x)^(7/2)*(c + d*x)^(1/2)), x, 3, -((2*Sqrt[c + d*x])/(5*(b*c - a*d)*(a + b*x)^(5/2))) + (8*d*Sqrt[c + d*x])/(15*(b*c - a*d)^2*(a + b*x)^(3/2)) - (16*d^2*Sqrt[c + d*x])/(15*(b*c - a*d)^3*Sqrt[a + b*x])}
{1/((a + b*x)^(9/2)*(c + d*x)^(1/2)), x, 4, -((2*Sqrt[c + d*x])/(7*(b*c - a*d)*(a + b*x)^(7/2))) + (12*d*Sqrt[c + d*x])/(35*(b*c - a*d)^2*(a + b*x)^(5/2)) - (16*d^2*Sqrt[c + d*x])/(35*(b*c - a*d)^3*(a + b*x)^(3/2)) + (32*d^3*Sqrt[c + d*x])/(35*(b*c - a*d)^4*Sqrt[a + b*x])}
{1/((a + b*x)^(11/2)*(c + d*x)^(1/2)), x, 5, -((2*Sqrt[c + d*x])/(9*(b*c - a*d)*(a + b*x)^(9/2))) + (16*d*Sqrt[c + d*x])/(63*(b*c - a*d)^2*(a + b*x)^(7/2)) - (32*d^2*Sqrt[c + d*x])/(105*(b*c - a*d)^3*(a + b*x)^(5/2)) + (128*d^3*Sqrt[c + d*x])/(315*(b*c - a*d)^4*(a + b*x)^(3/2)) - (256*d^4*Sqrt[c + d*x])/(315*(b*c - a*d)^5*Sqrt[a + b*x])}


{(a + b*x)^(7/2)/(c + d*x)^(3/2), x, 5, -((2*(a + b*x)^(7/2))/(d*Sqrt[c + d*x])) + (35*b*(b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*d^4) - (35*b*(b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])/(12*d^3) + (7*b*(a + b*x)^(5/2)*Sqrt[c + d*x])/(3*d^2) - (35*Sqrt[b]*(b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*d^(9/2))}
{(a + b*x)^(5/2)/(c + d*x)^(3/2), x, 4, -((2*(a + b*x)^(5/2))/(d*Sqrt[c + d*x])) - (15*b*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*d^3) + (5*b*(a + b*x)^(3/2)*Sqrt[c + d*x])/(2*d^2) + (15*Sqrt[b]*(b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*d^(7/2))}
{(a + b*x)^(3/2)/(c + d*x)^(3/2), x, 3, -((2*(a + b*x)^(3/2))/(d*Sqrt[c + d*x])) + (3*b*Sqrt[a + b*x]*Sqrt[c + d*x])/d^2 - (3*Sqrt[b]*(b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/d^(5/2)}
{(a + b*x)^(1/2)/(c + d*x)^(3/2), x, 2, -((2*Sqrt[a + b*x])/(d*Sqrt[c + d*x])) + (2*Sqrt[b]*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/d^(3/2)}
{1/((a + b*x)^(1/2)*(c + d*x)^(3/2)), x, 1, (2*Sqrt[a + b*x])/((b*c - a*d)*Sqrt[c + d*x])}
{1/((a + b*x)^(3/2)*(c + d*x)^(3/2)), x, 2, -(2/((b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])) - (4*d*Sqrt[a + b*x])/((b*c - a*d)^2*Sqrt[c + d*x])}
{1/((a + b*x)^(5/2)*(c + d*x)^(3/2)), x, 3, -(2/(3*(b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])) + (8*d)/(3*(b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x]) + (16*d^2*Sqrt[a + b*x])/(3*(b*c - a*d)^3*Sqrt[c + d*x])}
{1/((a + b*x)^(7/2)*(c + d*x)^(3/2)), x, 4, -(2/(5*(b*c - a*d)*(a + b*x)^(5/2)*Sqrt[c + d*x])) + (4*d)/(5*(b*c - a*d)^2*(a + b*x)^(3/2)*Sqrt[c + d*x]) - (16*d^2)/(5*(b*c - a*d)^3*Sqrt[a + b*x]*Sqrt[c + d*x]) - (32*d^3*Sqrt[a + b*x])/(5*(b*c - a*d)^4*Sqrt[c + d*x])}
{1/((a + b*x)^(9/2)*(c + d*x)^(3/2)), x, 5, -(2/(7*(b*c - a*d)*(a + b*x)^(7/2)*Sqrt[c + d*x])) + (16*d)/(35*(b*c - a*d)^2*(a + b*x)^(5/2)*Sqrt[c + d*x]) - (32*d^2)/(35*(b*c - a*d)^3*(a + b*x)^(3/2)*Sqrt[c + d*x]) + (128*d^3)/(35*(b*c - a*d)^4*Sqrt[a + b*x]*Sqrt[c + d*x]) + (256*d^4*Sqrt[a + b*x])/(35*(b*c - a*d)^5*Sqrt[c + d*x])}
{1/((a + b*x)^(11/2)*(c + d*x)^(3/2)), x, 6, -(2/(9*(b*c - a*d)*(a + b*x)^(9/2)*Sqrt[c + d*x])) + (20*d)/(63*(b*c - a*d)^2*(a + b*x)^(7/2)*Sqrt[c + d*x]) - (32*d^2)/(63*(b*c - a*d)^3*(a + b*x)^(5/2)*Sqrt[c + d*x]) + (64*d^3)/(63*(b*c - a*d)^4*(a + b*x)^(3/2)*Sqrt[c + d*x]) - (256*d^4)/(63*(b*c - a*d)^5*Sqrt[a + b*x]*Sqrt[c + d*x]) - (512*d^5*Sqrt[a + b*x])/(63*(b*c - a*d)^6*Sqrt[c + d*x])}


{(a + b*x)^(9/2)/(c + d*x)^(5/2), x, 6, -((2*(a + b*x)^(9/2))/(3*d*(c + d*x)^(3/2))) - (6*b*(a + b*x)^(7/2))/(d^2*Sqrt[c + d*x]) + (105*b^2*(b*c - a*d)^2*Sqrt[a + b*x]*Sqrt[c + d*x])/(8*d^5) - (35*b^2*(b*c - a*d)*(a + b*x)^(3/2)*Sqrt[c + d*x])/(4*d^4) + (7*b^2*(a + b*x)^(5/2)*Sqrt[c + d*x])/d^3 - (105*b^(3/2)*(b*c - a*d)^3*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(8*d^(11/2))}
{(a + b*x)^(7/2)/(c + d*x)^(5/2), x, 5, -((2*(a + b*x)^(7/2))/(3*d*(c + d*x)^(3/2))) - (14*b*(a + b*x)^(5/2))/(3*d^2*Sqrt[c + d*x]) - (35*b^2*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x])/(4*d^4) + (35*b^2*(a + b*x)^(3/2)*Sqrt[c + d*x])/(6*d^3) + (35*b^(3/2)*(b*c - a*d)^2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(4*d^(9/2))}
{(a + b*x)^(5/2)/(c + d*x)^(5/2), x, 4, -((2*(a + b*x)^(5/2))/(3*d*(c + d*x)^(3/2))) - (10*b*(a + b*x)^(3/2))/(3*d^2*Sqrt[c + d*x]) + (5*b^2*Sqrt[a + b*x]*Sqrt[c + d*x])/d^3 - (5*b^(3/2)*(b*c - a*d)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/d^(7/2)}
{(a + b*x)^(3/2)/(c + d*x)^(5/2), x, 3, -((2*(a + b*x)^(3/2))/(3*d*(c + d*x)^(3/2))) - (2*b*Sqrt[a + b*x])/(d^2*Sqrt[c + d*x]) + (2*b^(3/2)*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/d^(5/2)}
{(a + b*x)^(1/2)/(c + d*x)^(5/2), x, 1, (2*(a + b*x)^(3/2))/(3*(b*c - a*d)*(c + d*x)^(3/2))}
{1/((a + b*x)^(1/2)*(c + d*x)^(5/2)), x, 2, (2*Sqrt[a + b*x])/(3*(b*c - a*d)*(c + d*x)^(3/2)) + (4*b*Sqrt[a + b*x])/(3*(b*c - a*d)^2*Sqrt[c + d*x])}
{1/((a + b*x)^(3/2)*(c + d*x)^(5/2)), x, 3, -(2/((b*c - a*d)*Sqrt[a + b*x]*(c + d*x)^(3/2))) - (8*d*Sqrt[a + b*x])/(3*(b*c - a*d)^2*(c + d*x)^(3/2)) - (16*b*d*Sqrt[a + b*x])/(3*(b*c - a*d)^3*Sqrt[c + d*x])}
{1/((a + b*x)^(5/2)*(c + d*x)^(5/2)), x, 4, -(2/(3*(b*c - a*d)*(a + b*x)^(3/2)*(c + d*x)^(3/2))) + (4*d)/((b*c - a*d)^2*Sqrt[a + b*x]*(c + d*x)^(3/2)) + (16*d^2*Sqrt[a + b*x])/(3*(b*c - a*d)^3*(c + d*x)^(3/2)) + (32*b*d^2*Sqrt[a + b*x])/(3*(b*c - a*d)^4*Sqrt[c + d*x])}
{1/((a + b*x)^(7/2)*(c + d*x)^(5/2)), x, 5, -(2/(5*(b*c - a*d)*(a + b*x)^(5/2)*(c + d*x)^(3/2))) + (16*d)/(15*(b*c - a*d)^2*(a + b*x)^(3/2)*(c + d*x)^(3/2)) - (32*d^2)/(5*(b*c - a*d)^3*Sqrt[a + b*x]*(c + d*x)^(3/2)) - (128*d^3*Sqrt[a + b*x])/(15*(b*c - a*d)^4*(c + d*x)^(3/2)) - (256*b*d^3*Sqrt[a + b*x])/(15*(b*c - a*d)^5*Sqrt[c + d*x])}
{1/((a + b*x)^(9/2)*(c + d*x)^(5/2)), x, 6, -(2/(7*(b*c - a*d)*(a + b*x)^(7/2)*(c + d*x)^(3/2))) + (4*d)/(7*(b*c - a*d)^2*(a + b*x)^(5/2)*(c + d*x)^(3/2)) - (32*d^2)/(21*(b*c - a*d)^3*(a + b*x)^(3/2)*(c + d*x)^(3/2)) + (64*d^3)/(7*(b*c - a*d)^4*Sqrt[a + b*x]*(c + d*x)^(3/2)) + (256*d^4*Sqrt[a + b*x])/(21*(b*c - a*d)^5*(c + d*x)^(3/2)) + (512*b*d^4*Sqrt[a + b*x])/(21*(b*c - a*d)^6*Sqrt[c + d*x])}


{1/(Sqrt[4 + a + b*x]*Sqrt[a + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[a + b*x]])/b}

{1/(Sqrt[4 + 2 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[2 + b*x]])/b}
{1/(Sqrt[4 + 1 + b*x]*Sqrt[1 + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[1 + b*x]])/b}
{1/(Sqrt[4 + 0 + b*x]*Sqrt[0 + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[b*x]])/b}
{1/(Sqrt[4 - 1 + b*x]*Sqrt[-1 + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[-1 + b*x]])/b}
{1/(Sqrt[4 - 2 + b*x]*Sqrt[-2 + b*x]), x, 1, ArcCosh[(b*x)/2]/b}
{1/(Sqrt[4 - 3 + b*x]*Sqrt[-3 + b*x]), x, 1, (2*ArcSinh[(1/2)*Sqrt[-3 + b*x]])/b}


{1/(Sqrt[3 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[Sqrt[2 + b*x]])/b}
{1/(Sqrt[2 + b*x]*Sqrt[2 + b*x]), x, 1, Log[2 + b*x]/b}
{1/(Sqrt[1 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[Sqrt[1 + b*x]])/b}
{1/(Sqrt[0 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[Sqrt[b*x]/Sqrt[2]])/b}
{1/(Sqrt[-1 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[Sqrt[-1 + b*x]/Sqrt[3]])/b}
{1/(Sqrt[-2 + b*x]*Sqrt[2 + b*x]), x, 1, ArcCosh[(b*x)/2]/b}
{1/(Sqrt[-3 + b*x]*Sqrt[2 + b*x]), x, 1, (2*ArcSinh[Sqrt[-3 + b*x]/Sqrt[5]])/b}


{1/(Sqrt[3 - b*x]*Sqrt[2 + b*x]), x, 1, -(ArcSin[(1 - 2*b*x)/5]/b)}
{1/(Sqrt[2 - b*x]*Sqrt[2 + b*x]), x, 1, ArcSin[(b*x)/2]/b}
{1/(Sqrt[1 - b*x]*Sqrt[2 + b*x]), x, 1, -(ArcSin[(-1 - 2*b*x)/3]/b)}
{1/(Sqrt[0 - b*x]*Sqrt[2 + b*x]), x, 1, ArcSin[1 + b*x]/b}
{1/(Sqrt[-1 - b*x]*Sqrt[2 + b*x]), x, 1, ArcSin[3 + 2*b*x]/b}
{1/(Sqrt[-2 - b*x]*Sqrt[2 + b*x]), x, 2, (Sqrt[2 + b*x]*Log[2 + b*x])/(b*Sqrt[-2 - b*x])}
{1/(Sqrt[-3 - b*x]*Sqrt[2 + b*x]), x, 1, (-2*ArcTan[Sqrt[-3 - b*x]/Sqrt[2 + b*x]])/b}


{1/(Sqrt[3 - b*x]*Sqrt[2 - b*x]), x, 1, -((2*ArcSinh[Sqrt[2 - b*x]])/b)}
{1/(Sqrt[2 - b*x]*Sqrt[2 - b*x]), x, 1, -(Log[2 - b*x]/b)}
{1/(Sqrt[1 - b*x]*Sqrt[2 - b*x]), x, 1, -((2*ArcSinh[Sqrt[1 - b*x]])/b)}
{1/(Sqrt[0 - b*x]*Sqrt[2 - b*x]), x, 1, -((2*ArcSinh[Sqrt[-b*x]/Sqrt[2]])/b)}
{1/(Sqrt[-1 - b*x]*Sqrt[2 - b*x]), x, 1, -((2*ArcSinh[Sqrt[-1 - b*x]/Sqrt[3]])/b)}
{1/(Sqrt[-2 - b*x]*Sqrt[2 - b*x]), x, 1, -(ArcCosh[-(b*x)/2]/b)}
{1/(Sqrt[-3 - b*x]*Sqrt[2 - b*x]), x, 1, -((2*ArcSinh[Sqrt[-3 - b*x]/Sqrt[5]])/b)}


{1/(Sqrt[4+b*x]*Sqrt[-4+b*x]), x, 1, ArcCosh[(b*x)/4]/b}

{1/(Sqrt[(-b+b*c)/d+b*x]*Sqrt[c+d*x]), x, 1, (2*ArcTanh[(Sqrt[d]*Sqrt[-((b*(1 - c))/d) + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(Sqrt[b]*Sqrt[d])}
{1/(Sqrt[x]*Sqrt[-3 + 2*x]), x, 1, Sqrt[2]*ArcSinh[Sqrt[-3 + 2*x]/Sqrt[3]]}
{1/(Sqrt[2+3*x]*Sqrt[-3+2*x]), x, 1, Sqrt[2/3]*ArcSinh[Sqrt[3/13]*Sqrt[-3 + 2*x]]}
{1/(Sqrt[a+b*x]*Sqrt[c+d*x]), x, 1, (2*ArcTanh[(Sqrt[d]*Sqrt[a + b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(Sqrt[b]*Sqrt[d])}

{1/(Sqrt[(b-b*c)/d+b*x]*Sqrt[c-d*x]), x, 1, (2*ArcTan[(Sqrt[d]*Sqrt[(b*(1 - c))/d + b*x])/(Sqrt[b]*Sqrt[c - d*x])])/(Sqrt[b]*Sqrt[d])}
{1/(Sqrt[4 - x]*Sqrt[x]), x, 1, -ArcSin[(2 - x)/2]}
{1/(Sqrt[x]*Sqrt[3 - 2*x]), x, 1, Sqrt[2]*ArcSin[Sqrt[2/3]*Sqrt[x]]}
{1/(Sqrt[3+5*x]*Sqrt[3-2*x]), x, 1, Sqrt[2/5]*ArcSin[Sqrt[2/21]*Sqrt[3 + 5*x]]}
{1/(Sqrt[a-b*x]*Sqrt[c+d*x]), x, 1, -((2*ArcTan[(Sqrt[d]*Sqrt[a - b*x])/(Sqrt[b]*Sqrt[c + d*x])])/(Sqrt[b]*Sqrt[d]))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^(m/2) (c+d x)^(n/3)*)


(* {1/((a + b*x)^(1/2)*(c + d*x)^(1/3)), x, 0, (-(1/((-b)^(2/3)*d*Sqrt[a + b*x])))*2*(-1)^(1/6)*3^(3/4)*((-b)*c + a*d)^(2/3)*Sqrt[(-(-1)^(5/6))*(1 - ((-b)^(1/3)*(c + d*x)^(1/3))/((-b)*c + a*d)^(1/3))]*Sqrt[1 + ((-b)^(1/3)*(c + d*x)^(1/3))/((-b)*c + a*d)^(1/3) + ((-b)^(2/3)*(c + d*x)^(2/3))/((-b)*c + a*d)^(2/3)]*(I*Sqrt[3]*EllipticE[ArcSin[Sqrt[-(-1)^(5/6) - (I*(-b)^(1/3)*(c + d*x)^(1/3))/((-b)*c + a*d)^(1/3)]/3^(1/4)], (-1)^(1/3)] - (-1)^(1/3)*EllipticF[ArcSin[Sqrt[-(-1)^(5/6) - (I*(-b)^(1/3)*(c + d*x)^(1/3))/((-b)*c + a*d)^(1/3)]/3^(1/4)], (-1)^(1/3)])} *)


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^(m/3) (c+d x)^(n/3)*)


{(-1 + x)^(1/3)/(1 + x)^(1/3), x, 7, (-1 + x)^(1/3)*(1 + x)^(2/3) - (2*ArcTan[(1 + (2*(-1 + x)^(1/3))/(1 + x)^(1/3))/Sqrt[3]])/Sqrt[3] + (2/3)*Log[1 - (-1 + x)^(1/3)/(1 + x)^(1/3)] - (1/3)*Log[1 + (-1 + x)^(2/3)/(1 + x)^(2/3) + (-1 + x)^(1/3)/(1 + x)^(1/3)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form (1 - x)^(m/2) (1 + x)^(n/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


(* Note: (1-x)^m*(1+x)^m == (1-x^2)^m *)
{(1 - x)^(9/2)*(1 + x)^(1/2), x, 7, (21/16)*Sqrt[1 - x]*Sqrt[1 + x] + (7/16)*(1 - x)^(3/2)*Sqrt[1 + x] + (7/40)*(1 - x)^(5/2)*Sqrt[1 + x] + (3/40)*(1 - x)^(7/2)*Sqrt[1 + x] + (1/30)*(1 - x)^(9/2)*Sqrt[1 + x] - (1/6)*(1 - x)^(11/2)*Sqrt[1 + x] + (21*ArcSin[x])/16}
{(1 - x)^(7/2)*(1 + x)^(1/2), x, 6, (7/8)*Sqrt[1 - x]*Sqrt[1 + x] + (7/24)*(1 - x)^(3/2)*Sqrt[1 + x] + (7/60)*(1 - x)^(5/2)*Sqrt[1 + x] + (1/20)*(1 - x)^(7/2)*Sqrt[1 + x] - (1/5)*(1 - x)^(9/2)*Sqrt[1 + x] + (7*ArcSin[x])/8}
{(1 - x)^(5/2)*(1 + x)^(1/2), x, 5, (5/8)*Sqrt[1 - x]*Sqrt[1 + x] + (5/24)*(1 - x)^(3/2)*Sqrt[1 + x] + (1/12)*(1 - x)^(5/2)*Sqrt[1 + x] - (1/4)*(1 - x)^(7/2)*Sqrt[1 + x] + (5*ArcSin[x])/8}
{(1 - x)^(3/2)*(1 + x)^(1/2), x, 4, (1/2)*Sqrt[1 - x]*Sqrt[1 + x] + (1/6)*(1 - x)^(3/2)*Sqrt[1 + x] - (1/3)*(1 - x)^(5/2)*Sqrt[1 + x] + ArcSin[x]/2}
{(1 - x)^(1/2)*(1 + x)^(1/2), x, 3, (1/2)*x*Sqrt[1 - x^2] + ArcSin[x]/2}
{(1 + x)^(1/2)/(1 - x)^(1/2), x, 2, (-Sqrt[1 - x])*Sqrt[1 + x] + ArcSin[x]}
{(1 + x)^(1/2)/(1 - x)^(3/2), x, 2, (2*Sqrt[1 + x])/Sqrt[1 - x] - ArcSin[x]}
{(1 + x)^(1/2)/(1 - x)^(5/2), x, 1, (1 + x)^(3/2)/(3*(1 - x)^(3/2))}
{(1 + x)^(1/2)/(1 - x)^(7/2), x, 2, (1 + x)^(3/2)/(5*(1 - x)^(5/2)) + (1 + x)^(3/2)/(15*(1 - x)^(3/2))}
{(1 + x)^(1/2)/(1 - x)^(9/2), x, 3, (1 + x)^(3/2)/(7*(1 - x)^(7/2)) + (2*(1 + x)^(3/2))/(35*(1 - x)^(5/2)) + (2*(1 + x)^(3/2))/(105*(1 - x)^(3/2))}
{(1 + x)^(1/2)/(1 - x)^(11/2), x, 4, (1 + x)^(3/2)/(9*(1 - x)^(9/2)) + (1 + x)^(3/2)/(21*(1 - x)^(7/2)) + (2*(1 + x)^(3/2))/(105*(1 - x)^(5/2)) + (2*(1 + x)^(3/2))/(315*(1 - x)^(3/2))}
{(1 + x)^(1/2)/(1 - x)^(13/2), x, 5, (1 + x)^(3/2)/(11*(1 - x)^(11/2)) + (4*(1 + x)^(3/2))/(99*(1 - x)^(9/2)) + (4*(1 + x)^(3/2))/(231*(1 - x)^(7/2)) + (8*(1 + x)^(3/2))/(1155*(1 - x)^(5/2)) + (8*(1 + x)^(3/2))/(3465*(1 - x)^(3/2))}


{(1 - x)^(11/2)*(1 + x)^(3/2), x, 9, (99/128)*Sqrt[1 - x]*Sqrt[1 + x] + (33/128)*(1 - x)^(3/2)*Sqrt[1 + x] + (33/320)*(1 - x)^(5/2)*Sqrt[1 + x] + (99*(1 - x)^(7/2)*Sqrt[1 + x])/2240 + (11/560)*(1 - x)^(9/2)*Sqrt[1 + x] + (1/112)*(1 - x)^(11/2)*Sqrt[1 + x] - (3/56)*(1 - x)^(13/2)*Sqrt[1 + x] - (1/8)*(1 - x)^(13/2)*(1 + x)^(3/2) + (99*ArcSin[x])/128}
{(1 - x)^(9/2)*(1 + x)^(3/2), x, 8, (9/16)*Sqrt[1 - x]*Sqrt[1 + x] + (3/16)*(1 - x)^(3/2)*Sqrt[1 + x] + (3/40)*(1 - x)^(5/2)*Sqrt[1 + x] + (9/280)*(1 - x)^(7/2)*Sqrt[1 + x] + (1/70)*(1 - x)^(9/2)*Sqrt[1 + x] - (1/14)*(1 - x)^(11/2)*Sqrt[1 + x] - (1/7)*(1 - x)^(11/2)*(1 + x)^(3/2) + (9*ArcSin[x])/16}
{(1 - x)^(7/2)*(1 + x)^(3/2), x, 7, (7/16)*Sqrt[1 - x]*Sqrt[1 + x] + (7/48)*(1 - x)^(3/2)*Sqrt[1 + x] + (7/120)*(1 - x)^(5/2)*Sqrt[1 + x] + (1/40)*(1 - x)^(7/2)*Sqrt[1 + x] - (1/10)*(1 - x)^(9/2)*Sqrt[1 + x] - (1/6)*(1 - x)^(9/2)*(1 + x)^(3/2) + (7*ArcSin[x])/16}
{(1 - x)^(5/2)*(1 + x)^(3/2), x, 6, (3/8)*Sqrt[1 - x]*Sqrt[1 + x] + (1/8)*(1 - x)^(3/2)*Sqrt[1 + x] + (1/20)*(1 - x)^(5/2)*Sqrt[1 + x] - (3/20)*(1 - x)^(7/2)*Sqrt[1 + x] - (1/5)*(1 - x)^(7/2)*(1 + x)^(3/2) + (3*ArcSin[x])/8}
{(1 - x)^(3/2)*(1 + x)^(3/2), x, 4, (3/8)*x*Sqrt[1 - x^2] + (1/4)*x*(1 - x^2)^(3/2) + (3*ArcSin[x])/8}
{(1 - x)^(1/2)*(1 + x)^(3/2), x, 4, (-(1/3))*(1 - x)^(3/2)*(1 + x)^(3/2) + (1/2)*x*Sqrt[1 - x^2] + ArcSin[x]/2}
{(1 + x)^(3/2)/(1 - x)^(1/2), x, 3, (-(3/2))*Sqrt[1 - x]*Sqrt[1 + x] - (1/2)*Sqrt[1 - x]*(1 + x)^(3/2) + (3*ArcSin[x])/2}
{(1 + x)^(3/2)/(1 - x)^(3/2), x, 3, 3*Sqrt[1 - x]*Sqrt[1 + x] + (2*(1 + x)^(3/2))/Sqrt[1 - x] - 3*ArcSin[x]}
{(1 + x)^(3/2)/(1 - x)^(5/2), x, 3, -((2*Sqrt[1 + x])/Sqrt[1 - x]) + (2*(1 + x)^(3/2))/(3*(1 - x)^(3/2)) + ArcSin[x]}
{(1 + x)^(3/2)/(1 - x)^(7/2), x, 1, (1 + x)^(5/2)/(5*(1 - x)^(5/2))}
{(1 + x)^(3/2)/(1 - x)^(9/2), x, 2, (1 + x)^(5/2)/(7*(1 - x)^(7/2)) + (1 + x)^(5/2)/(35*(1 - x)^(5/2))}
{(1 + x)^(3/2)/(1 - x)^(11/2), x, 3, (1 + x)^(5/2)/(9*(1 - x)^(9/2)) + (2*(1 + x)^(5/2))/(63*(1 - x)^(7/2)) + (2*(1 + x)^(5/2))/(315*(1 - x)^(5/2))}
{(1 + x)^(3/2)/(1 - x)^(13/2), x, 4, (1 + x)^(5/2)/(11*(1 - x)^(11/2)) + (1 + x)^(5/2)/(33*(1 - x)^(9/2)) + (2*(1 + x)^(5/2))/(231*(1 - x)^(7/2)) + (2*(1 + x)^(5/2))/(1155*(1 - x)^(5/2))}
{(1 + x)^(3/2)/(1 - x)^(15/2), x, 5, (1 + x)^(5/2)/(13*(1 - x)^(13/2)) + (4*(1 + x)^(5/2))/(143*(1 - x)^(11/2)) + (4*(1 + x)^(5/2))/(429*(1 - x)^(9/2)) + (8*(1 + x)^(5/2))/(3003*(1 - x)^(7/2)) + (8*(1 + x)^(5/2))/(15015*(1 - x)^(5/2))}


{(1 - x)^(13/2)*(1 + x)^(5/2), x, 11, (143/256)*Sqrt[1 - x]*Sqrt[1 + x] + (143/768)*(1 - x)^(3/2)*Sqrt[1 + x] + (143*(1 - x)^(5/2)*Sqrt[1 + x])/1920 + (143*(1 - x)^(7/2)*Sqrt[1 + x])/4480 + (143*(1 - x)^(9/2)*Sqrt[1 + x])/10080 + (13*(1 - x)^(11/2)*Sqrt[1 + x])/2016 + (1/336)*(1 - x)^(13/2)*Sqrt[1 + x] - (1/48)*(1 - x)^(15/2)*Sqrt[1 + x] - (1/18)*(1 - x)^(15/2)*(1 + x)^(3/2) - (1/10)*(1 - x)^(15/2)*(1 + x)^(5/2) + (143*ArcSin[x])/256}
{(1 - x)^(11/2)*(1 + x)^(5/2), x, 10, (55/128)*Sqrt[1 - x]*Sqrt[1 + x] + (55/384)*(1 - x)^(3/2)*Sqrt[1 + x] + (11/192)*(1 - x)^(5/2)*Sqrt[1 + x] + (11/448)*(1 - x)^(7/2)*Sqrt[1 + x] + (11*(1 - x)^(9/2)*Sqrt[1 + x])/1008 + (5*(1 - x)^(11/2)*Sqrt[1 + x])/1008 - (5/168)*(1 - x)^(13/2)*Sqrt[1 + x] - (5/72)*(1 - x)^(13/2)*(1 + x)^(3/2) - (1/9)*(1 - x)^(13/2)*(1 + x)^(5/2) + (55*ArcSin[x])/128}
{(1 - x)^(9/2)*(1 + x)^(5/2), x, 9, (45/128)*Sqrt[1 - x]*Sqrt[1 + x] + (15/128)*(1 - x)^(3/2)*Sqrt[1 + x] + (3/64)*(1 - x)^(5/2)*Sqrt[1 + x] + (9/448)*(1 - x)^(7/2)*Sqrt[1 + x] + (1/112)*(1 - x)^(9/2)*Sqrt[1 + x] - (5/112)*(1 - x)^(11/2)*Sqrt[1 + x] - (5/56)*(1 - x)^(11/2)*(1 + x)^(3/2) - (1/8)*(1 - x)^(11/2)*(1 + x)^(5/2) + (45*ArcSin[x])/128}
{(1 - x)^(7/2)*(1 + x)^(5/2), x, 8, (5/16)*Sqrt[1 - x]*Sqrt[1 + x] + (5/48)*(1 - x)^(3/2)*Sqrt[1 + x] + (1/24)*(1 - x)^(5/2)*Sqrt[1 + x] + (1/56)*(1 - x)^(7/2)*Sqrt[1 + x] - (1/14)*(1 - x)^(9/2)*Sqrt[1 + x] - (5/42)*(1 - x)^(9/2)*(1 + x)^(3/2) - (1/7)*(1 - x)^(9/2)*(1 + x)^(5/2) + (5*ArcSin[x])/16}
{(1 - x)^(5/2)*(1 + x)^(5/2), x, 5, (5/16)*x*Sqrt[1 - x^2] + (5/24)*x*(1 - x^2)^(3/2) + (1/6)*x*(1 - x^2)^(5/2) + (5*ArcSin[x])/16}
{(1 - x)^(3/2)*(1 + x)^(5/2), x, 5, (-(1/5))*(1 - x)^(5/2)*(1 + x)^(5/2) + (3/8)*x*Sqrt[1 - x^2] + (1/4)*x*(1 - x^2)^(3/2) + (3*ArcSin[x])/8}
{(1 - x)^(1/2)*(1 + x)^(5/2), x, 5, (-(5/12))*(1 - x)^(3/2)*(1 + x)^(3/2) - (1/4)*(1 - x)^(3/2)*(1 + x)^(5/2) + (5/8)*x*Sqrt[1 - x^2] + (5*ArcSin[x])/8}
{(1 + x)^(5/2)/(1 - x)^(1/2), x, 4, (-(5/2))*Sqrt[1 - x]*Sqrt[1 + x] - (5/6)*Sqrt[1 - x]*(1 + x)^(3/2) - (1/3)*Sqrt[1 - x]*(1 + x)^(5/2) + (5*ArcSin[x])/2}
{(1 + x)^(5/2)/(1 - x)^(3/2), x, 4, (15/2)*Sqrt[1 - x]*Sqrt[1 + x] + (5/2)*Sqrt[1 - x]*(1 + x)^(3/2) + (2*(1 + x)^(5/2))/Sqrt[1 - x] - (15*ArcSin[x])/2}
{(1 + x)^(5/2)/(1 - x)^(5/2), x, 4, -5*Sqrt[1 - x]*Sqrt[1 + x] - (10*(1 + x)^(3/2))/(3*Sqrt[1 - x]) + (2*(1 + x)^(5/2))/(3*(1 - x)^(3/2)) + 5*ArcSin[x]}
{(1 + x)^(5/2)/(1 - x)^(7/2), x, 4, (2*Sqrt[1 + x])/Sqrt[1 - x] - (2*(1 + x)^(3/2))/(3*(1 - x)^(3/2)) + (2*(1 + x)^(5/2))/(5*(1 - x)^(5/2)) - ArcSin[x]}
{(1 + x)^(5/2)/(1 - x)^(9/2), x, 1, (1 + x)^(7/2)/(7*(1 - x)^(7/2))}
{(1 + x)^(5/2)/(1 - x)^(11/2), x, 2, (1 + x)^(7/2)/(9*(1 - x)^(9/2)) + (1 + x)^(7/2)/(63*(1 - x)^(7/2))}
{(1 + x)^(5/2)/(1 - x)^(13/2), x, 3, (1 + x)^(7/2)/(11*(1 - x)^(11/2)) + (2*(1 + x)^(7/2))/(99*(1 - x)^(9/2)) + (2*(1 + x)^(7/2))/(693*(1 - x)^(7/2))}
{(1 + x)^(5/2)/(1 - x)^(15/2), x, 4, (1 + x)^(7/2)/(13*(1 - x)^(13/2)) + (3*(1 + x)^(7/2))/(143*(1 - x)^(11/2)) + (2*(1 + x)^(7/2))/(429*(1 - x)^(9/2)) + (2*(1 + x)^(7/2))/(3003*(1 - x)^(7/2))}
{(1 + x)^(5/2)/(1 - x)^(17/2), x, 5, (1 + x)^(7/2)/(15*(1 - x)^(15/2)) + (4*(1 + x)^(7/2))/(195*(1 - x)^(13/2)) + (4*(1 + x)^(7/2))/(715*(1 - x)^(11/2)) + (8*(1 + x)^(7/2))/(6435*(1 - x)^(9/2)) + (8*(1 + x)^(7/2))/(45045*(1 - x)^(7/2))}
{(1 + x)^(5/2)/(1 - x)^(19/2), x, 6, (1 + x)^(7/2)/(17*(1 - x)^(17/2)) + (1 + x)^(7/2)/(51*(1 - x)^(15/2)) + (4*(1 + x)^(7/2))/(663*(1 - x)^(13/2)) + (4*(1 + x)^(7/2))/(2431*(1 - x)^(11/2)) + (8*(1 + x)^(7/2))/(21879*(1 - x)^(9/2)) + (8*(1 + x)^(7/2))/(153153*(1 - x)^(7/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(1 - x)^(7/2)/(1 + x)^(1/2), x, 5, (35/8)*Sqrt[1 - x]*Sqrt[1 + x] + (35/24)*(1 - x)^(3/2)*Sqrt[1 + x] + (7/12)*(1 - x)^(5/2)*Sqrt[1 + x] + (1/4)*(1 - x)^(7/2)*Sqrt[1 + x] + (35*ArcSin[x])/8}
{(1 - x)^(5/2)/(1 + x)^(1/2), x, 4, (5/2)*Sqrt[1 - x]*Sqrt[1 + x] + (5/6)*(1 - x)^(3/2)*Sqrt[1 + x] + (1/3)*(1 - x)^(5/2)*Sqrt[1 + x] + (5*ArcSin[x])/2}
{(1 - x)^(3/2)/(1 + x)^(1/2), x, 3, (3/2)*Sqrt[1 - x]*Sqrt[1 + x] + (1/2)*(1 - x)^(3/2)*Sqrt[1 + x] + (3*ArcSin[x])/2}
{(1 - x)^(1/2)/(1 + x)^(1/2), x, 2, Sqrt[1 - x]*Sqrt[1 + x] + ArcSin[x]}
{1/((1 - x)^(1/2)*(1 + x)^(1/2)), x, 1, ArcSin[x]}
{1/((1 - x)^(3/2)*(1 + x)^(1/2)), x, 1, Sqrt[1 + x]/Sqrt[1 - x]}
{1/((1 - x)^(5/2)*(1 + x)^(1/2)), x, 2, Sqrt[1 + x]/(3*(1 - x)^(3/2)) + Sqrt[1 + x]/(3*Sqrt[1 - x])}
{1/((1 - x)^(7/2)*(1 + x)^(1/2)), x, 3, Sqrt[1 + x]/(5*(1 - x)^(5/2)) + (2*Sqrt[1 + x])/(15*(1 - x)^(3/2)) + (2*Sqrt[1 + x])/(15*Sqrt[1 - x])}
{1/((1 - x)^(9/2)*(1 + x)^(1/2)), x, 4, Sqrt[1 + x]/(7*(1 - x)^(7/2)) + (3*Sqrt[1 + x])/(35*(1 - x)^(5/2)) + (2*Sqrt[1 + x])/(35*(1 - x)^(3/2)) + (2*Sqrt[1 + x])/(35*Sqrt[1 - x])}
{1/((1 - x)^(11/2)*(1 + x)^(1/2)), x, 5, Sqrt[1 + x]/(9*(1 - x)^(9/2)) + (4*Sqrt[1 + x])/(63*(1 - x)^(7/2)) + (4*Sqrt[1 + x])/(105*(1 - x)^(5/2)) + (8*Sqrt[1 + x])/(315*(1 - x)^(3/2)) + (8*Sqrt[1 + x])/(315*Sqrt[1 - x])}


{(1 - x)^(7/2)/(1 + x)^(3/2), x, 5, -((2*(1 - x)^(7/2))/Sqrt[1 + x]) - (35/2)*Sqrt[1 - x]*Sqrt[1 + x] - (35/6)*(1 - x)^(3/2)*Sqrt[1 + x] - (7/3)*(1 - x)^(5/2)*Sqrt[1 + x] - (35*ArcSin[x])/2}
{(1 - x)^(5/2)/(1 + x)^(3/2), x, 4, -((2*(1 - x)^(5/2))/Sqrt[1 + x]) - (15/2)*Sqrt[1 - x]*Sqrt[1 + x] - (5/2)*(1 - x)^(3/2)*Sqrt[1 + x] - (15*ArcSin[x])/2}
{(1 - x)^(3/2)/(1 + x)^(3/2), x, 3, -((2*(1 - x)^(3/2))/Sqrt[1 + x]) - 3*Sqrt[1 - x]*Sqrt[1 + x] - 3*ArcSin[x]}
{(1 - x)^(1/2)/(1 + x)^(3/2), x, 2, -((2*Sqrt[1 - x])/Sqrt[1 + x]) - ArcSin[x]}
{1/((1 - x)^(1/2)*(1 + x)^(3/2)), x, 1, -(Sqrt[1 - x]/Sqrt[1 + x])}
{1/((1 - x)^(3/2)*(1 + x)^(3/2)), x, 2, x/Sqrt[1 - x^2]}
{1/((1 - x)^(5/2)*(1 + x)^(3/2)), x, 3, 1/(3*(1 - x)^(3/2)*Sqrt[1 + x]) + (2*x)/(3*Sqrt[1 - x^2])}
{1/((1 - x)^(7/2)*(1 + x)^(3/2)), x, 4, 1/(5*(1 - x)^(5/2)*Sqrt[1 + x]) + 1/(5*(1 - x)^(3/2)*Sqrt[1 + x]) + (2*x)/(5*Sqrt[1 - x^2])}
{1/((1 - x)^(9/2)*(1 + x)^(3/2)), x, 5, 1/(7*(1 - x)^(7/2)*Sqrt[1 + x]) + 4/(35*(1 - x)^(5/2)*Sqrt[1 + x]) + 4/(35*(1 - x)^(3/2)*Sqrt[1 + x]) + (8*x)/(35*Sqrt[1 - x^2])}
{1/((1 - x)^(11/2)*(1 + x)^(3/2)), x, 6, 1/(9*(1 - x)^(9/2)*Sqrt[1 + x]) + 5/(63*(1 - x)^(7/2)*Sqrt[1 + x]) + 4/(63*(1 - x)^(5/2)*Sqrt[1 + x]) + 4/(63*(1 - x)^(3/2)*Sqrt[1 + x]) + (8*x)/(63*Sqrt[1 - x^2])}


{(1 - x)^(9/2)/(1 + x)^(5/2), x, 6, -((2*(1 - x)^(9/2))/(3*(1 + x)^(3/2))) + (6*(1 - x)^(7/2))/Sqrt[1 + x] + (105/2)*Sqrt[1 - x]*Sqrt[1 + x] + (35/2)*(1 - x)^(3/2)*Sqrt[1 + x] + 7*(1 - x)^(5/2)*Sqrt[1 + x] + (105*ArcSin[x])/2}
{(1 - x)^(7/2)/(1 + x)^(5/2), x, 5, -((2*(1 - x)^(7/2))/(3*(1 + x)^(3/2))) + (14*(1 - x)^(5/2))/(3*Sqrt[1 + x]) + (35/2)*Sqrt[1 - x]*Sqrt[1 + x] + (35/6)*(1 - x)^(3/2)*Sqrt[1 + x] + (35*ArcSin[x])/2}
{(1 - x)^(5/2)/(1 + x)^(5/2), x, 4, -((2*(1 - x)^(5/2))/(3*(1 + x)^(3/2))) + (10*(1 - x)^(3/2))/(3*Sqrt[1 + x]) + 5*Sqrt[1 - x]*Sqrt[1 + x] + 5*ArcSin[x]}
{(1 - x)^(3/2)/(1 + x)^(5/2), x, 3, -((2*(1 - x)^(3/2))/(3*(1 + x)^(3/2))) + (2*Sqrt[1 - x])/Sqrt[1 + x] + ArcSin[x]}
{(1 - x)^(1/2)/(1 + x)^(5/2), x, 1, -((1 - x)^(3/2)/(3*(1 + x)^(3/2)))}
{1/((1 - x)^(1/2)*(1 + x)^(5/2)), x, 2, -(Sqrt[1 - x]/(3*(1 + x)^(3/2))) - Sqrt[1 - x]/(3*Sqrt[1 + x])}
{1/((1 - x)^(3/2)*(1 + x)^(5/2)), x, 3, 1/(Sqrt[1 - x]*(1 + x)^(3/2)) - (2*Sqrt[1 - x])/(3*(1 + x)^(3/2)) - (2*Sqrt[1 - x])/(3*Sqrt[1 + x])}
{1/((1 - x)^(5/2)*(1 + x)^(5/2)), x, 3, x/(3*(1 - x^2)^(3/2)) + (2*x)/(3*Sqrt[1 - x^2])}
{1/((1 - x)^(7/2)*(1 + x)^(5/2)), x, 4, 1/(5*(1 - x)^(5/2)*(1 + x)^(3/2)) + (4*x)/(15*(1 - x^2)^(3/2)) + (8*x)/(15*Sqrt[1 - x^2])}
{1/((1 - x)^(9/2)*(1 + x)^(5/2)), x, 5, 1/(7*(1 - x)^(7/2)*(1 + x)^(3/2)) + 1/(7*(1 - x)^(5/2)*(1 + x)^(3/2)) + (4*x)/(21*(1 - x^2)^(3/2)) + (8*x)/(21*Sqrt[1 - x^2])}
{1/((1 - x)^(11/2)*(1 + x)^(5/2)), x, 6, 1/(9*(1 - x)^(9/2)*(1 + x)^(3/2)) + 2/(21*(1 - x)^(7/2)*(1 + x)^(3/2)) + 2/(21*(1 - x)^(5/2)*(1 + x)^(3/2)) + (8*x)/(63*(1 - x^2)^(3/2)) + (16*x)/(63*Sqrt[1 - x^2])}


(* Integrands of the form (3-x)^m*(-2+x)^m == (-6+5*x-x^2)^m where m is a half-integer *)
{(3 - x)^(3/2)*(-2 + x)^(3/2), x, 4, (-(3/64))*(5 - 2*x)*Sqrt[-6 + 5*x - x^2] - (1/8)*(5 - 2*x)*(-6 + 5*x - x^2)^(3/2) - (3/128)*ArcSin[5 - 2*x]}
{Sqrt[3 - x]*Sqrt[-2 + x], x, 3, (-(1/4))*(5 - 2*x)*Sqrt[-6 + 5*x - x^2] - (1/8)*ArcSin[5 - 2*x]}
{1/(Sqrt[3 - x]*Sqrt[-2 + x]), x, 1, -ArcSin[5 - 2*x]}
{1/((3 - x)^(3/2)*(-2 + x)^(3/2)), x, 2, -((2*(5 - 2*x))/Sqrt[-6 + 5*x - x^2])}
{1/((3 - x)^(5/2)*(-2 + x)^(5/2)), x, 3, -((2*(5 - 2*x))/(3*(-6 + 5*x - x^2)^(3/2))) - (16*(5 - 2*x))/(3*Sqrt[-6 + 5*x - x^2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^(m/4) (c+d x)^(n/4)*)


(* ::Subsubsection:: *)
(*n>0*)


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c + d*x)^(5/4)/(a + b*x)^(1/4), x, 6, (5*(b*c - a*d)*(a + b*x)^(3/4)*(c + d*x)^(1/4))/(8*b^2) + ((a + b*x)^(3/4)*(c + d*x)^(5/4))/(2*b) - (5*(b*c - a*d)^2*ArcTan[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(16*b^(9/4)*d^(3/4)) + (5*(b*c - a*d)^2*ArcTanh[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(16*b^(9/4)*d^(3/4))}
{(c + d*x)^(1/4)/(a + b*x)^(1/4), x, 5, ((a + b*x)^(3/4)*(c + d*x)^(1/4))/b - ((b*c - a*d)*ArcTan[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(2*b^(5/4)*d^(3/4)) + ((b*c - a*d)*ArcTanh[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(2*b^(5/4)*d^(3/4))}
{1/((a + b*x)^(1/4)*(c + d*x)^(3/4)), x, 4, -((2*ArcTan[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(b^(1/4)*d^(3/4))) + (2*ArcTanh[(d^(1/4)*(a + b*x)^(1/4))/(b^(1/4)*(c + d*x)^(1/4))])/(b^(1/4)*d^(3/4))}
{1/((a + b*x)^(1/4)*(c + d*x)^(7/4)), x, 1, (4*(a + b*x)^(3/4))/(3*(b*c - a*d)*(c + d*x)^(3/4))}
{1/((a + b*x)^(1/4)*(c + d*x)^(11/4)), x, 2, (4*(a + b*x)^(3/4))/(7*(b*c - a*d)*(c + d*x)^(7/4)) + (16*b*(a + b*x)^(3/4))/(21*(b*c - a*d)^2*(c + d*x)^(3/4))}
{1/((a + b*x)^(1/4)*(c + d*x)^(15/4)), x, 3, (4*(a + b*x)^(3/4))/(11*(b*c - a*d)*(c + d*x)^(11/4)) + (32*b*(a + b*x)^(3/4))/(77*(b*c - a*d)^2*(c + d*x)^(7/4)) + (128*b^2*(a + b*x)^(3/4))/(231*(b*c - a*d)^3*(c + d*x)^(3/4))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^n where n is symbolic*)


{(a + b*x)^3*(c + d*x)^n, x, 2, -(((b*c - a*d)^3*(c + d*x)^(1 + n))/(d^4*(1 + n))) + (3*b*(b*c - a*d)^2*(c + d*x)^(2 + n))/(d^4*(2 + n)) - (3*b^2*(b*c - a*d)*(c + d*x)^(3 + n))/(d^4*(3 + n)) + (b^3*(c + d*x)^(4 + n))/(d^4*(4 + n))}
{(a + b*x)^2*(c + d*x)^n, x, 2, ((b*c - a*d)^2*(c + d*x)^(1 + n))/(d^3*(1 + n)) - (2*b*(b*c - a*d)*(c + d*x)^(2 + n))/(d^3*(2 + n)) + (b^2*(c + d*x)^(3 + n))/(d^3*(3 + n))}
{(a + b*x)^1*(c + d*x)^n, x, 2, -(((b*c - a*d)*(c + d*x)^(1 + n))/(d^2*(1 + n))) + (b*(c + d*x)^(2 + n))/(d^2*(2 + n))}
{(a + b*x)^0*(c + d*x)^n, x, 1, (c + d*x)^(1 + n)/(d*(1 + n))}
{(c + d*x)^n/(a + b*x)^1, x, 1, -(((c + d*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/((b*c - a*d)*(1 + n)))}
{(c + d*x)^n/(a + b*x)^2, x, 2, -((c + d*x)^(1 + n)/((b*c - a*d)*(a + b*x))) - (d*n*(c + d*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/((b*c - a*d)^2*(1 + n))}
{(c + d*x)^n/(a + b*x)^3, x, 3, -((c + d*x)^(1 + n)/(2*(b*c - a*d)*(a + b*x)^2)) + (d*(1 - n)*(c + d*x)^(1 + n))/(2*(b*c - a*d)^2*(a + b*x)) + (d^2*(1 - n)*n*(c + d*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/(2*(b*c - a*d)^3*(1 + n))}


{(a + b*x)^(-4 + n)/(c + d*x)^n, x, 3, -(((a + b*x)^(-3 + n)*(c + d*x)^(1 - n))/((b*c - a*d)*(3 - n))) + (2*d*(a + b*x)^(-2 + n)*(c + d*x)^(1 - n))/((b*c - a*d)^2*(2 - n)*(3 - n)) - (2*d^2*(a + b*x)^(-1 + n)*(c + d*x)^(1 - n))/((b*c - a*d)^3*(1 - n)*(2 - n)*(3 - n))}
{(a + b*x)^(-3 + n)/(c + d*x)^n, x, 2, -(((a + b*x)^(-2 + n)*(c + d*x)^(1 - n))/((b*c - a*d)*(2 - n))) + (d*(a + b*x)^(-1 + n)*(c + d*x)^(1 - n))/((b*c - a*d)^2*(1 - n)*(2 - n))}
{(a + b*x)^(-2 + n)/(c + d*x)^n, x, 1, -(((a + b*x)^(-1 + n)*(c + d*x)^(1 - n))/((b*c - a*d)*(1 - n)))}
{(a + b*x)^(-1 + n)/(c + d*x)^n, x, 2, ((a + b*x)^n*(c + d*x)^(1 - n))/((b*c - a*d)*n) - ((a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*((b*c - a*d)*(1 - n)*n))}
{(a + b*x)^(0 + n)/(c + d*x)^n, x, 1, ((a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(d*(1 - n)))}
{(a + b*x)^(1 + n)/(c + d*x)^n, x, 2, ((a + b*x)^(1 + n)*(c + d*x)^(1 - n))/(2*d) - ((b*c - a*d)*(1 + n)*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(2*d^2*(1 - n)))}
{(a + b*x)^(2 + n)/(c + d*x)^n, x, 3, -(((b*c - a*d)*(2 + n)*(a + b*x)^(1 + n)*(c + d*x)^(1 - n))/(6*d^2)) + ((a + b*x)^(2 + n)*(c + d*x)^(1 - n))/(3*d) + ((b*c - a*d)^2*(1 + n)*(2 + n)*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(6*d^3*(1 - n)))}


{(c + d*x)^n/(a + b*x)^(n + 0), x, 1, ((-((d*(a + b*x))/(b*c - a*d)))^n*(c + d*x)^(1 + n)*Hypergeometric2F1[n, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/((a + b*x)^n*(d*(1 + n)))}
{(c + d*x)^n/(a + b*x)^(n + 1), x, 2, -((c + d*x)^(1 + n)/((a + b*x)^n*((b*c - a*d)*n))) + ((-((d*(a + b*x))/(b*c - a*d)))^n*(c + d*x)^(1 + n)*Hypergeometric2F1[n, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/((a + b*x)^n*((b*c - a*d)*n*(1 + n)))}
{(c + d*x)^n/(a + b*x)^(n + 2), x, 1, -(((a + b*x)^(-1 - n)*(c + d*x)^(1 + n))/((b*c - a*d)*(1 + n)))}
{(c + d*x)^n/(a + b*x)^(n + 3), x, 2, -(((a + b*x)^(-2 - n)*(c + d*x)^(1 + n))/((b*c - a*d)*(2 + n))) + (d*(a + b*x)^(-1 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^2*(1 + n)*(2 + n))}
{(c + d*x)^n/(a + b*x)^(n + 4), x, 3, -(((a + b*x)^(-3 - n)*(c + d*x)^(1 + n))/((b*c - a*d)*(3 + n))) + (2*d*(a + b*x)^(-2 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^2*(2 + n)*(3 + n)) - (2*d^2*(a + b*x)^(-1 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^3*(1 + n)*(2 + n)*(3 + n))}
{(c + d*x)^n/(a + b*x)^(n + 5), x, 4, -(((a + b*x)^(-4 - n)*(c + d*x)^(1 + n))/((b*c - a*d)*(4 + n))) + (3*d*(a + b*x)^(-3 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^2*(3 + n)*(4 + n)) - (6*d^2*(a + b*x)^(-2 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^3*(2 + n)*(3 + n)*(4 + n)) + (6*d^3*(a + b*x)^(-1 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^4*(1 + n)*(2 + n)*(3 + n)*(4 + n))}


{(a + b*x)^n/(c + d*x)^(n + 0), x, 1, ((a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(d*(1 - n)))}
{(a + b*x)^n/(c + d*x)^(n + 1), x, 2, (a + b*x)^(1 + n)/((c + d*x)^n*((b*c - a*d)*n)) - (b*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(d*(b*c - a*d)*(1 - n)*n))}
{(a + b*x)^n/(c + d*x)^(n + 2), x, 1, ((a + b*x)^(1 + n)*(c + d*x)^(-1 - n))/((b*c - a*d)*(1 + n))}
{(a + b*x)^n/(c + d*x)^(n + 3), x, 2, ((a + b*x)^(1 + n)*(c + d*x)^(-2 - n))/((b*c - a*d)*(2 + n)) + (b*(a + b*x)^(1 + n)*(c + d*x)^(-1 - n))/((b*c - a*d)^2*(1 + n)*(2 + n))}
{(a + b*x)^n/(c + d*x)^(n + 4), x, 3, ((a + b*x)^(1 + n)*(c + d*x)^(-3 - n))/((b*c - a*d)*(3 + n)) + (2*b*(a + b*x)^(1 + n)*(c + d*x)^(-2 - n))/((b*c - a*d)^2*(2 + n)*(3 + n)) + (2*b^2*(a + b*x)^(1 + n)*(c + d*x)^(-1 - n))/((b*c - a*d)^3*(1 + n)*(2 + n)*(3 + n))}
{(a + b*x)^n/(c + d*x)^(n + 5), x, 4, ((a + b*x)^(1 + n)*(c + d*x)^(-4 - n))/((b*c - a*d)*(4 + n)) + (3*b*(a + b*x)^(1 + n)*(c + d*x)^(-3 - n))/((b*c - a*d)^2*(3 + n)*(4 + n)) + (6*b^2*(a + b*x)^(1 + n)*(c + d*x)^(-2 - n))/((b*c - a*d)^3*(2 + n)*(3 + n)*(4 + n)) + (6*b^3*(a + b*x)^(1 + n)*(c + d*x)^(-1 - n))/((b*c - a*d)^4*(1 + n)*(2 + n)*(3 + n)*(4 + n))}


{(a + b*x)^(n - 2)/(c + d*x)^(n - 1), x, 4, (d*(a + b*x)^n*(c + d*x)^(1 - n))/(b*(b*c - a*d)*(1 - n)*n) - ((a + b*x)^(-1 + n)*(c + d*x)^(2 - n))/((b*c - a*d)*(1 - n)) - (d*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(b*(b*c - a*d)*(1 - n)*n)), (d*(a + b*x)^n*(c + d*x)^(1 - n))/(b*(b*c - a*d)*(1 - n)) + (d*(a + b*x)^n*(c + d*x)^(1 - n))/(b*(b*c - a*d)*n) - ((a + b*x)^(-1 + n)*(c + d*x)^(2 - n))/((b*c - a*d)*(1 - n)) - (d*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(b*(b*c - a*d)*(1 - n)*n))}


{(a + b*x)^(n + 1)/(c + d*x)^(n + 1), x, 3, -((a + b*x)^(1 + n)/((c + d*x)^n*(d*n))) + (b*(1 + n)*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(d^2*(1 - n)*n)), (a + b*x)^(1 + n)/((c + d*x)^n*d) - ((1 + n)*(a + b*x)^(1 + n))/((c + d*x)^n*(d*n)) + (b*(1 + n)*(a + b*x)^n*(c + d*x)^(1 - n)*Hypergeometric2F1[1 - n, -n, 2 - n, (b*(c + d*x))/(b*c - a*d)])/((-((d*(a + b*x))/(b*c - a*d)))^n*(d^2*(1 - n)*n))}


(* ::Section::Closed:: *)
(*Integrands of the form (a+b x)^m (c+d x)^n when b c-a d=0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (a+b x)^m (a d/b+d x)^n when b c-a d=0*)


{(a + b*x)^5/(a*d/b + d*x)^3, x, 2, (b^2*(a + b*x)^3)/(3*d^3)}
{(a + b*x)^4/(a*d/b + d*x)^3, x, 2, (a*b^3*x)/d^3 + (b^4*x^2)/(2*d^3)}
{(a + b*x)^3/(a*d/b + d*x)^3, x, 2, (b^3*x)/d^3}
{(a + b*x)^2/(a*d/b + d*x)^3, x, 2, (b^2*Log[a + b*x])/d^3}
{(a + b*x)^1/(a*d/b + d*x)^3, x, 2, -(b^2/(d^3*(a + b*x)))}
{1/((a + b*x)*(a*d/b + d*x)^3), x, 2, -(b^2/(3*d^3*(a + b*x)^3))}
{1/((a + b*x)^2*(a*d/b + d*x)^3), x, 2, -(b^2/(4*d^3*(a + b*x)^4))}
{1/((a + b*x)^3*(a*d/b + d*x)^3), x, 2, -(b^2/(5*d^3*(a + b*x)^5))}

{(b*c/d + b*x)^5/(c + d*x)^3, x, 2, (b^5*(c + d*x)^3)/(3*d^6)}
{(b*c/d + b*x)^4/(c + d*x)^3, x, 2, (b^4*c*x)/d^4 + (b^4*x^2)/(2*d^3)}
{(b*c/d + b*x)^3/(c + d*x)^3, x, 2, (b^3*x)/d^3}
{(b*c/d + b*x)^2/(c + d*x)^3, x, 2, (b^2*Log[c + d*x])/d^3}
{(b*c/d + b*x)^1/(c + d*x)^3, x, 2, -(b/(d^2*(c + d*x)))}
{1/((b*c/d + b*x)*(c + d*x)^3), x, 2, -(1/(3*b*(c + d*x)^3))}
{1/((b*c/d + b*x)^2*(c + d*x)^3), x, 2, -(d/(4*b^2*(c + d*x)^4))}
{1/((b*c/d + b*x)^3*(c + d*x)^3), x, 2, -(d^2/(5*b^3*(c + d*x)^5))}


{(a + b*x)^5*(a*c + b*c*x)^n, x, 2, (a*c + b*c*x)^(6 + n)/(b*c^6*(6 + n))}

{(a + b*x)^5*(a*c + b*c*x)^3, x, 2, (c^3*(a + b*x)^9)/(9*b)}
{(a + b*x)^5*(a*c + b*c*x)^2, x, 2, (c^2*(a + b*x)^8)/(8*b)}
{(a + b*x)^5*(a*c + b*c*x)^1, x, 2, (c*(a + b*x)^7)/(7*b)}
{(a + b*x)^5/(a*c + b*c*x)^1, x, 2, (a + b*x)^5/(5*b*c)}
{(a + b*x)^5/(a*c + b*c*x)^2, x, 2, (a + b*x)^4/(4*b*c^2)}
{(a + b*x)^5/(a*c + b*c*x)^3, x, 2, (a + b*x)^3/(3*b*c^3)}
{(a + b*x)^5/(a*c + b*c*x)^4, x, 2, (a*x)/c^4 + (b*x^2)/(2*c^4)}
{(a + b*x)^5/(a*c + b*c*x)^5, x, 2, x/c^5}
{(a + b*x)^5/(a*c + b*c*x)^6, x, 2, Log[a + b*x]/(b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^7, x, 2, -(1/(b*c^7*(a + b*x)))}
{(a + b*x)^5/(a*c + b*c*x)^8, x, 2, -(1/(2*b*c^8*(a + b*x)^2))}


{1/(Sqrt[-2 - 3*x]*Sqrt[2 + 3*x]), x, 2, (Sqrt[2 + 3*x]*Log[2 + 3*x])/(3*Sqrt[-2 - 3*x])}


(* ::Title:: *)
(*Multinomial integrands*)


(* ::Section::Closed:: *)
(*Polynomial integrands*)


{a + b*x + c*x^2 + d*x^3, x, 1, a*x + (b*x^2)/2 + (c*x^3)/3 + (d*x^4)/4}
{-x^3 + x^4, x, 1, -(x^4/4) + x^5/5}
{-1 + x^5, x, 1, -x + x^6/6}
{7 + 4*x, x, 1, 7*x + 2*x^2}
{4*x + Pi*x^3, x, 1, 2*x^2 + (Pi*x^4)/4}
{2*x + 5*x^2, x, 1, x^2 + (5*x^3)/3}
{x^2/2 + x^3/3, x, 1, x^3/6 + x^4/12}
{3 - 5*x + 2*x^2, x, 1, 3*x - (5*x^2)/2 + (2*x^3)/3}
{-2*x + x^2 + x^3, x, 1, -x^2 + x^3/3 + x^4/4}
{1 - x^2 - 3*x^5, x, 1, x - x^3/3 - x^6/2}
{5 + 2*x + 3*x^2 + 4*x^3, x, 1, 5*x + x^2 + x^3 + x^4}


(* ::Section::Closed:: *)
(*Multinomial integrands*)


{a + b/x + c/x^2 + d/x^3, x, 1, -(d/(2*x^2)) - c/x + a*x + b*Log[x]}
{x^(-5) + x + x^5, x, 1, -(1/(4*x^4)) + x^2/2 + x^6/6}
{x^(-3) + x^(-2) + x^(-1), x, 1, -(1/(2*x^2)) - 1/x + Log[x]}
{-2/x^2 + 3/x, x, 1, 2/x + 3*Log[x]}
{-1/(7*x^6) + x^6, x, 1, 1/(35*x^5) + x^7/7}
{1 + x^(-1) + x, x, 1, x + x^2/2 + Log[x]}
{-3/x^3 + 4/x^2, x, 1, 3/(2*x^2) - 4/x}
{x^(-1) + 2*x + x^2, x, 1, x^2 + x^3/3 + Log[x]}


{x^(5/6) - x^3, x, 1, (6*x^(11/6))/11 - x^4/4}
{33 + x^(1/33), x, 1, 33*x + (33*x^(34/33))/34}
{1/(2*Sqrt[x]) + 2*Sqrt[x], x, 1, Sqrt[x] + (4*x^(3/2))/3}
{-x^(-2) + 10/x + 6*Sqrt[x], x, 1, x^(-1) + 4*x^(3/2) + 10*Log[x]}
{x^(-3/2) + x^(3/2), x, 1, -(2/Sqrt[x]) + (2*x^(5/2))/5}
{-5*x^(3/2) + 7*x^(5/2), x, 1, -2*x^(5/2) + 2*x^(7/2)}
{2/Sqrt[x] + Sqrt[x] - x/2, x, 1, 4*Sqrt[x] + (2*x^(3/2))/3 - x^2/4}
{-2/x + Sqrt[x]/5 + x^(3/2), x, 1, (2*x^(3/2))/15 + (2*x^(5/2))/5 - 2*Log[x]}
